/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.collect.NewSet;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.exceptions.StepInitialisationException;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.EnclosingClass;
import net.thucydides.core.steps.Interceptor;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.ProxyConfiguration;
import net.thucydides.core.steps.RecursiveOrCyclicStepLibraryReferenceException;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepInterceptor;
import net.thucydides.core.steps.construction.ConstructionStrategy;
import net.thucydides.core.steps.construction.StepLibraryConstructionStrategy;
import net.thucydides.core.steps.construction.StepLibraryType;
import net.thucydides.core.steps.di.DependencyInjectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFactory {
    private static final boolean WITH_NO_CACHING = false;
    private static final boolean WITH_CACHING = true;
    private Pages pages;
    private final Map<Class<?>, Object> index = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(StepFactory.class);
    private final DependencyInjectorService dependencyInjectorService;
    private static ThreadLocal<StepFactory> currentStepFactory = ThreadLocal.withInitial(() -> new StepFactory());
    private Method privateLookupIn;
    private Object lookup;
    private final ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
    private TypeCache<TypeCache.SimpleKey> proxyCache;
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
        this.dependencyInjectorService = (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
        this.proxyCache = new TypeCache.WithInlineExpunction(TypeCache.Sort.WEAK);
        try {
            if (ClassInjector.UsingLookup.isAvailable()) {
                Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                this.lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
                this.privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Cannot get privateLookupIn method ClassInjector using lookup", (Throwable)e);
            throw new IllegalStateException("No code generation strategy available");
        }
    }

    public StepFactory() {
        this(null);
    }

    public static StepFactory getFactory() {
        return currentStepFactory.get();
    }

    public StepFactory usingPages(Pages pages) {
        this.pages = pages;
        return this;
    }

    public <T> T getSharedStepLibraryFor(Class<T> scenarioStepsClass) {
        if (this.isStepLibraryInstantiatedFor(scenarioStepsClass)) {
            return this.getStepLibraryFromCacheFor(scenarioStepsClass);
        }
        return this.getNewCachedStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getNewStepLibraryFor(Class<T> scenarioStepsClass) {
        try {
            return this.instantiateNewStepLibraryFor(scenarioStepsClass, false);
        }
        catch (RecursiveOrCyclicStepLibraryReferenceException recurciveCallException) {
            throw recurciveCallException;
        }
        catch (RuntimeException stepCreationFailed) {
            throw new StepInitialisationException("Failed to create step library for " + scenarioStepsClass.getSimpleName() + ":" + stepCreationFailed.getMessage(), stepCreationFailed);
        }
    }

    public <T> T getNewCachedStepLibraryFor(Class<T> scenarioStepsClass) {
        try {
            return this.instantiateNewStepLibraryFor(scenarioStepsClass, true);
        }
        catch (RecursiveOrCyclicStepLibraryReferenceException recursiveCallException) {
            throw recursiveCallException;
        }
        catch (RuntimeException stepCreationFailed) {
            throw new StepInitialisationException("Failed to create step library for " + scenarioStepsClass.getSimpleName() + ":" + stepCreationFailed.getMessage(), stepCreationFailed);
        }
    }

    public <T> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass, new Object[0]);
    }

    public <T> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass, Object ... parameters) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass, parameters);
    }

    public void reset() {
        this.index.clear();
    }

    private boolean isStepLibraryInstantiatedFor(Class<?> scenarioStepsClass) {
        return this.index.containsKey(scenarioStepsClass);
    }

    private <T> T getStepLibraryFromCacheFor(Class<T> scenarioStepsClass) {
        return (T)this.index.get(scenarioStepsClass);
    }

    public <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass, boolean cacheNewInstance) {
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        return this.instantiateNewStepLibraryFor(scenarioStepsClass, stepInterceptor, cacheNewInstance);
    }

    public <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass, Interceptor interceptor, boolean useCache) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass, interceptor, new Object[0]);
        if (useCache) {
            this.indexStepLibrary(scenarioStepsClass, steps);
        }
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.injectOtherDependenciesInto(steps);
        return steps;
    }

    private <T> void injectOtherDependenciesInto(T steps) {
        List dependencyInjectors = this.dependencyInjectorService.findDependencyInjectors();
        dependencyInjectors.addAll(this.getDefaultDependencyInjectors());
        for (DependencyInjector dependencyInjector : dependencyInjectors) {
            dependencyInjector.injectDependenciesInto(steps);
        }
    }

    private List<? extends DependencyInjector> getDefaultDependencyInjectors() {
        return this.pages != null ? NewList.of((Object[])new DependencyInjector[]{new PageObjectDependencyInjector(this.pages), new EnvironmentDependencyInjector()}) : NewList.of((Object[])new EnvironmentDependencyInjector[]{new EnvironmentDependencyInjector()});
    }

    private <T> T instantiateUniqueStepLibraryFor(Class<T> scenarioStepsClass, Object ... parameters) {
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        T steps = this.createProxyStepLibrary(scenarioStepsClass, stepInterceptor, parameters);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        this.injectOtherDependenciesInto(steps);
        return steps;
    }

    private <T> T createProxyStepLibrary(Class<T> scenarioStepsClass, Interceptor interceptor, Object ... parameters) {
        TypeCache.SimpleKey cacheKey = this.getCacheKey(scenarioStepsClass, interceptor.getClass());
        Class<?> proxyClass = this.load(scenarioStepsClass, this.proxyCache, cacheKey, byteBuddy -> byteBuddy.subclass(scenarioStepsClass).defineField("$$_serenity_interceptor", Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class))).intercept((Implementation)MethodDelegation.to(ProxyConfiguration.InterceptorDispatcher.class)).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)FieldAccessor.ofField((String)"$$_serenity_interceptor").withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC)));
        try {
            ConstructionStrategy strategy = StepLibraryConstructionStrategy.forClass(scenarioStepsClass).getStrategy();
            if (ConstructionStrategy.STEP_LIBRARY_WITH_WEBDRIVER.equals((Object)strategy)) {
                return this.webEnabledStepLibrary(scenarioStepsClass, proxyClass, interceptor);
            }
            if (ConstructionStrategy.STEP_LIBRARY_WITH_PAGES.equals((Object)strategy)) {
                return this.stepLibraryWithPages(scenarioStepsClass, proxyClass, interceptor);
            }
            if (ConstructionStrategy.CONSTRUCTOR_WITH_PARAMETERS.equals((Object)strategy) && parameters.length > 0) {
                return this.immutableStepLibrary(scenarioStepsClass, proxyClass, parameters, interceptor);
            }
            if (ConstructionStrategy.INNER_CLASS_CONSTRUCTOR.equals((Object)strategy)) {
                return this.immutableStepLibrary(scenarioStepsClass, proxyClass, EnclosingClass.of(scenarioStepsClass).asParameters(), interceptor);
            }
            ProxyConfiguration proxy = (ProxyConfiguration)proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            proxy.$$_serenity_set_interceptor(interceptor);
            return (T)proxy;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.error("Cannot create StepFactory for  " + scenarioStepsClass, (Throwable)ex);
            return null;
        }
    }

    private Class<?> load(Class<?> referenceClass, TypeCache<TypeCache.SimpleKey> cache, TypeCache.SimpleKey cacheKey, Function<ByteBuddy, DynamicType.Builder<?>> makeProxyFunction) {
        return cache.findOrInsert(referenceClass.getClassLoader(), (Object)cacheKey, () -> ((DynamicType.Builder)makeProxyFunction.apply(this.byteBuddy)).make().load(referenceClass.getClassLoader(), this.getClassLoadingStrategy(referenceClass)).getLoaded(), cache);
    }

    private ClassLoadingStrategy getClassLoadingStrategy(Class targetClass) {
        try {
            ClassLoadingStrategy.Default strategy;
            if (ClassInjector.UsingLookup.isAvailable()) {
                Object privateLookup = this.privateLookupIn.invoke(null, targetClass, this.lookup);
                strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            } else if (ClassInjector.UsingReflection.isAvailable()) {
                strategy = ClassLoadingStrategy.Default.INJECTION;
            } else {
                throw new IllegalStateException("No code generation strategy available");
            }
            return strategy;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("Cannot get ClassLoadingStrategy  for target class " + targetClass, (Throwable)e);
            throw new IllegalStateException("No code generation strategy available");
        }
    }

    private <T> T immutableStepLibrary(Class<T> scenarioStepsClass, Class proxyClass, Object[] parameters, Interceptor interceptor) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        ProxyConfiguration proxy = (ProxyConfiguration)proxyClass.getDeclaredConstructor(this.argumentTypesFrom(scenarioStepsClass, parameters)).newInstance(parameters);
        proxy.$$_serenity_set_interceptor(interceptor);
        return (T)proxy;
    }

    private Class<?>[] argumentTypesFrom(Class<?> scenarioStepsClass, Object[] parameters) {
        for (Constructor<?> candidateConstructor : this.inOrderOfIncreasingParameters(scenarioStepsClass.getDeclaredConstructors())) {
            Class<?>[] parameterTypes = candidateConstructor.getParameterTypes();
            if (!this.parametersMatchFor(parameters, parameterTypes)) continue;
            return parameterTypes;
        }
        throw new IllegalArgumentException("Could not find a matching constructor for class " + scenarioStepsClass + " with parameters " + Arrays.toString(parameters));
    }

    private Constructor<?>[] inOrderOfIncreasingParameters(Constructor<?>[] declaredConstructors) {
        List sortedConstructors = NewList.of((Object[])declaredConstructors);
        Collections.sort(sortedConstructors, Comparator.comparingInt(o -> o.getParameterTypes().length));
        return sortedConstructors.toArray(new Constructor[0]);
    }

    private boolean parametersMatchFor(Object[] parameters, Class<?>[] parameterTypes) {
        int parameterNumber = 0;
        if (parameters.length != parameterTypes.length) {
            return false;
        }
        for (Class<?> parameterType : parameterTypes) {
            if (parameterNumber >= parameterTypes.length) {
                return false;
            }
            if (this.parameter(parameters[parameterNumber]).cannotBeAssignedTo(parameterType)) {
                return false;
            }
            if (parameters[parameterNumber] != null && !StepFactory.isAssignableFrom(parameters[parameterNumber], parameterType)) {
                return false;
            }
            ++parameterNumber;
        }
        return true;
    }

    private ParameterAssignementChecker parameter(Object parameter) {
        return new ParameterAssignementChecker(parameter);
    }

    private <T> T webEnabledStepLibrary(Class<T> scenarioStepsClass, Class proxyClass, Interceptor interceptor) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        if (StepLibraryType.ofClass(scenarioStepsClass).hasAPagesConstructor()) {
            Object[] arguments = new Object[]{this.pages};
            ProxyConfiguration proxy = (ProxyConfiguration)proxyClass.getDeclaredConstructor(CONSTRUCTOR_ARG_TYPES).newInstance(arguments);
            proxy.$$_serenity_set_interceptor(interceptor);
            return (T)proxy;
        }
        ProxyConfiguration newStepLibrary = (ProxyConfiguration)proxyClass.newInstance();
        newStepLibrary.$$_serenity_set_interceptor(interceptor);
        return (T)this.injectPagesInto(scenarioStepsClass, newStepLibrary);
    }

    private <T> T stepLibraryWithPages(Class<T> scenarioStepsClass, Class proxyClass, Interceptor interceptor) throws IllegalAccessException, InstantiationException {
        ProxyConfiguration newStepLibrary = (ProxyConfiguration)proxyClass.newInstance();
        newStepLibrary.$$_serenity_set_interceptor(interceptor);
        return (T)this.injectPagesInto(scenarioStepsClass, newStepLibrary);
    }

    public void usePageFactory(Pages pages) {
        this.pages = pages;
    }

    private <T> T injectPagesInto(Class<T> stepLibraryClass, T newStepLibrary) {
        return new PageInjector(this.pages).injectPagesInto(stepLibraryClass, newStepLibrary);
    }

    private <T> void indexStepLibrary(Class<T> scenarioStepsClass, T steps) {
        this.index.put(scenarioStepsClass, steps);
    }

    private <T> void instantiateAnyNestedStepLibrariesIn(T steps, Class<T> scenarioStepsClass) {
        StepAnnotations.injector().injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }

    public static boolean isAssignableFrom(Object argument, Class<?> parameterType) {
        if (parameterType.isInterface()) {
            return parameterType.isInstance(argument);
        }
        Class<?> argumentType = argument.getClass();
        if (StepFactory.isByte(parameterType)) {
            return StepFactory.isByte(argumentType);
        }
        if (StepFactory.isShort(parameterType)) {
            return StepFactory.isShort(argumentType) || StepFactory.isByte(argumentType);
        }
        if (StepFactory.isInteger(parameterType)) {
            return StepFactory.isInteger(argumentType) || StepFactory.isShort(argumentType) || StepFactory.isByte(argumentType);
        }
        if (StepFactory.isLong(parameterType)) {
            return StepFactory.isLong(argumentType) || StepFactory.isInteger(argumentType) || StepFactory.isShort(argumentType) || StepFactory.isByte(argumentType);
        }
        if (StepFactory.isFloat(parameterType)) {
            return StepFactory.isFloat(argumentType);
        }
        if (StepFactory.isDouble(parameterType)) {
            return StepFactory.isDouble(argumentType) || StepFactory.isFloat(argumentType);
        }
        if (StepFactory.isBoolean(parameterType)) {
            return StepFactory.isBoolean(argumentType);
        }
        if (StepFactory.isCharacter(parameterType)) {
            return StepFactory.isCharacter(argumentType);
        }
        return parameterType.isAssignableFrom(argumentType);
    }

    private static boolean isInteger(Class<?> fieldType) {
        return fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE);
    }

    private static boolean isFloat(Class<?> fieldType) {
        return fieldType.equals(Float.class) || fieldType.equals(Float.TYPE);
    }

    private static boolean isDouble(Class<?> fieldType) {
        return fieldType.equals(Double.class) || fieldType.equals(Double.TYPE);
    }

    private static boolean isCharacter(Class<?> fieldType) {
        return fieldType.equals(Character.class) || fieldType.equals(Character.TYPE);
    }

    private static boolean isLong(Class<?> fieldType) {
        return fieldType.equals(Long.class) || fieldType.equals(Long.TYPE);
    }

    private static boolean isShort(Class<?> fieldType) {
        return fieldType.equals(Short.class) || fieldType.equals(Short.TYPE);
    }

    private static boolean isBoolean(Class<?> fieldType) {
        return fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE);
    }

    private static boolean isByte(Class<?> fieldType) {
        return fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE);
    }

    private TypeCache.SimpleKey getCacheKey(Class<?> scenarioStepsClass, Class<?> interceptorClass) {
        HashSet key = new HashSet();
        if (scenarioStepsClass != null) {
            key.add(scenarioStepsClass);
        }
        if (interceptorClass != null) {
            key.add(interceptorClass);
        }
        return new TypeCache.SimpleKey(key);
    }

    private class ParameterAssignementChecker {
        private static final boolean PARAMETER_CAN_BE_ASSIGNED = false;
        private final Object parameter;

        public ParameterAssignementChecker(Object parameter) {
            this.parameter = parameter;
        }

        public boolean cannotBeAssignedTo(Class<?> parameterType) {
            if (this.parameter == null) {
                return false;
            }
            return !StepFactory.isAssignableFrom(this.parameter, parameterType);
        }
    }

    static class PageInjector {
        private final Pages pages;

        public PageInjector(Pages pages) {
            this.pages = pages;
        }

        public <T> T injectPagesInto(Class<T> stepLibraryClass, T newStepLibrary) {
            if (ScenarioSteps.class.isAssignableFrom(stepLibraryClass)) {
                ((ScenarioSteps)newStepLibrary).setPages(this.pages);
            } else if (StepLibraryType.ofClass(stepLibraryClass).hasAPagesField()) {
                Set fields = NewSet.copyOf((Collection)Fields.of(stepLibraryClass).allFields());
                Field pagesField = fields.stream().filter(StepLibraryType.ofTypePages()).findFirst().get();
                pagesField.setAccessible(true);
                try {
                    pagesField.set(newStepLibrary, this.pages);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Could not instantiate pages field for step library {}", newStepLibrary);
                }
            }
            return newStepLibrary;
        }
    }
}

