/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import net.serenitybdd.core.IgnoredStepException;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SkipNested;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.steps.HasCustomFieldValues;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.markers.IsSilent;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.CleanupMethodLocator;
import net.thucydides.core.steps.DefaultValue;
import net.thucydides.core.steps.DryRunMethodRunner;
import net.thucydides.core.steps.ErrorConvertor;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.Interceptor;
import net.thucydides.core.steps.MethodErrorReporter;
import net.thucydides.core.steps.MethodRunner;
import net.thucydides.core.steps.NormalMethodRunner;
import net.thucydides.core.steps.ScreenplayInspector;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepName;
import net.thucydides.core.steps.StepNamer;
import net.thucydides.core.steps.interception.DynamicExampleStepInterceptionListener;
import net.thucydides.core.steps.interception.StepInterceptionListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.JUnitAdapter;
import org.apache.commons.lang3.StringUtils;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptor
implements MethodErrorReporter,
Interceptor {
    private final Class<?> testStepClass;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private final EnvironmentVariables environmentVariables;
    private List<StepInterceptionListener> listeners = new ArrayList<StepInterceptionListener>();
    CleanupMethodLocator cleanupMethodLocator;
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize", "getMetaClass");

    StepInterceptor(Class<?> testStepClass) {
        this.testStepClass = testStepClass;
        this.environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
        this.cleanupMethodLocator = new CleanupMethodLocator();
        this.listeners.add(new DynamicExampleStepInterceptionListener());
    }

    @Override
    @RuntimeType
    public Object intercept(@Origin Method method, @This Object target, @AllArguments Object[] args, @SuperMethod Method zuper) throws Throwable {
        Object result = this.baseClassMethod(method, target) ? this.runBaseObjectMethod(target, method, args, zuper) : this.testStepResult(target, method, args, zuper);
        return result;
    }

    private boolean baseClassMethod(Method method, Object obj) {
        Class<?> callingClass = obj.getClass();
        boolean isACoreLanguageMethod = this.OBJECT_METHODS.contains(method.getName());
        boolean methodDoesNotComeFromThisClassOrARelatedParentClass = !this.declaredInSameDomain(method, callingClass);
        boolean isSilentMethod = this.isSilent(callingClass, method, obj);
        return isACoreLanguageMethod || methodDoesNotComeFromThisClassOrARelatedParentClass || isSilentMethod;
    }

    private boolean isSilent(Class callingClass, Method method, Object obj) {
        if (IsSilent.class.isAssignableFrom(callingClass)) {
            return true;
        }
        if (CanBeSilent.class.isAssignableFrom(callingClass) && method.getName().equals("isSilent")) {
            return true;
        }
        if (CanBeSilent.class.isAssignableFrom(callingClass) && ((CanBeSilent)obj).isSilent()) {
            return true;
        }
        if (this.isNestedInSilentTask()) {
            return true;
        }
        return this.isNotAStepAnnotatedMethodWhenManualInstrumentationIsActive(method);
    }

    private boolean isNotAStepAnnotatedMethodWhenManualInstrumentationIsActive(Method method) {
        if (this.manualTaskInstrumentation()) {
            return method.getAnnotation(Step.class) == null;
        }
        return false;
    }

    private boolean manualTaskInstrumentation() {
        return ThucydidesSystemProperty.MANUAL_TASK_INSTRUMENTATION.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }

    private boolean isNestedInSilentTask() {
        return Arrays.asList(new Exception().getStackTrace()).stream().anyMatch(element -> element.getMethodName().equals("performSilently"));
    }

    private boolean declaredInSameDomain(Method method, Class callingClass) {
        return this.domainPackageOf(this.getRoot(method)).equals(this.domainPackageOf(callingClass));
    }

    private String domainPackageOf(Class callingClass) {
        Package classPackage = callingClass.getPackage();
        String classPackageName = classPackage != null ? classPackage.getName() : "";
        return this.packageDomainName(classPackageName);
    }

    private String packageDomainName(String methodPackage) {
        List packages = Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)methodPackage);
        if (packages.size() == 0) {
            return "";
        }
        if (packages.size() == 1) {
            return (String)packages.get(0);
        }
        return (String)packages.get(0) + "." + (String)packages.get(1);
    }

    private String domainPackageOf(Method method) {
        Package methodPackage = method.getDeclaringClass().getPackage();
        String methodPackageName = methodPackage != null ? methodPackage.getName() : "";
        return this.packageDomainName(methodPackageName);
    }

    private Method getRoot(Method method) {
        try {
            method.getClass().getDeclaredField("root").setAccessible(true);
            return (Method)method.getClass().getDeclaredField("root").get(method);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return method;
        }
    }

    private Object testStepResult(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.runNormalMethod(obj, method, args, zuperMethod);
        }
        this.listeners.forEach(listener -> listener.start(obj, method, args, zuperMethod));
        Object result = this.runOrSkipMethod(obj, method, args, zuperMethod);
        this.listeners.forEach(listener -> listener.end(obj, method, args, zuperMethod));
        return result;
    }

    private Object runOrSkipMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        Object result;
        if (this.shouldSkip(method) && !this.stepIsCalledFromCleanupMethod()) {
            result = this.skipStepMethod(obj, method, args, zuperMethod);
        } else {
            this.notifyStepStarted(obj, method, args);
            result = this.runTestStep(obj, method, args, zuperMethod);
        }
        return result;
    }

    private void endDynamicExampleIfPresent() {
    }

    private void startDynamicExampleIfPresent() {
    }

    private boolean stepIsCalledFromCleanupMethod() {
        return this.cleanupMethodLocator.currentMethodWasCalledFromACleanupMethod();
    }

    private Object skipStepMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Exception {
        if ((this.aPreviousStepHasFailed() || this.testAssumptionViolated()) && !this.shouldExecuteNestedStepsAfterFailures()) {
            this.notifySkippedStepStarted(obj, method, args);
            this.notifySkippedStepFinishedFor(method, args);
            return this.appropriateReturnObject(obj, method);
        }
        this.notifySkippedStepStarted(obj, method, args);
        return this.skipTestStep(obj, method, args, zuperMethod);
    }

    private boolean shouldExecuteNestedStepsAfterFailures() {
        return ThucydidesSystemProperty.DEEP_STEP_EXECUTION_AFTER_FAILURES.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }

    private Object skipTestStep(Object obj, Method method, Object[] args, Method zuperMethod) throws Exception {
        Object skippedReturnObject = this.runSkippedMethod(obj, method, args, zuperMethod);
        this.notifyStepSkippedFor(method, args);
        LOGGER.debug("SKIPPED STEP: {}", (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        return this.appropriateReturnObject(skippedReturnObject, obj, method);
    }

    private Object runSkippedMethod(Object obj, Method method, Object[] args, Method zuperMethod) {
        LOGGER.trace("Running test step " + StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        StepEventBus.getEventBus().temporarilySuspendWebdriverCalls();
        Object result = this.runIfNestedMethodsShouldBeRun(obj, method, args, zuperMethod);
        StepEventBus.getEventBus().reenableWebdriverCalls();
        return result;
    }

    private Object runIfNestedMethodsShouldBeRun(Object obj, Method method, Object[] args, Method zuperMethod) {
        Object result = null;
        try {
            if (this.shouldRunNestedMethodsIn(method)) {
                result = this.invokeMethod(obj, args, zuperMethod);
            }
        }
        catch (Throwable anyException) {
            LOGGER.trace("Ignoring exception thrown during a skipped test", anyException);
        }
        return result;
    }

    private boolean shouldRunNestedMethodsIn(Method method) {
        return !TestAnnotations.shouldSkipNested((Method)method) && !this.shouldSkipNestedIn(method.getDeclaringClass());
    }

    private boolean shouldSkipNestedIn(Class testStepClass) {
        return SkipNested.class.isAssignableFrom(testStepClass);
    }

    private Object appropriateReturnObject(Object returnedValue, Object obj, Method method) {
        if (returnedValue != null) {
            return returnedValue;
        }
        return this.appropriateReturnObject(obj, method);
    }

    private PrimitiveReturnType returnTypeOf(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == String.class) {
            return PrimitiveReturnType.STRING;
        }
        if (Long.class.isAssignableFrom(returnType) || returnType.getName().equals("long")) {
            return PrimitiveReturnType.LONG;
        }
        if (Integer.class.isAssignableFrom(returnType) || returnType.getName().equals("int")) {
            return PrimitiveReturnType.INTEGER;
        }
        if (Double.class.isAssignableFrom(returnType) || returnType.getName().equals("double")) {
            return PrimitiveReturnType.DOUBLE;
        }
        if (Float.class.isAssignableFrom(returnType) || returnType.getName().equals("float")) {
            return PrimitiveReturnType.FLOAT;
        }
        if (Boolean.class.isAssignableFrom(returnType) || returnType.getName().equals("boolean")) {
            return PrimitiveReturnType.BOOLEAN;
        }
        if (returnType.getName().equals("void")) {
            return PrimitiveReturnType.VOID;
        }
        return PrimitiveReturnType.UNSUPPORTED;
    }

    Object appropriateReturnObject(Object obj, Method method) {
        if (method.getReturnType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (this.returnTypeIsPrimativeFor(method)) {
            return this.primativeDefaultValueFor(method);
        }
        return this.mockedReturnObjectFor(method);
    }

    private Object mockedReturnObjectFor(Method method) {
        try {
            return Mockito.mock(method.getReturnType());
        }
        catch (RuntimeException tooHardToMockLetsJustCallItQuits) {
            return null;
        }
    }

    private boolean returnTypeIsPrimativeFor(Method method) {
        return this.returnTypeOf(method) != PrimitiveReturnType.UNSUPPORTED;
    }

    private Object primativeDefaultValueFor(Method method) {
        switch (this.returnTypeOf(method)) {
            case VOID: {
                return null;
            }
            case STRING: {
                return "";
            }
            case LONG: {
                return 0L;
            }
            case INTEGER: {
                return 0;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case BOOLEAN: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private boolean shouldSkip(Method methodOrStep) {
        if (this.aPreviousStepHasFailed() && !this.isSoftAssert()) {
            return true;
        }
        return this.testIsPending() || this.isDryRun() || this.isPending(methodOrStep) || this.isIgnored(methodOrStep);
    }

    private boolean testIsPending() {
        return StepEventBus.getEventBus().currentTestIsSuspended();
    }

    private boolean testAssumptionViolated() {
        return StepEventBus.getEventBus().assumptionViolated();
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            aPreviousStepHasFailed = true;
        }
        return aPreviousStepHasFailed;
    }

    private boolean isDryRun() {
        return StepEventBus.getEventBus().isDryRun();
    }

    private boolean isSoftAssert() {
        return StepEventBus.getEventBus().softAssertsActive();
    }

    private Object runBaseObjectMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        return this.invokeMethod(obj, args, zuperMethod);
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        Object result = DefaultValue.defaultReturnValueFor(method, obj);
        return this.withNonStepMethodRunner(method, obj.getClass()).invokeMethodAndNotifyFailures(obj, method, args, zuperMethod, result);
    }

    private MethodRunner withNonStepMethodRunner(Method methodOrStep, Class callingClass) {
        return this.shouldRunInDryRunMode(methodOrStep, callingClass) ? new DryRunMethodRunner() : new NormalMethodRunner(this);
    }

    private boolean shouldRunInDryRunMode(Method methodOrStep, Class callingClass) {
        return (this.aPreviousStepHasFailed() || this.testIsPending() || this.isDryRun()) && this.declaredInSameDomain(methodOrStep, callingClass);
    }

    @Override
    public void reportMethodError(Throwable generalException, Object obj, Method method, Object[] args) throws Throwable {
        this.error = SerenityManagedException.detachedCopyOf((Throwable)generalException);
        Throwable assertionError = ErrorConvertor.forError(this.error).convertToAssertion();
        this.notifyStepStarted(obj, method, args);
        this.notifyOfStepFailure(obj, method, args, assertionError);
    }

    private boolean isAnnotatedWithAValidStepAnnotation(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!this.isAThucydidesStep(annotation) && !AnnotatedStepDescription.isACompatibleStep((Annotation)annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isAThucydidesStep(Annotation annotation) {
        return annotation instanceof Step || annotation instanceof StepGroup;
    }

    private boolean isATestStep(Method method) {
        return this.isAnnotatedWithAValidStepAnnotation(method) || ScreenplayInspector.isAScreenplayPerformAsMethod((Method)method);
    }

    private boolean isIgnored(Method method) {
        return TestAnnotations.isIgnored((Method)method);
    }

    private Object runTestStep(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        String callingClass = this.testContext();
        LOGGER.debug("STARTING STEP: {} - {}", (Object)callingClass, (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        Object result = null;
        try {
            result = this.executeTestStepMethod(obj, method, args, zuperMethod, result);
            LOGGER.debug("STEP DONE: {}", (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        }
        catch (AssertionError failedAssertion) {
            this.error = failedAssertion;
            this.logStepFailure(obj, method, args, (Throwable)((Object)failedAssertion));
            result = this.appropriateReturnObject(obj, method);
        }
        catch (Throwable testErrorException) {
            if (JUnitAdapter.isAssumptionViolatedException((Throwable)testErrorException)) {
                result = this.appropriateReturnObject(obj, method);
            }
            this.error = SerenityManagedException.detachedCopyOf((Throwable)testErrorException);
            this.logStepFailure(obj, method, args, ErrorConvertor.forError(this.error).convertToAssertion());
            result = this.appropriateReturnObject(obj, method);
        }
        return result;
    }

    private void logStepFailure(Object object, Method method, Object[] args, Throwable assertionError) throws Throwable {
        this.notifyOfStepFailure(object, method, args, assertionError);
        LOGGER.debug("STEP FAILED: {} - {}", (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()), (Object)assertionError.getMessage());
    }

    private Object executeTestStepMethod(Object obj, Method method, Object[] args, Method zuperMethod, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, zuperMethod);
            this.notifyStepFinishedFor(method, args);
        }
        catch (PendingStepException pendingStep) {
            this.notifyStepPending(pendingStep.getMessage());
        }
        catch (IgnoredStepException ignoredStep) {
            this.notifyStepIgnored(ignoredStep.getMessage());
        }
        catch (Throwable throwable) {
            if (JUnitAdapter.isAssumptionViolatedException((Throwable)throwable)) {
                this.notifyAssumptionViolated(throwable.getMessage());
            }
            throw throwable;
        }
        Preconditions.checkArgument((boolean)true);
        return result;
    }

    private Object invokeMethod(Object obj, Object[] args, Method zuperMethod) throws Throwable {
        try {
            return zuperMethod.invoke(obj, args);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private boolean isPending(Method method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private void notifyStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepFinished();
    }

    private void notifySkippedStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private void notifyStepPending(String message) {
        StepEventBus.getEventBus().stepPending(message);
    }

    private void notifyAssumptionViolated(String message) {
        StepEventBus.getEventBus().assumptionViolated(message);
    }

    private void notifyStepIgnored(String message) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return StepNamer.forMethod(method).withArguments(args);
    }

    private void notifyStepSkippedFor(Method method, Object[] args) {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().stepPending();
        } else {
            StepEventBus.getEventBus().stepIgnored();
        }
    }

    private void notifyOfStepFailure(Object object, Method method, Object[] args, Throwable cause) throws Throwable {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, (String)this.getTestNameFrom(method, args), (Object[])args).withDisplayedFields(this.fieldValuesIn(object));
        StepFailure failure = new StepFailure(description, cause);
        StepEventBus.getEventBus().stepFailed(failure);
        if (this.shouldThrowExceptionImmediately()) {
            throw cause;
        }
    }

    private boolean shouldThrowExceptionImmediately() {
        return Serenity.shouldThrowErrorsImmediately();
    }

    private void notifyStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, (String)this.getTestNameFrom(method, args), (Object[])args).withDisplayedFields(this.fieldValuesIn(object));
        StepEventBus.getEventBus().stepStarted(description);
    }

    private Map<String, Object> fieldValuesIn(Object object) {
        Map coreFieldValues = Fields.of((Object)object).asMap();
        if (object instanceof HasCustomFieldValues) {
            coreFieldValues.putAll(((HasCustomFieldValues)object).getCustomFieldValues());
        }
        return coreFieldValues;
    }

    private void notifySkippedStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, (String)this.getTestNameFrom(method, args), (Object[])args).withDisplayedFields(this.fieldValuesIn(object));
        StepEventBus.getEventBus().skippedStepStarted(description);
    }

    String testContext() {
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace((StackTraceElement[])new RuntimeException().getStackTrace());
        StackTraceElement[] stackTrace = stackTraceSanitizer.getSanitizedStackTrace();
        return stackTrace.length > 0 ? this.getTestContextFrom(stackTraceSanitizer.getSanitizedStackTrace()[0]) : "";
    }

    private String getTestContextFrom(StackTraceElement stackTraceElement) {
        return this.shortenedClassName(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
    }

    private String shortenedClassName(String className) {
        String[] classNameElements = StringUtils.split((String)className, (String)".");
        return classNameElements[classNameElements.length - 1];
    }

    static enum PrimitiveReturnType {
        STRING,
        LONG,
        INTEGER,
        DOUBLE,
        FLOAT,
        BOOLEAN,
        VOID,
        UNSUPPORTED;

    }
}

