/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import com.google.common.base.Splitter;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.MobileElement;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.BuildWebElementFacade;
import net.serenitybdd.core.pages.ClearContents;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.serenitybdd.core.pages.DropdownDeselector;
import net.serenitybdd.core.pages.DropdownSelector;
import net.serenitybdd.core.pages.FluentDropdownDeselect;
import net.serenitybdd.core.pages.FluentDropdownSelect;
import net.serenitybdd.core.pages.ListOfWebElementFacades;
import net.serenitybdd.core.pages.ParameterisedLocator;
import net.serenitybdd.core.pages.WebElementExpectations;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WebElementResolver;
import net.serenitybdd.core.pages.WebElementState;
import net.serenitybdd.core.selectors.Selectors;
import net.serenitybdd.core.time.InternalSystemClock;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.locators.MethodTiming;
import net.thucydides.core.annotations.locators.WithConfigurableTimeout;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.TemporalUnitConverter;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.exceptions.ElementNotFoundAfterTimeoutError;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeDisabledException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeEnabledException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeInvisibleException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBePresentException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeVisibleException;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import net.thucydides.core.webdriver.stubs.WebElementFacadeStub;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebElementFacadeImpl
implements WebElementFacade,
net.thucydides.core.pages.WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long implicitTimeoutInMilliseconds;
    private final long waitForTimeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 100;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private final By bySelector;
    private JavascriptExecutorFacade javascriptExecutorFacade;
    private InternalSystemClock clock = new InternalSystemClock();
    private final EnvironmentVariables environmentVariables;
    private String foundBy;
    private ElementLocator locator;
    private WebElement resolvedELement;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebElementFacadeImpl.class);
    private static final List<String> HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE = Arrays.asList("input", "button", "option");
    private Optional<String> expectedErrorMessage = Optional.empty();

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement webElement, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds, By bySelector) {
        this.webElement = webElement;
        this.driver = driver;
        this.locator = locator;
        this.bySelector = bySelector;
        this.webdriverClock = Clock.systemDefaultZone();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        this.implicitTimeoutInMilliseconds = implicitTimeoutInMilliseconds;
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds >= 0L ? waitForTimeoutInMilliseconds : this.defaultWaitForTimeout();
    }

    public WebElementFacadeImpl(WebDriver driver, WebElement webElement, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds, By bySelector) {
        this.webElement = webElement;
        this.driver = driver;
        this.locator = null;
        this.bySelector = bySelector;
        this.webdriverClock = Clock.systemDefaultZone();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        this.implicitTimeoutInMilliseconds = implicitTimeoutInMilliseconds;
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds >= 0L ? waitForTimeoutInMilliseconds : this.defaultWaitForTimeout();
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement webElement, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this.webElement = webElement;
        this.driver = driver;
        this.locator = locator;
        this.bySelector = null;
        this.webdriverClock = Clock.systemDefaultZone();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        this.implicitTimeoutInMilliseconds = implicitTimeoutInMilliseconds;
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds >= 0L ? waitForTimeoutInMilliseconds : this.defaultWaitForTimeout();
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement webElement, long implicitTimeoutInMilliseconds) {
        this(driver, locator, webElement, implicitTimeoutInMilliseconds, implicitTimeoutInMilliseconds);
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, WebElement webElement, WebElement resolvedELement, By bySelector, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this.webElement = webElement;
        this.resolvedELement = resolvedELement;
        this.driver = driver;
        this.locator = locator;
        this.bySelector = bySelector;
        this.webdriverClock = Clock.systemDefaultZone();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javascriptExecutorFacade = new JavascriptExecutorFacade(driver);
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        this.implicitTimeoutInMilliseconds = timeoutInMilliseconds;
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds >= 0L ? waitForTimeoutInMilliseconds : this.defaultWaitForTimeout();
    }

    private long defaultWaitForTimeout() {
        return ThucydidesSystemProperty.WEBDRIVER_WAIT_FOR_TIMEOUT.integerFrom(this.environmentVariables, (int)DefaultTimeouts.DEFAULT_WAIT_FOR_TIMEOUT.toMillis());
    }

    private WebElementFacadeImpl copy() {
        return (WebElementFacadeImpl)BuildWebElementFacade.from(this.driver, this.locator, this.webElement, this.implicitTimeoutInMilliseconds, this.waitForTimeoutInMilliseconds);
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, long implicitTimeoutInMilliseconds) {
        this(driver, locator, null, implicitTimeoutInMilliseconds, implicitTimeoutInMilliseconds);
    }

    public WebElementFacadeImpl(WebDriver driver, ElementLocator locator, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this(driver, locator, null, implicitTimeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        return BuildWebElementFacade.from(driver, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, WebElement element, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds, String foundBy) {
        return BuildWebElementFacade.from(driver, element, timeoutInMilliseconds, waitForTimeoutInMilliseconds, foundBy);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, WebElement resolvedELement, WebElement element, By bySelector, ElementLocator locator, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds, String foundBy) {
        return BuildWebElementFacade.from(driver, resolvedELement, element, bySelector, locator, timeoutInMilliseconds, waitForTimeoutInMilliseconds, foundBy);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, By bySelector, long timeoutInMilliseconds, long waitForTimeoutInMilliseconds, String foundBy) {
        return BuildWebElementFacade.from(driver, bySelector, timeoutInMilliseconds, waitForTimeoutInMilliseconds, foundBy);
    }

    public static <T extends WebElementFacade> T wrapWebElement(WebDriver driver, WebElement element, long timeout) {
        return BuildWebElementFacade.from(driver, element, timeout);
    }

    private WebElementResolver getElementResolver() {
        if (this.webElement != null) {
            return WebElementResolver.forWebElement(this.webElement);
        }
        if (this.bySelector != null) {
            return WebElementResolver.by(this.bySelector);
        }
        return WebElementResolver.byLocator(this.locator).withImplicitTimeout(this.implicitTimeoutInMilliseconds);
    }

    @Override
    public WebElement getElement() {
        if (this.driverIsDisabled()) {
            return new WebElementFacadeStub();
        }
        return this.getResolvedELement();
    }

    private WebElement getResolvedELement() {
        if (this.resolvedELement == null) {
            this.resolvedELement = this.getElementResolver().resolveForDriver(this.driver);
        }
        return this.resolvedELement;
    }

    protected JavascriptExecutorFacade getJavascriptExecutorFacade() {
        return this.javascriptExecutorFacade;
    }

    protected InternalSystemClock getClock() {
        return this.clock;
    }

    public WebElementFacade then(String xpathOrCssSelector, Object ... arguments) {
        return this.findBy(xpathOrCssSelector, arguments);
    }

    public WebElementFacade thenFind(String xpathOrCssSelector, Object ... arguments) {
        return this.findBy(xpathOrCssSelector, arguments);
    }

    public WebElementFacade thenFind(String xpathOrCssSelector) {
        return this.findBy(xpathOrCssSelector);
    }

    public WebElementFacade then(String xpathOrCssSelector) {
        return this.findBy(xpathOrCssSelector);
    }

    @Override
    public <T extends WebElementFacade> T findBy(String xpathOrCssSelector) {
        this.logIfVerbose("findBy " + xpathOrCssSelector);
        WebElementFacadeImpl nestedElement = this.driverIsDisabled() ? this : (Selectors.isXPath(xpathOrCssSelector) ? this.getElement().findElement(By.xpath((String)xpathOrCssSelector)) : this.getElement().findElement(By.cssSelector((String)xpathOrCssSelector)));
        return WebElementFacadeImpl.wrapWebElement(this.driver, nestedElement, this.timeoutInMilliseconds(), this.waitForTimeoutInMilliseconds, "element located by " + xpathOrCssSelector);
    }

    @Override
    public <T extends WebElementFacade> T findBy(String xpathOrCssSelector, Object ... arguments) {
        return this.findBy(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments));
    }

    public long timeoutInMilliseconds() {
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).getCurrentImplicitTimeout().toMillis();
        }
        return this.implicitTimeoutInMilliseconds;
    }

    @Override
    public ListOfWebElementFacades thenFindAll(String xpathOrCssSelector) {
        this.logIfVerbose("findAll " + xpathOrCssSelector);
        if (this.driverIsDisabled()) {
            return new ListOfWebElementFacades(new ArrayList());
        }
        List<WebElement> nestedElements = Selectors.isXPath(xpathOrCssSelector) ? this.findElements(By.xpath((String)xpathOrCssSelector)) : this.findElements(By.cssSelector((String)xpathOrCssSelector));
        return this.webElementFacadesFrom(nestedElements);
    }

    @Override
    public ListOfWebElementFacades thenFindAll(String xpathOrCssSelector, Object ... arguments) {
        return this.thenFindAll(ParameterisedLocator.withArguments(xpathOrCssSelector, arguments));
    }

    private ListOfWebElementFacades webElementFacadesFrom(List<WebElement> nestedElements) {
        ArrayList results = new ArrayList();
        for (WebElement element : nestedElements) {
            results.add(WebElementFacadeImpl.wrapWebElement(this.driver, element, this.timeoutInMilliseconds(), this.waitForTimeoutInMilliseconds, element.toString()));
        }
        return new ListOfWebElementFacades(results);
    }

    public WebElementFacade findBy(By selector) {
        this.logIfVerbose("findBy " + selector);
        if (this.driverIsDisabled()) {
            return this;
        }
        WebElement nestedElement = this.getElement().findElement(selector);
        return WebElementFacadeImpl.wrapWebElement(this.driver, nestedElement, this.timeoutInMilliseconds(), this.waitForTimeoutInMilliseconds, "element located by " + selector.toString());
    }

    public WebElementFacade find(By bySelector) {
        return this.findBy(bySelector);
    }

    public WebElementFacade then(By bySelector) {
        return this.findBy(bySelector);
    }

    @Override
    public String getAttribute(String name) {
        return this.getElement().getAttribute(name);
    }

    @Override
    public ListOfWebElementFacades thenFindAll(By selector) {
        this.logIfVerbose("findAll " + selector);
        if (this.driverIsDisabled()) {
            return new ListOfWebElementFacades(new ArrayList());
        }
        List<WebElement> nestedElements = this.findElements(selector);
        return this.webElementFacadesFrom(nestedElements);
    }

    public WebElement findElementByAccessibilityId(String id) {
        if (this.driverIsDisabled()) {
            return this;
        }
        return ((FindsByAccessibilityId)this.getElement()).findElementByAccessibilityId(id);
    }

    public List<WebElement> findElementsByAccessibilityId(String id) {
        if (this.driverIsDisabled()) {
            return new ArrayList<WebElement>();
        }
        return ((FindsByAccessibilityId)this.getElement()).findElementsByAccessibilityId(id);
    }

    public WebElement findElementByAndroidUIAutomator(String using) {
        if (this.driverIsDisabled()) {
            return this;
        }
        return ((FindsByAndroidUIAutomator)this.getElement()).findElementByAndroidUIAutomator(using);
    }

    public List<WebElement> findElementsByAndroidUIAutomator(String using) {
        if (this.driverIsDisabled()) {
            return new ArrayList<WebElement>();
        }
        return ((FindsByAndroidUIAutomator)this.getElement()).findElementsByAndroidUIAutomator(using);
    }

    @Override
    public long getImplicitTimeoutInMilliseconds() {
        return this.implicitTimeoutInMilliseconds;
    }

    public Duration getImplicitTimeout() {
        return ((ConfigurableTimeouts)this.driver).getCurrentImplicitTimeout();
    }

    public WebElementFacade withTimeoutOf(int timeout, TimeUnit unit) {
        return this.withTimeoutOf(timeout, TemporalUnitConverter.fromTimeUnit(unit));
    }

    public WebElementFacade withTimeoutOf(int timeout, TemporalUnit unit) {
        return this.withTimeoutOf(Duration.of(timeout, unit));
    }

    public WebElementFacade withTimeoutOf(Duration duration) {
        return WebElementFacadeImpl.wrapWebElement(this.driver, this.resolvedELement, this.webElement, this.bySelector, this.locator, duration.toMillis(), duration.toMillis(), this.foundBy);
    }

    @Override
    public boolean isVisible() {
        if (this.driverIsDisabled()) {
            return false;
        }
        try {
            WebElement element = this.getElement();
            if (element == null) {
                return false;
            }
            if (!this.isPresent()) {
                return false;
            }
            if (element != null && this.shouldWaitForResult()) {
                this.waitForCondition().until((Function)ExpectedConditions.visibilityOf((WebElement)element));
            }
            return element != null && element.isDisplayed();
        }
        catch (ElementNotVisibleException | NoSuchElementException | StaleElementReferenceException | TimeoutException e) {
            return false;
        }
    }

    private boolean shouldWaitForResult() {
        return !MethodTiming.forThisThread().isInQuickMethod();
    }

    public WebElementFacade and() {
        return this;
    }

    public WebElementFacade then() {
        return this;
    }

    @Override
    public boolean isCurrentlyVisible() {
        return this.isVisible();
    }

    @Override
    public boolean isCurrentlyEnabled() {
        if (this.driverIsDisabled()) {
            return false;
        }
        try {
            return this.getElement() != null && this.getElement().isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    @Override
    public void shouldBeVisible() {
        if (!this.isVisible()) {
            this.failWithMessage("Element should be visible");
        }
    }

    @Override
    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            this.failWithMessage("Element should be visible");
        }
    }

    @Override
    public void shouldNotBeVisible() {
        if (this.isCurrentlyVisible()) {
            this.failWithMessage("Element should not be visible");
        }
    }

    @Override
    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            this.failWithMessage("Element should not be visible");
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.driverIsDisabled()) {
            return false;
        }
        JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.getElement().equals(activeElement);
    }

    @Override
    public boolean containsText(String value) {
        if (this.driverIsDisabled()) {
            return false;
        }
        WebElement element = this.getElement();
        return element != null && element.getText().contains(value);
    }

    @Override
    public boolean containsValue(String value) {
        if (this.driverIsDisabled()) {
            return false;
        }
        WebElement element = this.getElement();
        return element != null && element.getAttribute("value").contains(value);
    }

    @Override
    public boolean containsOnlyText(String value) {
        if (this.driverIsDisabled()) {
            return false;
        }
        WebElement element = this.getElement();
        return element != null && element.getText().equals(value);
    }

    @Override
    public boolean containsSelectOption(String value) {
        if (this.driverIsDisabled()) {
            return false;
        }
        return this.getSelectOptions().contains(value);
    }

    @Override
    public List<String> getSelectOptions() {
        if (this.driverIsDisabled()) {
            return new ArrayList<String>();
        }
        if (this.getElement() != null) {
            return this.findElements(By.tagName((String)"option")).stream().map(WebElement::getText).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public ElementLocator getLocator() {
        if (this.locator instanceof WithConfigurableTimeout && this.driver instanceof ConfigurableTimeouts) {
            ((WithConfigurableTimeout)this.locator).setTimeOutInSeconds((int)this.getLocatorTimeout());
        }
        return this.locator;
    }

    private long getLocatorTimeout() {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended() || MethodTiming.forThisThread().isInQuickMethod()) {
            return 0L;
        }
        return TimeUnit.SECONDS.convert(this.implicitTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setImplicitTimeout(Duration implicitTimeout) {
        if (this.driverIsDisabled()) {
            return;
        }
        if (this.driver instanceof ConfigurableTimeouts) {
            ((ConfigurableTimeouts)this.driver).setImplicitTimeout(implicitTimeout);
        }
    }

    @Override
    public Duration getCurrentImplicitTimeout() {
        if (this.driverIsDisabled()) {
            return Duration.ofSeconds(0L);
        }
        if (this.driver instanceof ConfigurableTimeouts) {
            return ((ConfigurableTimeouts)this.driver).getCurrentImplicitTimeout();
        }
        return DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    @Override
    public Duration resetTimeouts() {
        if (this.driverIsDisabled()) {
            return Duration.ofSeconds(0L);
        }
        if (this.driver instanceof ConfigurableTimeouts) {
            return ((ConfigurableTimeouts)this.driver).resetTimeouts();
        }
        return DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    public String getFoundBy() {
        return this.foundBy;
    }

    @Override
    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element. Element text '%s'.", textValue, this.getElement().getText());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldContainOnlyText(String textValue) {
        if (!this.containsOnlyText(textValue)) {
            String errorMessage = String.format("The text '%s' does not match the elements text '%s'.", textValue, this.getElement().getText());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldContainSelectedOption(String textValue) {
        if (!this.containsSelectOption(textValue)) {
            String errorMessage = String.format("The list element '%s' was not found in the web element", textValue);
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was found in the web element when it should not have. Element text '%s'.", textValue, this.getElement().getText());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldBeEnabled() {
        if (!this.isCurrentlyEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.driverIsDisabled()) {
            return false;
        }
        if (this.getElement() == null) {
            return false;
        }
        if (this.shouldWaitForResult()) {
            try {
                this.waitForCondition().until(webDriver -> this.getElement().isEnabled());
            }
            catch (TimeoutException timeout) {
                return false;
            }
        }
        return this.getElement().isEnabled();
    }

    @Override
    public void shouldNotBeEnabled() {
        if (this.isCurrentlyEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public boolean isClickable() {
        try {
            if (!this.driverIsDisabled() && this.shouldWaitForResult()) {
                this.waitForCondition().until(WebElementExpectations.elementIsClickable(this));
                return true;
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeEnabledException("Expected enabled element was not clickable", timeout);
        }
        return false;
    }

    public WebElementFacade type(CharSequence ... keysToSend) {
        this.logIfVerbose("Type '" + keysToSend + "'");
        if (this.driverIsDisabled()) {
            return this;
        }
        this.waitUntilElementAvailable();
        this.clear();
        this.getElement().sendKeys(keysToSend);
        this.notifyScreenChange();
        return this;
    }

    public WebElementFacade typeAndEnter(String value) {
        this.logIfVerbose("Type and enter '" + value + "'");
        if (this.driverIsDisabled()) {
            return this;
        }
        this.waitUntilElementAvailable();
        this.clear();
        this.getElement().sendKeys(new CharSequence[]{value, Keys.ENTER});
        this.notifyScreenChange();
        return this;
    }

    public WebElementFacade typeAndTab(String value) {
        this.logIfVerbose("Type and tab '" + value + "'");
        if (this.driverIsDisabled()) {
            return this;
        }
        this.waitUntilElementAvailable();
        this.clear();
        this.getElement().sendKeys(new CharSequence[]{value});
        this.getElement().sendKeys(new CharSequence[]{Keys.TAB});
        this.getClock().pauseFor(100L);
        this.notifyScreenChange();
        return this;
    }

    @Override
    public void setWindowFocus() {
        if (this.driverIsDisabled()) {
            return;
        }
        this.getJavascriptExecutorFacade().executeScript("window.focus()");
    }

    @Override
    public FluentDropdownSelect select() {
        return new FluentDropdownSelect(this);
    }

    @Override
    public FluentDropdownDeselect deselect() {
        return new FluentDropdownDeselect(this);
    }

    private DropdownSelector dropdownSelect() {
        return new DropdownSelector(this);
    }

    private DropdownDeselector dropdownDeselect() {
        return new DropdownDeselector(this);
    }

    @Deprecated
    public WebElementFacade deselectAll() {
        return this.dropdownDeselect().all();
    }

    @Deprecated
    public WebElementFacade deselectByIndex(int indexValue) {
        return this.dropdownDeselect().byIndex(indexValue);
    }

    @Deprecated
    public WebElementFacade deselectByVisibleText(String label) {
        return this.dropdownDeselect().byVisibleText(label);
    }

    @Deprecated
    public WebElementFacade deselectByValue(String value) {
        return this.dropdownDeselect().byValue(value);
    }

    @Deprecated
    public WebElementFacade selectByVisibleText(String label) {
        return this.dropdownSelect().byVisibleText(label);
    }

    @Override
    public String getSelectedVisibleTextValue() {
        return this.dropdownSelect().visibleTextValue();
    }

    @Deprecated
    public WebElementFacade selectByValue(String value) {
        return this.dropdownSelect().byValue(value);
    }

    @Override
    public String getSelectedValue() {
        return this.dropdownSelect().value();
    }

    @Deprecated
    public WebElementFacade selectByIndex(int indexValue) {
        return this.dropdownSelect().byIndex(indexValue);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        if (this.driverIsDisabled()) {
            return null;
        }
        return (X)this.getElement().getScreenshotAs(target);
    }

    protected void waitUntilElementAvailable() {
        if (this.driverIsDisabled()) {
            return;
        }
        this.withTimeoutOf((int)this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).waitUntilEnabled();
    }

    protected boolean driverIsDisabled() {
        return StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    private boolean elementIsPresent() {
        try {
            WebElement element = this.getElement();
            if (this.getElement() == null) {
                return false;
            }
            element.isDisplayed();
            return true;
        }
        catch (ElementNotVisibleException e) {
            return true;
        }
        catch (ElementNotFoundAfterTimeoutError | NotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isPresent() {
        if (this.driverIsDisabled()) {
            return false;
        }
        return this.elementIsPresent();
    }

    @Override
    public void shouldBePresent() {
        if (!this.isPresent()) {
            this.failWithMessage("Field should be present");
        }
    }

    @Override
    public void shouldNotBePresent() {
        if (this.isPresent()) {
            this.failWithMessage("Field should not be present");
        }
    }

    private void failWithMessage(String errorMessage) {
        throw new AssertionError((Object)this.getErrorMessage(errorMessage));
    }

    private void checkPresenceOfWebElement() {
        try {
            if (!this.driverIsDisabled() && this.shouldWaitForResult()) {
                this.waitForCondition().until(WebElementExpectations.elementIsDisplayed(this));
            }
        }
        catch (Throwable error) {
            if (this.webElement != null) {
                this.throwShouldBeVisibleErrorWithCauseIfPresent(error, error.getMessage());
            }
            this.throwNoSuchElementExceptionWithCauseIfPresent(error, error.getMessage());
        }
    }

    public WebElementFacade waitUntilVisible() {
        this.checkPresenceOfWebElement();
        return this;
    }

    public WebElementFacade waitUntilPresent() {
        try {
            if (!this.driverIsDisabled()) {
                this.waitForCondition().until(WebElementExpectations.elementIsPresent(this));
            }
        }
        catch (TimeoutException timeout) {
            this.throwShouldBePresentErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
        return this;
    }

    private void throwNoSuchElementExceptionWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new NoSuchElementException(finalMessage, timeout);
    }

    private void throwShouldBeVisibleErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementShouldBeVisibleException(finalMessage, timeout);
    }

    private void throwShouldBeInvisibleErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementShouldBeInvisibleException(finalMessage, timeout);
    }

    private void throwShouldBePresentErrorWithCauseIfPresent(Throwable timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        String finalMessage = StringUtils.isNotEmpty((CharSequence)timeoutMessage) ? timeoutMessage : defaultMessage;
        throw new ElementShouldBePresentException(finalMessage, timeout);
    }

    private boolean hasValueAttribute(WebElement element) {
        String tag = element.getTagName().toLowerCase();
        return HTML_ELEMENTS_WITH_VALUE_ATTRIBUTE.contains(tag);
    }

    @Override
    public Wait<WebDriver> waitForCondition() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(100L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public WebElementFacade waitUntilNotVisible() {
        if (this.driverIsDisabled()) {
            return this;
        }
        if (!this.withTimeoutOf(Duration.ofMillis(0L)).isVisible()) {
            return this;
        }
        try {
            this.waitForCondition().until(WebElementExpectations.elementIsNotDisplayed(this));
        }
        catch (TimeoutException timeout) {
            this.throwShouldBeInvisibleErrorWithCauseIfPresent(timeout, "Expected hidden element was displayed");
        }
        return this;
    }

    @Override
    public String getValue() {
        this.checkPresenceOfWebElement();
        return this.getElement().getAttribute("value");
    }

    @Override
    public boolean isSelected() {
        return this.getElement().isSelected();
    }

    @Override
    public String getText() {
        if (this.driverIsDisabled()) {
            return "";
        }
        if (ThucydidesSystemProperty.LEGACY_WAIT_FOR_TEXT.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            this.checkPresenceOfWebElement();
        }
        return this.getElement().getText();
    }

    @Override
    public String getTextContent() {
        if (this.driverIsDisabled()) {
            return "";
        }
        return this.getElement().getAttribute("textContent");
    }

    @Override
    public boolean isDisabled() {
        if (this.driverIsDisabled()) {
            return true;
        }
        return !this.getElement().isEnabled();
    }

    private boolean driverIsActive() {
        return this.driver != null && !this.driverIsDisabled();
    }

    public WebElementFacade waitUntilEnabled() {
        try {
            if (this.driverIsActive()) {
                this.waitForCondition().until(WebElementExpectations.elementIsEnabled(this));
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeEnabledException("Expected enabled element was not enabled", timeout);
        }
        return this;
    }

    public WebElementFacade waitUntilClickable() {
        try {
            if (this.driverIsActive()) {
                this.waitForCondition().until(WebElementExpectations.elementIsClickable(this));
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeEnabledException("Expected enabled element was not enabled", timeout);
        }
        return this;
    }

    public WebElementFacade waitUntilDisabled() {
        try {
            if (this.driverIsActive()) {
                this.waitForCondition().until(WebElementExpectations.elementIsNotEnabled(this));
            }
        }
        catch (TimeoutException timeout) {
            throw new ElementShouldBeDisabledException("Expected disabled element was not disabled", timeout);
        }
        return this;
    }

    @Override
    public String getTextValue() {
        if (this.driverIsDisabled()) {
            return "";
        }
        this.waitUntilPresent();
        if (!this.isVisible()) {
            return "";
        }
        if (this.valueAttributeSupportedAndDefinedIn(this.getElement())) {
            return this.getValue();
        }
        if (!StringUtils.isEmpty((CharSequence)this.getElement().getText())) {
            return this.getElement().getText();
        }
        return "";
    }

    @Override
    public WebElementState expect(String errorMessage) {
        return this.copy().expectingErrorMessage(errorMessage);
    }

    protected WebElementState expectingErrorMessage(String errorMessage) {
        this.expectedErrorMessage = Optional.of(errorMessage);
        return this;
    }

    protected String getErrorMessage(String defaultErrorMessage) {
        return this.expectedErrorMessage.orElse(defaultErrorMessage);
    }

    private boolean valueAttributeSupportedAndDefinedIn(WebElement element) {
        return this.hasValueAttribute(element) && StringUtils.isNotEmpty((CharSequence)this.getValue());
    }

    @Override
    public void click() {
        if (this.driverIsDisabled()) {
            return;
        }
        this.waitUntilElementAvailable();
        this.logClick();
        this.getElement().click();
        this.notifyScreenChange();
    }

    private void logClick() {
        this.logIfVerbose("click");
    }

    private void logIfVerbose(String logMessage) {
        if (this.useVerboseLogging()) {
            LOGGER.debug(logMessage + " : " + this.toString());
        }
    }

    private boolean useVerboseLogging() {
        return ThucydidesSystemProperty.THUCYDIDES_VERBOSE_STEPS.booleanFrom(this.environmentVariables);
    }

    private boolean isMobileDriver() {
        return AppiumDriver.class.isAssignableFrom(ThucydidesWebDriverSupport.getDriverClass());
    }

    @Override
    public void clear() {
        if (this.driverIsDisabled()) {
            return;
        }
        if (!this.isMobileDriver()) {
            ClearContents.ofElement(this.getElement());
        }
        this.getElement().clear();
    }

    protected void notifyScreenChange() {
        StepEventBus.getEventBus().notifyScreenChange();
    }

    @Override
    public String toString() {
        if (this.webElement != null && !this.driverIsDisabled()) {
            return this.webElement.toString();
        }
        if (this.foundBy != null) {
            return this.foundBy;
        }
        if (this.bySelector != null) {
            return this.bySelector.toString();
        }
        if (this.locator != null) {
            return this.locator.toString();
        }
        return "<webelement>";
    }

    public void submit() {
        this.getElement().submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.getElement().sendKeys(keysToSend);
    }

    public String getTagName() {
        return this.getElement().getTagName();
    }

    public List<WebElement> findElements(By by) {
        return this.getElement().findElements(by);
    }

    public WebElement findElement(By by) {
        return this.getElement().findElement(by);
    }

    public WebElement findElement(String by, String using) {
        if (this.driverIsDisabled()) {
            return this;
        }
        if (this.getElement() instanceof MobileElement) {
            return ((MobileElement)this.getElement()).findElement(by, using);
        }
        throw new UnsupportedOperationException();
    }

    public List findElements(String by, String using) {
        if (this.driverIsDisabled()) {
            return new ArrayList();
        }
        if (this.getElement() instanceof MobileElement) {
            return ((MobileElement)this.getElement()).findElements(by, using);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isDisplayed() {
        return this.getElement().isDisplayed();
    }

    public Point getLocation() {
        return this.getElement().getLocation();
    }

    public Dimension getSize() {
        return this.getElement().getSize();
    }

    public Rectangle getRect() {
        return this.getElement().getRect();
    }

    public String getCssValue(String propertyName) {
        return this.getElement().getCssValue(propertyName);
    }

    @Override
    public boolean containsElements(By bySelector) {
        return !this.findElements(bySelector).isEmpty();
    }

    @Override
    public boolean containsElements(String xpathOrCssSelector) {
        return !this.thenFindAll(xpathOrCssSelector).isEmpty();
    }

    @Override
    public void shouldContainElements(By bySelector) {
        if (!this.containsElements(bySelector)) {
            String errorMessage = String.format("Could not find contained elements %s in %s", bySelector, this.getElement().toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public void shouldContainElements(String xpathOrCssSelector) {
        if (!this.containsElements(xpathOrCssSelector)) {
            String errorMessage = String.format("Could not find contained elements %s in %s", xpathOrCssSelector, this.getElement().toString());
            this.failWithMessage(errorMessage);
        }
    }

    @Override
    public boolean hasClass(String cssClassName) {
        String cssClassValue = this.getAttribute("class").toLowerCase();
        List cssClasses = Splitter.on((String)" ").omitEmptyStrings().trimResults().splitToList((CharSequence)cssClassValue);
        return cssClasses.contains(cssClassName.toLowerCase());
    }

    public WebElementFacade foundBy(String foundBy) {
        this.foundBy = foundBy;
        return this;
    }

    public Coordinates getCoordinates() {
        return ((Locatable)this.getElement()).getCoordinates();
    }

    public WebElement getWrappedElement() {
        return this.getResolvedELement();
    }
}

