/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.serenitybdd.core.annotations.findby.By;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowDom
extends By {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShadowDom.class);
    private final String shadowDomSelector;
    private static String loadedScript;

    private ShadowDom(String selector) {
        this.shadowDomSelector = selector;
    }

    public static ShadowDom of(String selector) {
        return new ShadowDom(selector);
    }

    public List<WebElement> findElements(SearchContext context) {
        StringBuffer scriptData = new StringBuffer();
        scriptData.append(loadedScript);
        scriptData.append(" return querySelectorAllDeep('");
        scriptData.append(this.shadowDomSelector);
        scriptData.append("');");
        return (List)((JavascriptExecutor)context).executeScript(scriptData.toString(), new Object[0]);
    }

    public WebElement findElement(SearchContext context) {
        StringBuffer scriptData = new StringBuffer();
        scriptData.append(loadedScript);
        scriptData.append(" return querySelectorDeep('");
        scriptData.append(this.shadowDomSelector);
        scriptData.append("');");
        WebElement element = (WebElement)((JavascriptExecutor)context).executeScript(scriptData.toString(), new Object[0]);
        if (element == null) {
            throw new NoSuchElementException("No element found matching ShadowDom selector " + this.shadowDomSelector);
        }
        return element;
    }

    public String toString() {
        return "By.shadowDomSelector: " + this.shadowDomSelector;
    }

    static {
        try {
            InputStream resourceAsStream = ShadowDom.class.getResourceAsStream("/javascript/querySelectorDeep.js");
            loadedScript = IOUtils.toString((InputStream)resourceAsStream, (String)"UTF-8");
        }
        catch (IOException ex) {
            LOGGER.error("Cannot load script for selecting shadow dom ", (Throwable)ex);
        }
    }
}

