/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.steps.StepFailure;

public class TestResultTally
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<StepFailure> failures = new ArrayList<StepFailure>();
    private int ignored = 0;
    private int run = 0;
    final Class<?> classUnderTest;

    private TestResultTally(Class<?> classUnderTest) {
        this.classUnderTest = classUnderTest;
    }

    public Class<?> getClassUnderTest() {
        return this.classUnderTest;
    }

    public void logFailure(StepFailure failure) {
        this.failures.add(failure);
    }

    public void logIgnoredTest() {
        ++this.ignored;
    }

    public void logExecutedTest() {
        ++this.run;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public List<StepFailure> getFailures() {
        return NewList.copyOf(this.failures);
    }

    public int getIgnoreCount() {
        return this.ignored;
    }

    public int getRunCount() {
        return this.run;
    }

    public boolean wasSuccessful() {
        return this.getFailureCount() == 0;
    }

    public static TestResultTally forTestClass(Class<?> classUnderTest) {
        return new TestResultTally(classUnderTest);
    }
}

