/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.lang.reflect.Method;
import java.util.Optional;
import net.thucydides.core.util.JUnitAdapter;
import net.thucydides.core.util.NameConverter;

public class RemoteTestName {
    public static Optional<String> fromCurrentTest() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            try {
                Class<?> callingClass = Class.forName(elt.getClassName());
                Method callingMethod = callingClass.getMethod(elt.getMethodName(), new Class[0]);
                if (RemoteTestName.isATestMethod(callingMethod)) {
                    return Optional.of(NameConverter.humanize((String)elt.getMethodName()));
                }
                if (!RemoteTestName.isASetupMethod(callingMethod)) continue;
                return Optional.of(NameConverter.humanize((String)callingClass.getSimpleName()));
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static boolean isATestMethod(Method callingMethod) {
        return JUnitAdapter.isTestMethod((Method)callingMethod);
    }

    private static boolean isASetupMethod(Method callingMethod) {
        return JUnitAdapter.isTestSetupMethod((Method)callingMethod);
    }
}

