/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.ManagedPages;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reflection.FieldSetter;
import net.thucydides.core.steps.InvalidManagedPagesFieldException;

public class PagesAnnotatedField {
    private Field field;
    private ManagedPages annotation;

    public static Optional<PagesAnnotatedField> findFirstAnnotatedField(Class<?> testClass) {
        return PagesAnnotatedField.findOptionalAnnotatedField(testClass);
    }

    public static Optional<PagesAnnotatedField> findOptionalAnnotatedField(Class<?> testClass) {
        for (Field field : Fields.of(testClass).allFields()) {
            ManagedPages fieldAnnotation = PagesAnnotatedField.annotationFrom(field);
            if (fieldAnnotation == null) continue;
            return Optional.of(new PagesAnnotatedField(field, fieldAnnotation));
        }
        return Optional.empty();
    }

    private static ManagedPages annotationFrom(Field aField) {
        ManagedPages annotationOnField = null;
        if (PagesAnnotatedField.fieldIsAnnotatedCorrectly(aField)) {
            if (!PagesAnnotatedField.fieldIsRightType(aField)) {
                throw new InvalidManagedPagesFieldException("@ManagedPages field must be of type Pages");
            }
            annotationOnField = aField.getAnnotation(ManagedPages.class);
        }
        return annotationOnField;
    }

    static boolean fieldIsRightType(Field field) {
        return Pages.class.isAssignableFrom(field.getType());
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        boolean pagesAnnotationFound = false;
        for (Annotation annotation : field.getAnnotations()) {
            if (!(annotation instanceof ManagedPages)) continue;
            pagesAnnotationFound = true;
            break;
        }
        return pagesAnnotationFound;
    }

    protected PagesAnnotatedField(Field field, ManagedPages annotation) {
        this.field = field;
        this.annotation = annotation;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public void setValue(Object testCase, Pages pages) {
        try {
            this.set(testCase).to((Object)pages);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedPagesFieldException("Could not access or set managed pages field: " + this.field, e);
        }
    }

    protected FieldSetter set(Object targetObject) {
        return new FieldSetter(this.field, targetObject);
    }

    public String getDefaultBaseUrl() {
        return this.annotation.defaultUrl();
    }
}

