/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.CapabilitiesConverter;
import net.serenitybdd.core.webdriver.driverproviders.ConfiguredProxy;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.SanitisedBrowserPreferences;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.BrowserPreferences;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class EdgeDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;

    public EdgeDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        EdgeOptions edgeOptions = this.configuredOptions();
        String envSpecifiedEdgeOption = ThucydidesSystemProperty.EDGE_OPTIONS.from(this.environmentVariables, "");
        Map<String, Object> environmentSpecifiedOptions = CapabilitiesConverter.optionsToMap(envSpecifiedEdgeOption);
        this.addPreferencesTo(environmentSpecifiedOptions);
        edgeOptions.setCapability("ms:edgeOptions", environmentSpecifiedOptions);
        return new DesiredCapabilities((Capabilities)edgeOptions);
    }

    public EdgeOptions configuredOptions() {
        EdgeOptions options = new EdgeOptions();
        this.addProxyConfigurationTo(options);
        return options;
    }

    private void addPreferencesTo(Map<String, Object> options) {
        EdgeDriverCapabilities.preferencesConfiguredIn(this.environmentVariables).forEach(options::put);
    }

    public static Map<String, Object> preferencesConfiguredIn(EnvironmentVariables environmentVariables) {
        return SanitisedBrowserPreferences.cleanUpPathsIn(BrowserPreferences.startingWith("edge.preferences.").from(environmentVariables));
    }

    private void addProxyConfigurationTo(EdgeOptions options) {
        ConfiguredProxy.definedIn(this.environmentVariables).ifPresent(arg_0 -> ((EdgeOptions)options).setProxy(arg_0));
    }
}

