/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.junit.SerenityJUnitTestCase;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.statistics.TestCount;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.DeactivatedCloseBrowser;
import net.thucydides.core.webdriver.PeriodicRestart;
import net.thucydides.core.webdriver.TestSuiteCloseBrowser;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdriverCloseBrowser
implements CloseBrowser {
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);
    private final TestCount testCount;
    private final PeriodicRestart shouldRestartBrowser;

    @Inject
    public WebdriverCloseBrowser(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.testCount = (TestCount)Injectors.getInjector().getInstance(TestCount.class);
        this.shouldRestartBrowser = new PeriodicRestart(environmentVariables);
    }

    @Override
    public void closeIfConfiguredForANew(RestartBrowserForEach event) {
        if (this.restartBrowserForANew(event) || this.shouldRestartBrowserPeriodicallyNow()) {
            ThucydidesWebDriverSupport.closeCurrentDrivers();
        }
    }

    private boolean shouldRestartBrowserPeriodicallyNow() {
        return this.shouldRestartBrowser.forTestNumber(this.testCount.getCurrentTestNumber());
    }

    private boolean restartBrowserForANew(RestartBrowserForEach event) {
        if (StepEventBus.getEventBus().isUniqueSession() || StepEventBus.getEventBus().currentTestHasTag(TestTag.withValue((String)"singlebrowser"))) {
            return event == RestartBrowserForEach.FEATURE;
        }
        return RestartBrowserForEach.configuredIn(this.environmentVariables).restartBrowserForANew(event);
    }

    @Override
    public void closeWhenTheTestsAreFinished(WebDriver driver) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (driver != null) {
                try {
                    driver.quit();
                }
                catch (WebDriverException mostLikelyLostContactWithTheBrowser) {
                    LOGGER.debug("Failed to close a browser: {}", (Object)mostLikelyLostContactWithTheBrowser.getMessage());
                }
            }
        }));
    }

    @Override
    public CloseBrowser forTestSuite(Class<?> testSuite) {
        if (testSuite == null) {
            return this;
        }
        if (SerenityJUnitTestCase.inClass(testSuite).isAWebTest()) {
            return new TestSuiteCloseBrowser(this.environmentVariables, testSuite);
        }
        return new DeactivatedCloseBrowser();
    }
}

