/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Field;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.serenitybdd.core.annotations.findby.FindBy;
import net.serenitybdd.core.annotations.locators.SmartAnnotations;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.pages.WebElementFacade;
import net.thucydides.core.WebdriverCollectionStrategy;
import net.thucydides.core.annotations.ElementIsUsable;
import net.thucydides.core.annotations.locators.MethodTiming;
import net.thucydides.core.annotations.locators.SearchContextType;
import net.thucydides.core.annotations.locators.SmartElementLocator;
import net.thucydides.core.annotations.locators.WaitForWebElementCollection;
import net.thucydides.core.annotations.locators.WithConfigurableTimeout;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.core.webdriver.exceptions.ElementNotFoundAfterTimeoutError;
import net.thucydides.core.webdriver.exceptions.ElementNotVisibleAfterTimeoutError;
import net.thucydides.core.webdriver.stubs.WebElementFacadeStub;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.SlowLoadableComponent;

public class SmartAjaxElementLocator
extends SmartElementLocator
implements WithConfigurableTimeout {
    private static final Duration ZERO_SECONDS = Duration.ofSeconds(0L);
    private Optional<Integer> annotatedTimeoutInSeconds;
    private final Clock clock;
    private final Field field;
    private final SearchContext searchContext;
    private final MobilePlatform platform;
    private final EnvironmentVariables environmentVariables;
    private static final SearchContextProvider UNMODIFIED_SEARCH_CONTEXT = (context, timeout) -> context;
    private static final SearchContextProvider WEB_DRIVER_FACADE = (context, timeout) -> WebdriverProxyFactory.getFactory().proxyFor((WebDriver)context);
    private static final SearchContextProvider WEB_ELEMENT_FACADE_WITH_OPTIONAL_TIMEOUT = (context, timeout) -> {
        if (timeout.isPresent()) {
            return ((WebElementFacade)context).withTimeoutOf((int)((Integer)timeout.get()), ChronoUnit.SECONDS);
        }
        return context;
    };
    private static final SearchContextProvider WEBELEMENT_SEARCH_CONTEXT = (context, timeout) -> context;
    private static Map<SearchContextType, SearchContextProvider> SEARCH_CONTEXTS = new HashMap<SearchContextType, SearchContextProvider>();
    private static final List<WebElement> EMPTY_LIST_OF_WEBELEMENTS;

    public SmartAjaxElementLocator(SearchContext searchContext, Field field, MobilePlatform platform) {
        this(Clock.systemDefaultZone(), searchContext, field, platform);
    }

    SmartAjaxElementLocator(Clock clock, SearchContext searchContext, Field field, MobilePlatform platform) {
        super(searchContext, field, platform);
        this.annotatedTimeoutInSeconds = this.timeoutFrom(field);
        this.clock = clock;
        this.field = field;
        this.searchContext = (SearchContext)SEARCH_CONTEXTS.get((Object)this.typeOf(searchContext)).apply(searchContext, this.annotatedTimeoutInSeconds);
        this.platform = platform;
        this.environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
    }

    private SearchContextType typeOf(SearchContext searchContext) {
        if (searchContext instanceof WebDriverFacade) {
            return SearchContextType.WebDriverFacadeContext;
        }
        if (searchContext instanceof WebDriver) {
            return SearchContextType.WebDriverContext;
        }
        if (searchContext instanceof WebElementFacade) {
            return SearchContextType.WebElementFacadeContext;
        }
        if (searchContext instanceof WebElement) {
            return SearchContextType.WebElementFacadeContext;
        }
        return SearchContextType.OtherContext;
    }

    private Optional<Integer> timeoutFrom(Field field) {
        FindBy findBy = field.getAnnotation(FindBy.class);
        if (findBy != null && StringUtils.isNotEmpty((CharSequence)findBy.timeoutInSeconds())) {
            return Optional.of(Integer.valueOf(findBy.timeoutInSeconds()));
        }
        return Optional.empty();
    }

    @Override
    public WebElement findElement() {
        if (this.inADisabledStep()) {
            return new WebElementFacadeStub();
        }
        if (this.shouldFindElementImmediately()) {
            return this.findElementImmediately();
        }
        return this.ajaxFindElement();
    }

    @Override
    @Deprecated
    public void setTimeOutInSeconds(int timeOutInSeconds) {
    }

    private boolean shouldFindElementImmediately() {
        return MethodTiming.forThisThread().isInQuickMethod();
    }

    public WebElement findElementImmediately() {
        WebElement element;
        SmartAnnotations annotations = new SmartAnnotations(this.field, this.platform);
        By by = annotations.buildBy();
        if (this.searchContext instanceof ConfigurableTimeouts) {
            ((ConfigurableTimeouts)this.searchContext).setImplicitTimeout(ZERO_SECONDS);
        }
        try {
            element = this.searchContext.findElement(by);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.searchContext instanceof ConfigurableTimeouts) {
                ((ConfigurableTimeouts)this.searchContext).resetTimeouts();
            }
        }
        if (element == null) {
            throw new NoSuchElementException("No such element found for criteria " + by.toString());
        }
        return element;
    }

    public WebElement ajaxFindElement() {
        SlowLoadingElement loadingElement = new SlowLoadingElement(this.clock, this.annotatedTimeoutInSeconds.orElse(this.getTimeOutInSeconds()));
        try {
            return ((SlowLoadingElement)loadingElement.get()).getElement();
        }
        catch (ElementNotVisibleAfterTimeoutError notVisible) {
            throw new ElementNotVisibleException(String.format("Timed out after %d seconds. %s", this.annotatedTimeoutInSeconds.orElse(this.getTimeOutInSeconds()), notVisible.getMessage()), notVisible.getCause());
        }
        catch (Error e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.annotatedTimeoutInSeconds.orElse(this.getTimeOutInSeconds()), e.getMessage()));
        }
    }

    private int getTimeOutInSeconds() {
        if (this.searchContext instanceof WebDriverFacade) {
            return (int)((WebDriverFacade)this.searchContext).getCurrentImplicitTimeout().getSeconds();
        }
        if (this.searchContext instanceof WebElementFacade) {
            return (int)((WebElementFacade)this.searchContext).getCurrentImplicitTimeout().getSeconds();
        }
        return 0;
    }

    @Override
    public List<WebElement> findElements() {
        if (this.inADisabledStep()) {
            return EMPTY_LIST_OF_WEBELEMENTS;
        }
        SlowLoadingElementList list = new SlowLoadingElementList(this.clock, this.annotatedTimeoutInSeconds.orElse(this.getTimeOutInSeconds()));
        try {
            return ((SlowLoadingElementList)list.get()).getElements();
        }
        catch (Error e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.annotatedTimeoutInSeconds.orElse(this.getTimeOutInSeconds()), e.getMessage()), e.getCause());
        }
    }

    private boolean inADisabledStep() {
        return StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    protected long sleepFor() {
        return 250L;
    }

    public String toString() {
        return this.field != null ? this.field.getDeclaringClass().getSimpleName() + "." + this.field.getName() : "";
    }

    static {
        SEARCH_CONTEXTS.put(SearchContextType.WebDriverFacadeContext, UNMODIFIED_SEARCH_CONTEXT);
        SEARCH_CONTEXTS.put(SearchContextType.WebElementFacadeContext, WEB_ELEMENT_FACADE_WITH_OPTIONAL_TIMEOUT);
        SEARCH_CONTEXTS.put(SearchContextType.WebDriverContext, WEB_DRIVER_FACADE);
        SEARCH_CONTEXTS.put(SearchContextType.WebElementContext, WEBELEMENT_SEARCH_CONTEXT);
        EMPTY_LIST_OF_WEBELEMENTS = new ArrayList<WebElement>();
    }

    private static interface SearchContextProvider
    extends BiFunction<SearchContext, Optional<Integer>, SearchContext> {
    }

    private class SlowLoadingElement
    extends SlowLoadableComponent<SlowLoadingElement> {
        private Optional<WebDriverException> lastException;
        private WebElement element;

        public SlowLoadingElement(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
            this.lastException = Optional.empty();
        }

        protected void load() {
            this.lastException = Optional.empty();
            if (this.element == null) {
                try {
                    this.element = SmartAjaxElementLocator.super.findElement();
                }
                catch (WebDriverException e) {
                    this.lastException = Optional.of(e);
                }
            }
        }

        protected long sleepFor() {
            return SmartAjaxElementLocator.this.sleepFor();
        }

        protected void isLoaded() throws Error {
            if (this.element != null) {
                this.load();
            }
            if (!ElementIsUsable.forElement(this.element)) {
                if (this.lastException.isPresent()) {
                    throw new ElementNotFoundAfterTimeoutError("Element not found", this.lastException.get());
                }
                throw new ElementNotVisibleAfterTimeoutError("Element not available");
            }
        }

        public WebElement getElement() {
            return this.element;
        }
    }

    private class SlowLoadingElementList
    extends SlowLoadableComponent<SlowLoadingElementList> {
        private Optional<WebDriverException> lastException;
        private List<WebElement> elements;

        public SlowLoadingElementList(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
            this.lastException = Optional.empty();
        }

        protected void load() {
            this.lastException = Optional.empty();
            if (this.elements == null) {
                try {
                    this.elements = SmartAjaxElementLocator.super.findElements();
                }
                catch (WebDriverException e) {
                    this.lastException = Optional.of(e);
                }
            }
        }

        protected long sleepFor() {
            return SmartAjaxElementLocator.this.sleepFor();
        }

        protected void isLoaded() throws Error {
            if (this.elements == null) {
                this.load();
            }
            if (!this.areElementsUsable(this.elements)) {
                if (this.lastException.isPresent()) {
                    throw new ElementNotFoundAfterTimeoutError("List elements not found", this.lastException.get());
                }
                throw new ElementNotVisibleAfterTimeoutError("List elements not visible");
            }
        }

        private boolean areElementsUsable(List<WebElement> elements) {
            WebdriverCollectionStrategy collectionStrategy = WebdriverCollectionStrategy.definedIn(SmartAjaxElementLocator.this.environmentVariables);
            return WaitForWebElementCollection.accordingTo(collectionStrategy).areElementsReadyIn(elements);
        }

        public List<WebElement> getElements() {
            return this.elements;
        }

        public String toString() {
            SmartAnnotations annotations = new SmartAnnotations(SmartAjaxElementLocator.this.field, SmartAjaxElementLocator.this.platform);
            By by = annotations.buildBy();
            return by.toString();
        }
    }
}

