/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.Properties;
import java.util.logging.Level;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.logging.LoggingPreferences;

public class AddLoggingPreferences {
    private EnvironmentVariables environmentVariables;

    public AddLoggingPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static AddLoggingPreferences from(EnvironmentVariables environmentVariables) {
        return new AddLoggingPreferences(environmentVariables);
    }

    public void to(MutableCapabilities capabilities) {
        LoggingPreferences logPrefs = new LoggingPreferences();
        Properties logPrefProperties = this.environmentVariables.getPropertiesWithPrefix("webdriver.logprefs");
        if (!logPrefProperties.isEmpty()) {
            logPrefProperties.entrySet().forEach(entry -> {
                String logType = this.unprefixed(entry.getKey().toString()).toLowerCase();
                Level logLevel = Level.parse(entry.getValue().toString().toUpperCase());
                logPrefs.enable(logType, logLevel);
            });
            capabilities.setCapability("loggingPrefs", (Object)logPrefs);
        }
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace("webdriver.logprefs.", "");
    }
}

