/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.annotations.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Methods {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fields.class);
    private final Class<?> clazz;
    private List<Method> currentResults = new ArrayList<Method>();

    public static Methods of(Class<?> testClass) {
        return new Methods(testClass);
    }

    public Methods(Class<?> clazz) {
        this.clazz = clazz;
        this.currentResults = Arrays.asList(clazz.getMethods());
    }

    public Methods called(String name) {
        this.currentResults = this.filterByName(this.currentResults, name);
        return this;
    }

    private List<Method> filterByName(List<Method> currentResults, String name) {
        ArrayList<Method> filteredResults = new ArrayList<Method>();
        for (Method method : currentResults) {
            if (!method.getName().equals(name)) continue;
            filteredResults.add(method);
        }
        return filteredResults;
    }

    public List<Method> asList() {
        return this.currentResults;
    }

    public boolean isEmpty() {
        return this.currentResults.isEmpty();
    }

    public Method first() {
        Preconditions.checkState((!this.currentResults.isEmpty() ? 1 : 0) != 0);
        return this.currentResults.get(0);
    }
}

