/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.WebDriverInitialisationException;
import net.serenitybdd.core.webdriver.enhancers.BeforeAWebdriverScenario;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.SupportedWebDriver;
import org.openqa.selenium.MutableCapabilities;

public class AddCustomDriverCapabilities {
    private final EnvironmentVariables environmentVariables;
    private SupportedWebDriver driver;
    private TestOutcome testOutcome;

    private AddCustomDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public AddCustomDriverCapabilities withTestDetails(SupportedWebDriver driver, TestOutcome testOutcome) {
        this.driver = driver;
        this.testOutcome = testOutcome;
        return this;
    }

    public static AddCustomDriverCapabilities from(EnvironmentVariables environmentVariables) {
        return new AddCustomDriverCapabilities(environmentVariables);
    }

    public MutableCapabilities to(MutableCapabilities capabilities) {
        ArrayList<Class<BeforeAWebdriverScenario>> capabilityEnhancers = new ArrayList<Class<BeforeAWebdriverScenario>>(ClassFinder.loadClasses().thatImplement(BeforeAWebdriverScenario.class).fromPackage("net.serenitybdd").stream().map(extension -> extension).collect(Collectors.toList()));
        capabilityEnhancers.addAll(this.customEnhancers());
        capabilityEnhancers.forEach(enhancerType -> {
            try {
                BeforeAWebdriverScenario beforeScenario = (BeforeAWebdriverScenario)enhancerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (beforeScenario.isActivated(this.environmentVariables)) {
                    beforeScenario.apply(this.environmentVariables, this.driver, this.testOutcome, capabilities);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new WebDriverInitialisationException("Failed to instantiate custom capability enhancer " + enhancerType.getName(), e);
            }
        });
        return capabilities;
    }

    private List<Class<BeforeAWebdriverScenario>> customEnhancers() {
        List extensionPackages = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getListOfValues(ThucydidesSystemProperty.SERENITY_EXTENSION_PACKAGES);
        return extensionPackages.stream().flatMap(extensionPackage -> ClassFinder.loadClasses().thatImplement(BeforeAWebdriverScenario.class).fromPackage(extensionPackage).stream().map(extension -> extension)).collect(Collectors.toList());
    }
}

