/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.shadow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByShadow
extends By {
    private final String target;
    private final String shadowHost;
    private final String[] innerShadowHosts;

    protected ByShadow(String target, String shadowHost, String[] innerShadowHosts) {
        this.target = target;
        this.shadowHost = shadowHost;
        this.innerShadowHosts = innerShadowHosts;
    }

    public static ByShadow cssSelector(String target, String shadowHost, String ... innerShadowHosts) {
        return new ByShadow(target, shadowHost, innerShadowHosts);
    }

    public static ByShadowBuilder css(String target) {
        return new ByShadowBuilder(target);
    }

    public ByShadow thenInHost(String nestedHost) {
        ArrayList<String> innerHosts = new ArrayList<String>(Arrays.asList(this.innerShadowHosts));
        innerHosts.add(nestedHost);
        return new ByShadow(this.target, this.shadowHost, innerHosts.toArray(new String[0]));
    }

    public WebElement findElement(SearchContext context) {
        return this.shadowHostFor(context).findElement(By.cssSelector((String)this.target));
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.shadowHostFor(context).findElements(By.cssSelector((String)this.target));
    }

    private SearchContext shadowHostFor(SearchContext context) {
        WebElement shadowHostElement = context.findElement(By.cssSelector((String)this.shadowHost));
        for (String innerHost : this.innerShadowHosts) {
            shadowHostElement = shadowHostElement.getShadowRoot().findElement(By.cssSelector((String)innerHost));
        }
        return shadowHostElement.getShadowRoot();
    }

    public static class ByShadowBuilder {
        private final String target;

        public ByShadowBuilder(String target) {
            this.target = target;
        }

        public ByShadow inHost(String shadowHost) {
            return new ByShadow(this.target, shadowHost, new String[0]);
        }

        public ByShadow inHosts(String shadowHost, String ... innerShadowHosts) {
            return new ByShadow(this.target, shadowHost, innerShadowHosts);
        }
    }
}

