/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.steps.StepArgumentWriter;

public class ReadableMethodName {
    public static TestNameBuilder forMethod(Method method) {
        return new TestNameBuilder(method);
    }

    public static class TestNameBuilder {
        Method method;
        Object[] args = new Object[0];

        public TestNameBuilder(Method method) {
            this.method = method;
        }

        public TestNameBuilder withArguments(Object[] args) {
            this.args = Arrays.copyOf(args, args.length);
            return this;
        }

        public String asString() {
            StringBuilder testName = new StringBuilder(this.method.getName());
            return testName.append(this.argumentsTo(testName)).toString();
        }

        private String argumentsTo(StringBuilder testName) {
            if (this.args.length == 0) {
                return "";
            }
            List readableArguments = Arrays.stream(this.args).map(StepArgumentWriter::readableFormOf).collect(Collectors.toList());
            return ": " + String.join((CharSequence)", ", readableArguments);
        }
    }
}

