/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.shadow;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByShadow
extends By {
    private final String target;
    private final String shadowHost;
    private final String[] innerShadowHosts;

    protected ByShadow(String target, String shadowHost, String[] innerShadowHosts) {
        this.target = target;
        this.shadowHost = shadowHost;
        this.innerShadowHosts = innerShadowHosts;
    }

    public static ByShadow cssSelector(String target, String shadowHost, String ... innerShadowHosts) {
        return new ByShadow(target, shadowHost, innerShadowHosts);
    }

    public WebElement findElement(SearchContext context) {
        return this.shadowHostFor(context).findElement(By.cssSelector((String)this.target));
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.shadowHostFor(context).findElements(By.cssSelector((String)this.target));
    }

    private SearchContext shadowHostFor(SearchContext context) {
        WebElement shadowHostElement = context.findElement(By.cssSelector((String)this.shadowHost));
        for (String innerHost : this.innerShadowHosts) {
            shadowHostElement = shadowHostElement.getShadowRoot().findElement(By.cssSelector((String)innerHost));
        }
        return shadowHostElement.getShadowRoot();
    }
}

