/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;

public class HostIdentifier {
    private static final Logger log = Logger.getLogger(HostIdentifier.class.getName());
    private static volatile String hostName;
    private static volatile String hostAddress;

    private static String resolveHostName() {
        String host;
        block32: {
            host = System.getenv("HOSTNAME");
            if (host == null) {
                host = System.getenv("COMPUTERNAME");
            }
            if (host == null && Platform.getCurrent().is(Platform.MAC)) {
                try {
                    Process process = Runtime.getRuntime().exec("hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block32;
                    try (InputStreamReader isr = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                         BufferedReader reader = new BufferedReader(isr);){
                        host = reader.readLine();
                    }
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Failed to resolve host name", e);
                }
            }
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable e) {
                host = "Unknown";
                log.log(Level.WARNING, "Failed to resolve host name", e);
            }
        }
        return host;
    }

    private static String resolveHostAddress() {
        String address = null;
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                NetworkInterface en0 = NetworkInterface.getByName("en0");
                Enumeration<InetAddress> addresses = en0.getInetAddresses();
                if (addresses.hasMoreElements()) {
                    address = addresses.nextElement().getHostAddress();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Failed to resolve host address", e);
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                address = "Unknown";
                log.log(Level.WARNING, "Failed to resolve host address", e);
            }
        }
        return address;
    }

    public static synchronized String getHostName() {
        if (hostName == null) {
            hostName = HostIdentifier.resolveHostName();
        }
        return hostName;
    }

    public static synchronized String getHostAddress() {
        if (hostAddress == null) {
            hostAddress = HostIdentifier.resolveHostAddress();
        }
        return hostAddress;
    }
}

