/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.HashMap;
import java.util.List;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.DriverArgs;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ProvideNewDriver;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.webdrivermanager.WebDriverManagerSetup;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.GeckoServicePool;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirefoxDriverProvider
implements DriverProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DriverCapabilityRecord driverProperties;
    private final DriverServicePool driverServicePool = new GeckoServicePool();
    private final FixtureProviderService fixtureProviderService;

    protected String serviceName() {
        return "firefox";
    }

    public FirefoxDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        if (this.isDriverAutomaticallyDownloaded(environmentVariables)) {
            this.logger.info("Using automatically driver download");
            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forFirefox();
        } else {
            this.logger.info("Not using automatically driver download");
        }
        FirefoxOptions firefoxOptions = new FirefoxDriverCapabilities(environmentVariables, options).getOptions();
        SetProxyConfiguration.from(environmentVariables).in((MutableCapabilities)firefoxOptions);
        AddLoggingPreferences.from(environmentVariables).to((MutableCapabilities)firefoxOptions);
        this.driverProperties.registerCapabilities("firefox", this.capabilitiesToProperties((Capabilities)firefoxOptions));
        return ProvideNewDriver.withConfiguration(environmentVariables, (Capabilities)firefoxOptions, this.driverServicePool, DriverServicePool::newDriver, (pool, caps) -> new FirefoxDriver(firefoxOptions));
    }

    private WebDriver newMarionetteDriver(DesiredCapabilities capabilities, EnvironmentVariables environmentVariables, String specifiedOptions) {
        capabilities.setCapability("marionette", true);
        boolean headlessMode = ThucydidesSystemProperty.HEADLESS_MODE.booleanFrom(environmentVariables, Boolean.valueOf(false));
        if (headlessMode) {
            capabilities.setCapability("headless", headlessMode);
        }
        List<String> args = DriverArgs.fromValue(specifiedOptions);
        HashMap<String, List<String>> firefoxOptions = new HashMap<String, List<String>>();
        firefoxOptions.put("args", args);
        capabilities.setCapability("moz:firefoxOptions", firefoxOptions);
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        FirefoxOptions options = new FirefoxOptions((Capabilities)enhancer.enhanced(capabilities, SupportedWebDriver.FIREFOX));
        options.addArguments(DriverArgs.fromValue(specifiedOptions));
        if (headlessMode) {
            options.setHeadless(true);
        }
        DesiredCapabilities enhancedCapabilities = enhancer.enhanced(capabilities, SupportedWebDriver.FIREFOX);
        return ProvideNewDriver.withConfiguration(environmentVariables, (Capabilities)enhancedCapabilities, this.driverServicePool, DriverServicePool::newDriver, (pool, caps) -> new FirefoxDriver(options));
    }
}

