/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.WebDriverInitialisationException;
import net.serenitybdd.core.webdriver.enhancers.CustomDriverEnhancer;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;

public class EnhanceDriver {
    private final EnvironmentVariables environmentVariables;
    private static final List<Class<CustomDriverEnhancer>> ENHANCERS = Collections.synchronizedList(new ArrayList());
    private static AtomicBoolean enhancersLoaded = new AtomicBoolean(false);

    private EnhanceDriver(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static EnhanceDriver from(EnvironmentVariables environmentVariables) {
        return new EnhanceDriver(environmentVariables);
    }

    public WebDriver to(WebDriver driver) {
        this.enhancers().forEach(enhancerType -> {
            try {
                ((CustomDriverEnhancer)enhancerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).apply(this.environmentVariables, driver);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new WebDriverInitialisationException("Failed to instantiate custom driver enhancer " + enhancerType.getName(), e);
            }
        });
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<CustomDriverEnhancer>> enhancers() {
        if (!enhancersLoaded.get()) {
            AtomicBoolean atomicBoolean = enhancersLoaded;
            synchronized (atomicBoolean) {
                ENHANCERS.addAll(ClassFinder.loadClasses().thatImplement(CustomDriverEnhancer.class).fromPackage("net.serenitybdd").stream().map(extension -> extension).collect(Collectors.toList()));
                ENHANCERS.addAll(this.customEnhancers());
                enhancersLoaded.set(true);
            }
        }
        return ENHANCERS;
    }

    private List<Class<CustomDriverEnhancer>> customEnhancers() {
        List extensionPackages = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getListOfValues(ThucydidesSystemProperty.SERENITY_EXTENSION_PACKAGES);
        return extensionPackages.stream().flatMap(extensionPackage -> ClassFinder.loadClasses().thatImplement(CustomDriverEnhancer.class).fromPackage(extensionPackage).stream().map(extension -> extension)).collect(Collectors.toList());
    }
}

