/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import net.serenitybdd.core.webdriver.servicepools.DriverPathConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import net.thucydides.core.ThucydidesSystemProperty;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeServicePool
extends DriverServicePool<EdgeDriverService> {
    @Override
    protected String serviceName() {
        return "edge";
    }

    @Override
    protected WebDriver newDriverInstance(Capabilities capabilities) {
        return new EdgeDriver(capabilities);
    }

    @Override
    protected EdgeDriverService newDriverService() {
        EdgeDriverService newService = (EdgeDriverService)((EdgeDriverService.Builder)((EdgeDriverService.Builder)new EdgeDriverService.Builder().usingDriverExecutable(this.edgeDriverExecutable())).usingAnyFreePort()).build();
        DriverPathConfiguration.updateSystemProperty(ThucydidesSystemProperty.WEBDRIVER_EDGE_DRIVER.getPropertyName()).withExecutablePath(this.edgeDriverExecutable());
        Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)newService));
        return newService;
    }

    private File edgeDriverExecutable() {
        return DriverServiceExecutable.called("MicrosoftWebDriver.exe").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_EDGE_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://www.microsoft.com/en-us/download/details.aspx?id=48212").asAFile();
    }
}

