/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.io.IOException;
import net.serenitybdd.core.photography.PhotoLens;
import net.serenitybdd.core.photography.ScreenShooter;
import net.serenitybdd.core.photography.ScreenShooterFactory;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class WebDriverPhotoLens
implements PhotoLens {
    private final WebDriver driver;
    private final EnvironmentVariables environmentVariables;

    public WebDriverPhotoLens(WebDriver driver) {
        this.driver = driver;
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public byte[] takeScreenshot() throws IOException {
        byte[] screenshotData = null;
        ScreenShooterFactory screenShooterFactory = new ScreenShooterFactory(this.environmentVariables);
        ScreenShooter screenShooter = screenShooterFactory.buildScreenShooter(this);
        if (WebDriverFactory.isAlive(this.driver) && this.unproxied(this.driver) instanceof TakesScreenshot) {
            screenshotData = screenShooter.takeScreenshot();
        }
        return screenshotData;
    }

    private WebDriver unproxied(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)driver).getProxiedDriver();
        }
        return driver;
    }
}

