/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.List;
import java.util.Map;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.DriverArgs;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EdgeDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ProvideNewDriver;
import net.serenitybdd.core.webdriver.driverproviders.SanitisedBrowserPreferences;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.webdrivermanager.WebDriverManagerSetup;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.EdgeServicePool;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.capabilities.BrowserPreferences;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;

public class LegacyEdgeDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final EnvironmentVariables environmentVariables;
    private final DriverServicePool<EdgeDriverService> driverServicePool = new EdgeServicePool();
    private final FixtureProviderService fixtureProviderService;

    public LegacyEdgeDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        if (this.isDriverAutomaticallyDownloaded(environmentVariables)) {
            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forEdge();
        }
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        MutableCapabilities desiredCapabilities = enhancer.enhanced((MutableCapabilities)new EdgeDriverCapabilities(environmentVariables, options).getCapabilities(), SupportedWebDriver.EDGE);
        this.driverProperties.registerCapabilities("edge", this.capabilitiesToProperties((Capabilities)desiredCapabilities));
        SetProxyConfiguration.from(environmentVariables).in(desiredCapabilities);
        AddLoggingPreferences.from(environmentVariables).to(desiredCapabilities);
        EdgeOptions edgeOptions = new EdgeOptions();
        List<String> args = DriverArgs.fromValue(options);
        edgeOptions.addArguments(args);
        if (args.contains("headless") || args.contains("--headless")) {
            edgeOptions.setHeadless(true);
        }
        this.addPreferencesTo(edgeOptions);
        EdgeOptions enhancedOptions = edgeOptions.merge((Capabilities)desiredCapabilities);
        return ProvideNewDriver.withConfiguration(environmentVariables, (Capabilities)desiredCapabilities, this.driverServicePool, DriverServicePool::newDriver, (pool, caps) -> new EdgeDriver(enhancedOptions));
    }

    public static Map<String, Object> optionsConfiguredIn(EnvironmentVariables environmentVariables) {
        Map<String, Object> chromePreferences = BrowserPreferences.startingWith("edge.options.").from(environmentVariables);
        return SanitisedBrowserPreferences.cleanUpPathsIn(chromePreferences);
    }

    private void addPreferencesTo(EdgeOptions options) {
        Map<String, Object> optionValues = LegacyEdgeDriverProvider.optionsConfiguredIn(this.environmentVariables);
        optionValues.forEach((arg_0, arg_1) -> ((EdgeOptions)options).setCapability(arg_0, arg_1));
    }
}

