/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.SupportedWebDriver;

public class CustomCapabilities {
    private static final String COMMON_PREFIX = "driver_capabilities.common";
    private final SupportedWebDriver driver;

    private CustomCapabilities(SupportedWebDriver driver) {
        this.driver = driver;
    }

    public Map<String, ?> from(EnvironmentVariables environmentVariables) {
        Map<String, Object> capabilities = this.mapFrom(environmentVariables.getPropertiesWithPrefix(COMMON_PREFIX));
        Map<String, Object> driverSpecificProperties = this.mapFrom(environmentVariables.getPropertiesWithPrefix(this.driverPrefix()));
        capabilities.putAll(driverSpecificProperties);
        return capabilities;
    }

    private Map<String, Object> mapFrom(Properties driverSpecificProperties) {
        return driverSpecificProperties.entrySet().stream().collect(Collectors.toMap(entry -> this.stripPrefixFrom(entry.getKey().toString()), entry -> CustomCapabilities.stringOrBooleanFrom(entry.getValue())));
    }

    private String stripPrefixFrom(String key) {
        return key.replace(this.driverPrefix() + ".", "").replace("driver_capabilities.common.", "");
    }

    private String driverPrefix() {
        return "driver_capabilities." + this.driver.toString().toLowerCase();
    }

    private static Object stringOrBooleanFrom(Object value) {
        if (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false")) {
            return Boolean.valueOf(value.toString());
        }
        return value.toString();
    }

    public static CustomCapabilities forDriver(SupportedWebDriver driver) {
        return new CustomCapabilities(driver);
    }
}

