/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.AddCustomDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.AppiumDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.EdgeDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ProvidedDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverName;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DriverCapabilities {
    public static final DriverCapabilitiesProvider DEFAULT_CAPABILITIES = DesiredCapabilities::new;
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer enhancer;
    private static final Integer EXTRA_TIME_TO_TAKE_SCREENSHOTS = 180;

    public DriverCapabilities(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.enhancer = enhancer;
    }

    public MutableCapabilities forDriver(String driverName, String options) {
        if (driverName == null || driverName.startsWith(":")) {
            driverName = "remote";
        }
        SupportedWebDriver driverType = this.driverTypeFor(this.driverComponentof(driverName));
        Preconditions.checkNotNull((Object)((Object)driverType), (Object)("Unsupported remote driver type: " + driverName));
        if (this.shouldUseARemoteDriver()) {
            return this.enhancer.enhanced(this.remoteCapabilities(options), driverType);
        }
        return this.enhancer.enhanced(this.realBrowserCapabilities(driverType, options), driverType);
    }

    private String driverComponentof(String driverName) {
        return driverName.contains(":") ? driverName.split(":")[0] : driverName;
    }

    private SupportedWebDriver driverTypeFor(String driver) {
        if (!SupportedWebDriver.isSupported(driver)) {
            SupportedWebDriver closestDriver = SupportedWebDriver.getClosestDriverValueTo(driver);
            throw new AssertionError((Object)("Unsupported driver for webdriver.driver or webdriver.remote.driver: " + driver + ". Did you mean " + closestDriver.toString().toLowerCase() + "?"));
        }
        return SupportedWebDriver.valueOrSynonymOf(driver);
    }

    private Map<SupportedWebDriver, DriverCapabilitiesProvider> driverCapabilitiesSelector(String options) {
        HashMap<SupportedWebDriver, DriverCapabilitiesProvider> selectors = new HashMap<SupportedWebDriver, DriverCapabilitiesProvider>();
        selectors.put(SupportedWebDriver.CHROME, new ChromeDriverCapabilities(this.environmentVariables, options));
        selectors.put(SupportedWebDriver.FIREFOX, new FirefoxDriverCapabilities(this.environmentVariables));
        selectors.put(SupportedWebDriver.APPIUM, new AppiumDriverCapabilities(this.environmentVariables, options));
        selectors.put(SupportedWebDriver.PROVIDED, new ProvidedDriverCapabilities(this.environmentVariables));
        selectors.put(SupportedWebDriver.EDGE, new EdgeDriverCapabilities(this.environmentVariables, options));
        return selectors;
    }

    public MutableCapabilities realBrowserCapabilities(SupportedWebDriver driverType, String options) {
        return this.enhancer.enhanced(this.driverCapabilitiesSelector(options).getOrDefault((Object)driverType, DEFAULT_CAPABILITIES).getCapabilities(), driverType);
    }

    private boolean isUndefined(String browser) {
        return browser == null || browser.startsWith(":");
    }

    private MutableCapabilities remoteCapabilities(String options) {
        String remoteBrowser = RemoteDriverName.definedIn(this.environmentVariables);
        Object capabilities = !this.isUndefined(remoteBrowser) ? this.realBrowserCapabilities(this.driverTypeFor(remoteBrowser), options) : new DesiredCapabilities();
        capabilities.setCapability("idle-timeout", (Object)EXTRA_TIME_TO_TAKE_SCREENSHOTS);
        if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
            capabilities.setCapability("platform", Platform.valueOf((String)ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables)));
        }
        if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables) != null) {
            capabilities.setCapability("version", ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables));
        }
        if (StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            AddCustomDriverCapabilities.from(this.environmentVariables).withTestDetails(SupportedWebDriver.REMOTE, StepEventBus.getEventBus().getBaseStepListener().getCurrentTestOutcome()).to((MutableCapabilities)capabilities);
        }
        capabilities.merge((Capabilities)W3CCapabilities.definedIn(this.environmentVariables).withPrefix("webdriver.capabilities").asDesiredCapabilities());
        return capabilities;
    }

    private boolean shouldUseARemoteDriver() {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables));
    }
}

