/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Splitter;
import io.appium.java_client.AppiumDriver;
import java.net.MalformedURLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.serenitybdd.core.webdriver.driverproviders.AppiumDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EdgeDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceDriver;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.InternetExplorerDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ProvidedDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.SafariDriverProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.DriverConfigurationError;
import net.thucydides.core.webdriver.DriverStrategySelector;
import net.thucydides.core.webdriver.PauseTestExecution;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.TimeoutStack;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.redimension.RedimensionBrowser;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    public static final String DEFAULT_DRIVER = "chrome";
    public static final String REMOTE_DRIVER = "remote";
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;
    private final CloseBrowser closeBrowser;
    private Map<SupportedWebDriver, DriverProvider> driverProvidersByDriverType;
    private final TimeoutStack timeoutStack;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFactory.class);

    public WebDriverFactory() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(environmentVariables, (FixtureProviderService)WebDriverInjectors.getInjector().getInstance(FixtureProviderService.class));
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
        this.timeoutStack = new TimeoutStack();
        this.closeBrowser = (CloseBrowser)WebDriverInjectors.getInjector().getInstance(CloseBrowser.class);
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService, TimeoutStack timeoutStack, CloseBrowser closeBrowser) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
        this.timeoutStack = timeoutStack;
        this.closeBrowser = closeBrowser;
    }

    public WebDriverFactory withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new WebDriverFactory(environmentVariables, this.fixtureProviderService, this.timeoutStack, this.closeBrowser);
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        return driverType.getWebdriverClass();
    }

    public boolean usesSauceLabs() {
        return StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables));
    }

    private Map<SupportedWebDriver, DriverProvider> driverProviders() {
        if (this.driverProvidersByDriverType == null) {
            this.driverProvidersByDriverType = new HashMap<SupportedWebDriver, DriverProvider>();
            this.driverProvidersByDriverType.put(SupportedWebDriver.CHROME, new ChromeDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.REMOTE, new RemoteDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.EDGE, new EdgeDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.FIREFOX, new FirefoxDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.SAFARI, new SafariDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.IEXPLORER, new InternetExplorerDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.PROVIDED, new ProvidedDriverProvider());
            this.driverProvidersByDriverType.put(SupportedWebDriver.APPIUM, new AppiumDriverProvider(this.fixtureProviderService));
        }
        return this.driverProvidersByDriverType;
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        String driverOptions = ThucydidesSystemProperty.DRIVER_OPTIONS.from(this.environmentVariables, "");
        return this.newWebdriverInstance(driverClass, driverOptions);
    }

    private synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass, String options) {
        return this.newWebdriverInstance(driverClass, options, this.environmentVariables);
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass, String options, EnvironmentVariables environmentVariables) {
        try {
            return this.createWebDriver(driverClass, options, environmentVariables);
        }
        catch (SerenityManagedException toPassThrough) {
            throw toPassThrough;
        }
        catch (Exception cause) {
            if (this.shouldRetry(cause)) {
                LOGGER.debug("Waiting to retry: " + cause.getMessage() + ")");
                return this.waitThenRetry(driverClass, options, environmentVariables);
            }
            throw new DriverConfigurationError("WebDriver was unable to create a new instance of type " + driverClass + System.lineSeparator() + "WebDriver reported the following message: " + cause.getMessage() + System.lineSeparator() + "See below for more details.", cause);
        }
    }

    private WebDriver createWebDriver(Class<? extends WebDriver> driverClass, String options, EnvironmentVariables environmentVariables) throws MalformedURLException {
        RedimensionBrowser redimensionBrowser = new RedimensionBrowser(environmentVariables);
        SupportedWebDriver supportedDriverType = DriverStrategySelector.inEnvironment(environmentVariables).forDriverClass(driverClass);
        String resolvedOptions = options.isEmpty() ? ThucydidesWebDriverSupport.getDefaultDriverOptions().orElse(options) : options;
        WebDriver driver = this.driverProviders().get((Object)supportedDriverType).newInstance(resolvedOptions, environmentVariables);
        this.setImplicitTimeoutsIfSpecified(driver);
        redimensionBrowser.withDriver(driver);
        EnhanceDriver.from(environmentVariables).to(driver);
        this.closeBrowser.closeWhenTheTestsAreFinished(driver);
        return driver;
    }

    private WebDriver waitThenRetry(Class<? extends WebDriver> driverClass, String options, EnvironmentVariables environmentVariables) {
        int maxRetryCount = ThucydidesSystemProperty.WEBDRIVER_CREATION_RETRY_MAX_TIME.integerFrom(environmentVariables, 30);
        return this.waitThenRetry(maxRetryCount, driverClass, options, environmentVariables, null);
    }

    private WebDriver waitThenRetry(int remainingTries, Class<? extends WebDriver> driverClass, String options, EnvironmentVariables environmentVariables, Exception cause) {
        LOGGER.debug("Remaining tries: " + remainingTries);
        if (remainingTries == 0) {
            throw new DriverConfigurationError("After several attempts, could not instantiate new WebDriver instance of type " + driverClass + " (" + cause.getMessage() + "). See below for more details.", cause);
        }
        PauseTestExecution.forADelayOf(30).seconds();
        try {
            return this.createWebDriver(driverClass, options, environmentVariables);
        }
        catch (SerenityManagedException toPassThrough) {
            throw toPassThrough;
        }
        catch (Exception latestCause) {
            return this.waitThenRetry(remainingTries - 1, driverClass, options, environmentVariables, latestCause);
        }
    }

    private boolean shouldRetry(Exception cause) {
        List RETRY_CAUSES = Splitter.on((String)";").trimResults().omitEmptyStrings().splitToList((CharSequence)ThucydidesSystemProperty.WEBDRIVER_CREATION_RETRY_CAUSES.from(this.environmentVariables, "All parallel tests are currently in use"));
        return RETRY_CAUSES.stream().anyMatch(partialErrorMessage -> cause != null && cause.getMessage() != null && cause.getMessage().contains((CharSequence)partialErrorMessage));
    }

    private void setImplicitTimeoutsIfSpecified(WebDriver driver) {
        if (ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.isDefinedIn(this.environmentVariables)) {
            int timeout = ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.integerFrom(this.environmentVariables, 0);
            driver.manage().timeouts().implicitlyWait(Duration.ofMillis(timeout));
        }
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables, String defaultDriver) {
        String driver = WebDriverFactory.getDriverFrom(environmentVariables);
        return driver != null ? driver : defaultDriver;
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new ThucydidesSystemProperty[]{ThucydidesSystemProperty.WEBDRIVER_DRIVER, ThucydidesSystemProperty.DRIVER, ThucydidesSystemProperty.WEBDRIVER_CAPABILITIES_BROWSERNAME}).orElse(null);
    }

    public void setupFixtureServices() throws FixtureException {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.setup();
        }
    }

    public void shutdownFixtureServices() {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.shutdown();
        }
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock") && !driver.toString().contains("Mock for");
    }

    public void setTimeouts(WebDriver proxiedDriver, Duration implicitTimeout) {
        Duration currentTimeout = this.currentTimeoutFor(proxiedDriver);
        this.timeoutStack.pushTimeoutFor(proxiedDriver, implicitTimeout);
        if (implicitTimeout != currentTimeout && this.isNotAMocked(proxiedDriver)) {
            proxiedDriver.manage().timeouts().implicitlyWait(implicitTimeout);
        }
    }

    public Duration currentTimeoutFor(WebDriver proxiedDriver) {
        Optional<Duration> storedTimeoutValue = this.timeoutStack.currentTimeoutValueFor(proxiedDriver);
        return storedTimeoutValue.orElse(this.getDefaultImplicitTimeout());
    }

    public Duration resetTimeouts(WebDriver proxiedDriver) {
        Duration currentTimeout = this.currentTimeoutFor(proxiedDriver);
        if (!this.timeoutStack.containsTimeoutFor(proxiedDriver).booleanValue()) {
            return currentTimeout;
        }
        this.timeoutStack.popTimeoutFor(proxiedDriver);
        Duration previousTimeout = this.currentTimeoutFor(proxiedDriver);
        if (currentTimeout != previousTimeout && this.isNotAMocked(proxiedDriver)) {
            proxiedDriver.manage().timeouts().implicitlyWait(previousTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return previousTimeout;
    }

    public Duration getDefaultImplicitTimeout() {
        String configuredTimeoutValue = ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.from(this.environmentVariables);
        return configuredTimeoutValue != null ? Duration.ofMillis(Integer.parseInt(configuredTimeoutValue)) : DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    public static boolean isAlive(WebDriver driver) {
        try {
            WebDriver local = driver;
            if (driver instanceof WebDriverFacade) {
                local = ((WebDriverFacade)driver).getDriverInstance();
            }
            if (!(local instanceof AppiumDriver)) {
                local.getCurrentUrl();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNotAlive(WebDriver driver) {
        return !WebDriverFactory.isAlive(driver);
    }

    public void releaseTimoutFor(WebDriver driverInstance) {
        this.timeoutStack.releaseTimeoutFor(driverInstance);
    }
}

