/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import net.serenitybdd.core.photography.Darkroom;
import net.serenitybdd.core.photography.PhotoLens;
import net.serenitybdd.core.photography.PhotoSession;
import net.serenitybdd.core.photography.ScreenshotPhoto;
import net.thucydides.core.screenshots.BlurLevel;

public class PhotoSessionBooking {
    private final Darkroom darkroom;
    private PhotoLens lens;
    private Path outputDirectory;
    private BlurLevel blurLevel;

    public PhotoSessionBooking(Darkroom darkroom) {
        this.darkroom = darkroom;
    }

    public PhotoSessionBooking with(PhotoLens lens) {
        this.lens = lens;
        return this;
    }

    public PhotoSessionBooking andWithBlurring(BlurLevel blurLevel) {
        this.blurLevel = blurLevel;
        return this;
    }

    public PhotoSessionBooking toDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public ScreenshotPhoto takeScreenshot() {
        Preconditions.checkNotNull((Object)this.lens);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        return this.inPhotoSession().takeScreenshot();
    }

    private PhotoSession inPhotoSession() {
        return new PhotoSession(this.lens, this.darkroom, this.outputDirectory, this.blurLevel);
    }
}

