/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.webdriver.driverproviders.ConfiguredProxy;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.configuration.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.BrowserPreferences;
import net.thucydides.core.webdriver.firefox.FirefoxProfileEnhancer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.ProfilesIni;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;
    private final FirefoxProfileEnhancer firefoxProfileEnhancer;
    private final String options;
    private ProfilesIni allProfiles;

    public FirefoxDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = new FirefoxProfileEnhancer(environmentVariables);
        this.options = "";
    }

    public FirefoxDriverCapabilities(EnvironmentVariables environmentVariables, String options) {
        this.environmentVariables = environmentVariables;
        this.firefoxProfileEnhancer = new FirefoxProfileEnhancer(environmentVariables);
        this.options = options;
    }

    public DesiredCapabilities getCapabilities() {
        return new DesiredCapabilities((Capabilities)this.getOptions());
    }

    public FirefoxOptions getOptions() {
        List<String> argValues;
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        Map<String, Object> firefoxCapabilities = BrowserPreferences.startingWith("firefox.").from(this.environmentVariables);
        firefoxCapabilities.remove("preferences");
        Map<String, Object> firefoxPreferences = BrowserPreferences.startingWith("firefox.preferences.").from(this.environmentVariables);
        firefoxPreferences.forEach((key, value) -> {
            if (value instanceof String) {
                String instantiatedValue = FilePathParser.forEnvironmentVariables((EnvironmentVariables)this.environmentVariables).getInstanciatedPath(value.toString());
                firefoxOptions.addPreference(key, (Object)instantiatedValue);
            } else if (value instanceof Boolean) {
                firefoxOptions.addPreference(key, value);
            } else if (value instanceof Integer) {
                firefoxOptions.addPreference(key, value);
            }
        });
        ArrayList<String> registeredArguments = new ArrayList<String>();
        Object firefoxArguments = firefoxCapabilities.remove("arguments");
        if (firefoxArguments instanceof List) {
            argValues = ((List)firefoxArguments).stream().map(Object::toString).collect(Collectors.toList());
            firefoxOptions.addArguments(argValues);
            registeredArguments.addAll(argValues);
        } else if (firefoxArguments != null) {
            argValues = this.listOfArgumentsIn(firefoxArguments.toString());
            firefoxOptions.addArguments(argValues);
            registeredArguments.addAll(argValues);
        }
        argValues = Arrays.asList(this.options.split(";"));
        firefoxOptions.addArguments(argValues);
        registeredArguments.addAll(argValues);
        if (registeredArguments.contains("headless")) {
            firefoxOptions.setHeadless(true);
        }
        firefoxCapabilities.forEach((key, value) -> {
            if (!key.startsWith("preferences.")) {
                firefoxOptions.setCapability(key, value);
            }
        });
        if (firefoxCapabilities.containsKey("logLevel")) {
            FirefoxDriverLogLevel logLevel = FirefoxDriverLogLevel.fromString((String)firefoxCapabilities.get("logLevel").toString());
            firefoxOptions.setLogLevel(logLevel);
        }
        if (firefoxCapabilities.containsKey("pageLoadStrategy")) {
            PageLoadStrategy loadStrategy = PageLoadStrategy.fromString((String)firefoxCapabilities.get("pageLoadStrategy").toString());
            firefoxOptions.setPageLoadStrategy(loadStrategy);
        }
        ConfiguredProxy.definedIn(this.environmentVariables).ifPresent(arg_0 -> ((FirefoxOptions)firefoxOptions).setProxy(arg_0));
        if (firefoxCapabilities.containsKey("profile")) {
            String profilePath = FilePathParser.forEnvironmentVariables((EnvironmentVariables)this.environmentVariables).getInstanciatedPath(firefoxCapabilities.get("profile").toString());
            firefoxOptions.setProfile(new FirefoxProfile(new File(profilePath)));
        } else {
            firefoxOptions.setProfile(this.buildFirefoxProfile());
        }
        return firefoxOptions;
    }

    private List<String> listOfArgumentsIn(String argumentsValue) {
        if (argumentsValue.trim().startsWith("[") && argumentsValue.trim().endsWith("]")) {
            argumentsValue = argumentsValue.substring(1, argumentsValue.lastIndexOf("]"));
        }
        return Splitter.on((String)",").trimResults().splitToList((CharSequence)argumentsValue);
    }

    private FirefoxProfile buildFirefoxProfile() {
        String profileName = ThucydidesSystemProperty.WEBDRIVER_FIREFOX_PROFILE.from(this.environmentVariables);
        FilePathParser parser = new FilePathParser(this.environmentVariables);
        FirefoxProfile profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
        this.firefoxProfileEnhancer.allowWindowResizeFor(profile);
        if (this.shouldActivateProxy()) {
            this.activateProxyFor(profile, this.firefoxProfileEnhancer);
        }
        if (this.refuseUntrustedCertificates()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
            profile.setAcceptUntrustedCertificates(false);
        } else {
            profile.setAssumeUntrustedCertificateIssuer(true);
            profile.setAcceptUntrustedCertificates(true);
        }
        this.firefoxProfileEnhancer.configureJavaSupport(profile);
        this.firefoxProfileEnhancer.addPreferences(profile);
        return profile;
    }

    private void activateProxyFor(FirefoxProfile profile, FirefoxProfileEnhancer firefoxProfileEnhancer) {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        String proxyPort = this.getProxyPortFromEnvironmentVariables();
        firefoxProfileEnhancer.activateProxy(profile, proxyUrl, proxyPort);
    }

    private String getProxyPortFromEnvironmentVariables() {
        return ThucydidesSystemProperty.SERENITY_PROXY_HTTP_PORT.from(this.environmentVariables);
    }

    private boolean shouldActivateProxy() {
        String proxyUrl = this.getProxyUrlFromEnvironmentVariables();
        return StringUtils.isNotEmpty((CharSequence)proxyUrl);
    }

    private String getProxyUrlFromEnvironmentVariables() {
        return ThucydidesSystemProperty.SERENITY_PROXY_HTTP.from(this.environmentVariables);
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    private FirefoxProfile createNewFirefoxProfile() {
        FirefoxProfile profile;
        if (Serenity.getFirefoxProfile() != null) {
            profile = Serenity.getFirefoxProfile();
        } else {
            profile = new FirefoxProfile();
            profile.setPreference("network.proxy.socks_port", (Object)9999);
            profile.setAlwaysLoadNoFocusLib(true);
        }
        return profile;
    }

    private FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    private boolean refuseUntrustedCertificates() {
        return ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.booleanFrom(this.environmentVariables);
    }
}

