/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Splitter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.AddCustomDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceCapabilitiesWithFixtures;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverConfigurationError;
import net.serenitybdd.core.webdriver.driverproviders.RemoteWebdriverStub;
import net.serenitybdd.core.webdriver.driverproviders.cache.PreScenarioFixtures;
import net.serenitybdd.core.webdriver.enhancers.ProvidesRemoteWebdriverUrl;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteDriverProvider
implements DriverProvider {
    public static final String MISSING_REMOTE_DRIVER_PROPERTY = "Remote driver not specified";
    private final FixtureProviderService fixtureProviderService;

    public RemoteDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return RemoteWebdriverStub.from(environmentVariables);
        }
        URL remoteUrl = this.getRemoteUrlFrom(environmentVariables);
        String driverName = this.getRemoteDriverNameFrom(environmentVariables);
        Object capabilities = W3CCapabilities.definedIn(environmentVariables).withPrefix("webdriver.capabilities").forDriver(SupportedWebDriver.getDriverTypeFor(driverName));
        if (capabilities instanceof ChromiumOptions) {
            ((ChromiumOptions)capabilities).addArguments(this.argumentsIn(options));
        } else if (capabilities instanceof FirefoxOptions) {
            ((FirefoxOptions)capabilities).addArguments(this.argumentsIn(options));
        }
        EnhanceCapabilitiesWithFixtures.using(this.fixtureProviderService).into((MutableCapabilities)capabilities);
        AddCustomDriverCapabilities.from(environmentVariables).withTestDetails(SupportedWebDriver.getDriverTypeFor(driverName), StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome()).to((MutableCapabilities)capabilities);
        TestContext.forTheCurrentTest().recordBrowserAndPlatformConfiguration((Capabilities)capabilities);
        return new RemoteWebDriver(remoteUrl, capabilities);
    }

    private URL getRemoteUrlFrom(EnvironmentVariables environmentVariables) {
        String remoteUrl = null;
        try {
            Optional environmentDefinedRemoteUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL);
            if (environmentDefinedRemoteUrl.isPresent()) {
                remoteUrl = (String)environmentDefinedRemoteUrl.get();
            } else {
                Optional<String> remoteUrlDefinedInFixtureClasses = this.getRemoteUrlFromFixtureClasses(environmentVariables);
                if (remoteUrlDefinedInFixtureClasses.isPresent()) {
                    remoteUrl = remoteUrlDefinedInFixtureClasses.get();
                }
            }
            if (remoteUrl == null) {
                throw new RemoteDriverConfigurationError("A webdriver.remote.url property must be defined when using a Remote driver.");
            }
            return new URL(remoteUrl);
        }
        catch (MalformedURLException e) {
            throw new RemoteDriverConfigurationError("Incorrectly formed webdriver.remote.url property: " + remoteUrl, e);
        }
    }

    private String getRemoteDriverNameFrom(EnvironmentVariables environmentVariables) {
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"webdriver.capabilities.browserName"}).orElseGet(() -> (String)EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new ThucydidesSystemProperty[]{ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER, ThucydidesSystemProperty.WEBDRIVER_DRIVER}).orElseThrow(() -> new RemoteDriverConfigurationError(MISSING_REMOTE_DRIVER_PROPERTY)));
    }

    private List<String> argumentsIn(String options) {
        return Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)options);
    }

    private Optional<String> getRemoteUrlFromFixtureClasses(EnvironmentVariables environmentVariables) {
        return PreScenarioFixtures.executeBeforeAWebdriverScenario().stream().filter(fixture -> fixture.isActivated(environmentVariables)).filter(fixture -> fixture instanceof ProvidesRemoteWebdriverUrl).map(fixture -> (ProvidesRemoteWebdriverUrl)((Object)fixture)).filter(fixture -> fixture.remoteUrlDefinedIn(environmentVariables).isPresent()).map(fixture -> fixture.remoteUrlDefinedIn(environmentVariables).orElse(null)).filter(Objects::nonNull).findFirst();
    }
}

