/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.logging.LoggingPreferences;

public class AddLoggingPreferences {
    private EnvironmentVariables environmentVariables;

    public AddLoggingPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static AddLoggingPreferences from(EnvironmentVariables environmentVariables) {
        return new AddLoggingPreferences(environmentVariables);
    }

    public void to(MutableCapabilities capabilities) {
        LoggingPreferences logPrefs = new LoggingPreferences();
        Properties logPrefProperties = this.environmentVariables.getPropertiesWithPrefix("webdriver.logprefs");
        if (!logPrefProperties.isEmpty()) {
            logPrefProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                String logType = this.unprefixed(key.toString()).toLowerCase();
                Level logLevel = Level.parse(value.toString().toUpperCase());
                logPrefs.enable(logType, logLevel);
            }));
            if (capabilities instanceof ChromeOptions) {
                capabilities.setCapability("goog:loggingPrefs", (Object)logPrefs);
            } else if (capabilities instanceof EdgeOptions) {
                capabilities.setCapability("ms:loggingPrefs", (Object)logPrefs);
            }
        }
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace("webdriver.logprefs.", "");
    }
}

