/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.ConfigureChromiumOptions;
import net.serenitybdd.core.webdriver.driverproviders.DownloadableDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EnhanceCapabilitiesWithFixtures;
import net.serenitybdd.core.webdriver.driverproviders.UpdateDriverEnvironmentProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.W3CCapabilities;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverProvider
extends DownloadableDriverProvider
implements DriverProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeDriverProvider.class);
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public ChromeDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        this.downloadDriverIfRequired("chrome", environmentVariables);
        UpdateDriverEnvironmentProperty.forDriverProperty("webdriver.chrome.driver");
        ChromeOptions chromeOptions = W3CCapabilities.definedIn(environmentVariables).withPrefix("webdriver.capabilities").chromeOptions();
        ChromeOptions enhancedOptions = (ChromeOptions)ConfigureChromiumOptions.from(environmentVariables).into((ChromiumOptions<?>)chromeOptions);
        EnhanceCapabilitiesWithFixtures.using(this.fixtureProviderService).into((MutableCapabilities)enhancedOptions);
        TestContext.forTheCurrentTest().recordBrowserConfiguration((Capabilities)enhancedOptions);
        TestContext.forTheCurrentTest().recordCurrentPlatform();
        enhancedOptions.addArguments(this.argumentsIn(options));
        this.driverProperties.registerCapabilities("chrome", this.capabilitiesToProperties((Capabilities)enhancedOptions));
        LOGGER.info("Starting Chrome driver instance with capabilities:");
        LOGGER.info(enhancedOptions.toString());
        return new ChromeDriver(enhancedOptions);
    }
}

