/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import net.serenitybdd.core.pages.PageObject;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.steps.EnclosingClass;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageFactory.class);
    private WebDriver driver;

    public PageFactory(WebDriver driver) {
        this.driver = driver;
    }

    private WebDriver getDriver() {
        return this.driver;
    }

    public <T extends PageObject> T createPageOfType(Class<T> pageObjectClass) {
        T currentPage = null;
        try {
            currentPage = this.createFromSimpleConstructor(pageObjectClass);
            if (currentPage == null) {
                currentPage = this.createFromConstructorWithWebdriver(pageObjectClass);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("This page object does not appear have a constructor that takes a WebDriver parameter: {} ({})", pageObjectClass, (Object)e.getMessage());
            this.thisPageObjectLooksDodgy(pageObjectClass, "This page object does not appear have a constructor that takes a WebDriver parameter");
        }
        catch (InvocationTargetException e) {
            LOGGER.warn("Failed to instantiate page of type {} ({})", pageObjectClass, (Object)e.getTargetException());
            this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page (" + String.valueOf(e.getTargetException()) + ")");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to instantiate page of type {} ({})", pageObjectClass, (Object)e);
            this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page (" + String.valueOf(e) + ")");
        }
        return currentPage;
    }

    private <T extends PageObject> T createFromSimpleConstructor(Class<T> pageObjectClass) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        PageObject newPage = null;
        try {
            if (this.hasDefaultConstructor(pageObjectClass)) {
                Class[] constructorArgs = new Class[]{};
                Constructor<T> constructor = pageObjectClass.getDeclaredConstructor(constructorArgs);
                constructor.setAccessible(true);
                newPage = (PageObject)constructor.newInstance(new Object[0]);
                newPage.setDriver(this.getDriver());
            } else if (this.hasOuterClassConstructor(pageObjectClass)) {
                Constructor<T> constructor = pageObjectClass.getDeclaredConstructor(pageObjectClass.getEnclosingClass());
                constructor.setAccessible(true);
                newPage = (PageObject)constructor.newInstance(EnclosingClass.of(pageObjectClass).newInstance());
                newPage.setDriver(this.getDriver());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return (T)newPage;
    }

    private <T extends PageObject> boolean hasDefaultConstructor(Class<T> pageObjectClass) {
        return Arrays.stream(pageObjectClass.getDeclaredConstructors()).anyMatch(constructor -> constructor.getParameters().length == 0);
    }

    private <T extends PageObject> boolean hasOuterClassConstructor(Class<T> pageObjectClass) {
        return Arrays.stream(pageObjectClass.getConstructors()).anyMatch(constructor -> constructor.getParameters().length == 1 && constructor.getParameters()[0].getType() == pageObjectClass.getEnclosingClass());
    }

    private <T extends PageObject> T createFromConstructorWithWebdriver(Class<T> pageObjectClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class[] constructorArgs = new Class[]{WebDriver.class};
        Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
        return (T)((PageObject)constructor.newInstance(this.getDriver()));
    }

    private void thisPageObjectLooksDodgy(Class<? extends PageObject> pageObjectClass, String message) {
        String errorDetails = "The page object " + String.valueOf(pageObjectClass) + " could not be instantiated:\n" + message;
        throw new WrongPageError(errorDetails);
    }
}

