/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import net.thucydides.model.ThucydidesSystemProperty;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriverLogLevel;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeServicePool
extends DriverServicePool<ChromeDriverService> {
    @Override
    protected String serviceName() {
        return "chrome";
    }

    @Override
    protected WebDriver newDriverInstance(Capabilities capabilities) {
        ChromeOptions options = new ChromeOptions();
        options.merge(capabilities);
        return new ChromeDriver(options);
    }

    @Override
    protected ChromeDriverService newDriverService() {
        String driver = this.environmentVariables.getProperty("webdriver.chrome.driver", this.chromeDriverExecutable().getAbsolutePath());
        String logFile = this.environmentVariables.getProperty("webdriver.chrome.logfile");
        String logLevel = this.environmentVariables.getProperty("webdriver.chrome.logLevel");
        boolean appendLog = this.environmentVariables.getPropertyAsBoolean("webdriver.chrome.appendLog", false);
        boolean disableBuildCheck = this.environmentVariables.getPropertyAsBoolean("webdriver.chrome.disableBuildCheck", false);
        boolean verbose = this.environmentVariables.getPropertyAsBoolean("webdriver.chrome.verboseLogging", false);
        boolean silent = this.environmentVariables.getPropertyAsBoolean("webdriver.chrome.silentOutput", false);
        String whitelist = this.environmentVariables.getProperty("webdriver.chrome.withAllowedIps", "");
        ChromeDriverService.Builder builder = ((ChromeDriverService.Builder)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingDriverExecutable(this.chromeDriverExecutable())).usingAnyFreePort()).withSilent(silent).withAppendLog(appendLog).withVerbose(verbose);
        if (!whitelist.isEmpty()) {
            builder.withWhitelistedIps(whitelist);
        }
        if (!logLevel.isEmpty()) {
            builder.withLogLevel(ChromiumDriverLogLevel.fromString((String)logLevel));
        }
        if (disableBuildCheck) {
            System.setProperty("webdriver.chrome.disableBuildCheck", "true");
        }
        if (!logFile.isEmpty()) {
            System.setProperty("webdriver.chrome.logfile", logFile);
        }
        if (!driver.isEmpty()) {
            builder.usingDriverExecutable(new File(driver));
        }
        ChromeDriverService newService = (ChromeDriverService)builder.build();
        Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)newService));
        return newService;
    }

    private File chromeDriverExecutable() {
        return DriverServiceExecutable.called("chromedriver").withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).reportMissingBinary().downloadableFrom("https://sites.google.com/a/chromium.org/chromedriver/downloads").asAFile();
    }
}

