/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import net.serenitybdd.annotations.Fields;
import net.serenitybdd.annotations.Pending;
import net.serenitybdd.annotations.Step;
import net.serenitybdd.annotations.StepGroup;
import net.serenitybdd.annotations.TestAnnotations;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SkipNested;
import net.serenitybdd.core.steps.HasCustomFieldValues;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.markers.IsHidden;
import net.serenitybdd.markers.IsSilent;
import net.serenitybdd.model.IgnoredStepException;
import net.serenitybdd.model.PendingStepException;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.thucydides.core.steps.CleanupMethodLocator;
import net.thucydides.core.steps.DefaultValue;
import net.thucydides.core.steps.DryRunMethodRunner;
import net.thucydides.core.steps.ErrorConvertor;
import net.thucydides.core.steps.Interceptor;
import net.thucydides.core.steps.MethodErrorReporter;
import net.thucydides.core.steps.MethodRunner;
import net.thucydides.core.steps.NormalMethodRunner;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepName;
import net.thucydides.core.steps.StepNamer;
import net.thucydides.core.steps.events.AssumptionViolatedEvent;
import net.thucydides.core.steps.events.ReenableWebdriverCallsEvent;
import net.thucydides.core.steps.events.StepFailedEvent;
import net.thucydides.core.steps.events.StepFinishedEvent;
import net.thucydides.core.steps.events.StepIgnoredEvent;
import net.thucydides.core.steps.events.StepPendingEvent;
import net.thucydides.core.steps.events.StepStartedEvent;
import net.thucydides.core.steps.events.SuspendWebdriverCallsEvent;
import net.thucydides.core.steps.events.WrapupCurrentCucumberStepEvent;
import net.thucydides.core.steps.interception.DynamicExampleStepInterceptionListener;
import net.thucydides.core.steps.interception.StepInterceptionListener;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.adapters.TestFramework;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.stacktrace.StackTraceSanitizer;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.steps.AnnotatedStepDescription;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.ScreenplayInspector;
import net.thucydides.model.steps.StepFailure;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptor
implements MethodErrorReporter,
Interceptor {
    private final Class<?> testStepClass;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private final EnvironmentVariables environmentVariables;
    private static final ThreadLocal<Class> expectedExceptionType = new ThreadLocal();
    private final List<StepInterceptionListener> listeners = new ArrayList<StepInterceptionListener>();
    CleanupMethodLocator cleanupMethodLocator;
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize", "getMetaClass");

    public static void setExpectedExceptionType(Class expectedException) {
        expectedExceptionType.set(expectedException);
    }

    public static void resetExpectedExceptionType() {
        expectedExceptionType.remove();
    }

    StepInterceptor(Class<?> testStepClass) {
        this.testStepClass = testStepClass;
        this.environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
        this.cleanupMethodLocator = new CleanupMethodLocator();
        this.listeners.add(new DynamicExampleStepInterceptionListener());
    }

    @Override
    @RuntimeType
    public Object intercept(@Origin Method method, @This Object target, @AllArguments Object[] args, @SuperMethod Method zuper) throws Throwable {
        Object result = this.baseClassMethod(method, target) || this.isAStepThatMayThrowAnException(method) ? this.runBaseObjectMethod(target, method, args, zuper) : this.testStepResult(target, method, args, zuper);
        return result;
    }

    private boolean baseClassMethod(Method method, Object obj) {
        Class<?> callingClass = obj.getClass();
        boolean isACoreLanguageMethod = this.OBJECT_METHODS.contains(method.getName());
        boolean methodDoesNotComeFromThisClassOrARelatedParentClass = !this.declaredInSameDomain(method, callingClass);
        boolean isSilentMethod = this.isSilent(callingClass, method, obj);
        boolean isHiddenMethod = this.isHidden(callingClass);
        return isACoreLanguageMethod || methodDoesNotComeFromThisClassOrARelatedParentClass || isSilentMethod || isHiddenMethod;
    }

    private boolean isSilent(Class callingClass, Method method, Object obj) {
        if (IsSilent.class.isAssignableFrom(callingClass)) {
            return true;
        }
        if (CanBeSilent.class.isAssignableFrom(callingClass) && method.getName().equals("isSilent")) {
            return true;
        }
        if (CanBeSilent.class.isAssignableFrom(callingClass) && ((CanBeSilent)obj).isSilent()) {
            return true;
        }
        if (this.isNestedInSilentTask()) {
            return true;
        }
        return this.isNotAStepAnnotatedMethodWhenManualInstrumentationIsActive(method);
    }

    private boolean isHidden(Class<?> callingClass) {
        return IsHidden.class.isAssignableFrom(callingClass);
    }

    private boolean isNotAStepAnnotatedMethodWhenManualInstrumentationIsActive(Method method) {
        if (this.manualTaskInstrumentation()) {
            return method.getAnnotation(Step.class) == null;
        }
        return false;
    }

    private boolean manualTaskInstrumentation() {
        return ThucydidesSystemProperty.MANUAL_TASK_INSTRUMENTATION.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }

    private boolean isNestedInSilentTask() {
        return Arrays.asList(new Exception().getStackTrace()).stream().anyMatch(element -> element.getMethodName().equals("performSilently"));
    }

    private boolean declaredInSameDomain(Method method, Class callingClass) {
        return this.domainPackageOf(this.getRoot(method)).equals(this.domainPackageOf(callingClass));
    }

    private String domainPackageOf(Class callingClass) {
        Package classPackage = callingClass.getPackage();
        String classPackageName = classPackage != null ? classPackage.getName() : "";
        return this.packageDomainName(classPackageName);
    }

    private String packageDomainName(String methodPackage) {
        List packages = Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)methodPackage);
        if (packages.size() == 0) {
            return "";
        }
        if (packages.size() == 1) {
            return (String)packages.get(0);
        }
        return (String)packages.get(0) + "." + (String)packages.get(1);
    }

    private String domainPackageOf(Method method) {
        Package methodPackage = method.getDeclaringClass().getPackage();
        String methodPackageName = methodPackage != null ? methodPackage.getName() : "";
        return this.packageDomainName(methodPackageName);
    }

    private Method getRoot(Method method) {
        try {
            method.getClass().getDeclaredField("root").setAccessible(true);
            return (Method)method.getClass().getDeclaredField("root").get(method);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return method;
        }
    }

    private Object testStepResult(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.runNormalMethod(obj, method, args, zuperMethod);
        }
        this.listeners.forEach(listener -> listener.start(obj, method, args, zuperMethod));
        Object result = this.runOrSkipMethod(obj, method, args, zuperMethod);
        this.listeners.forEach(listener -> listener.end(obj, method, args, zuperMethod));
        return result;
    }

    private Object runOrSkipMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        Object result;
        if (this.shouldSkip(method) && !this.stepIsCalledFromCleanupMethod()) {
            result = this.skipStepMethod(obj, method, args, zuperMethod);
        } else {
            this.notifyStepStarted(obj, method, args);
            result = this.runTestStep(obj, method, args, zuperMethod);
        }
        return result;
    }

    private void endDynamicExampleIfPresent() {
    }

    private void startDynamicExampleIfPresent() {
    }

    private boolean stepIsCalledFromCleanupMethod() {
        return this.cleanupMethodLocator.currentMethodWasCalledFromACleanupMethod();
    }

    private Object skipStepMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Exception {
        if ((this.aPreviousStepHasFailed() || this.testAssumptionViolated()) && !this.shouldExecuteNestedStepsAfterFailures()) {
            this.notifySkippedStepStarted(obj, method, args);
            this.notifySkippedStepFinishedFor(method, args);
            return this.appropriateReturnObject(obj, method);
        }
        this.notifySkippedStepStarted(obj, method, args);
        return this.skipTestStep(obj, method, args, zuperMethod);
    }

    private boolean shouldExecuteNestedStepsAfterFailures() {
        return ThucydidesSystemProperty.DEEP_STEP_EXECUTION_AFTER_FAILURES.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }

    private Object skipTestStep(Object obj, Method method, Object[] args, Method zuperMethod) throws Exception {
        Object skippedReturnObject = this.runSkippedMethod(obj, method, args, zuperMethod);
        this.notifyStepSkippedFor(method, args);
        LOGGER.debug("SKIPPED STEP: {}", (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        return this.appropriateReturnObject(skippedReturnObject, obj, method);
    }

    private Object runSkippedMethod(Object obj, Method method, Object[] args, Method zuperMethod) {
        LOGGER.trace("Running test step " + StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        if (TestSession.isSessionStarted()) {
            SuspendWebdriverCallsEvent suspendWebdriverCallsEvent = new SuspendWebdriverCallsEvent();
            TestSession.addEvent(suspendWebdriverCallsEvent);
        } else {
            StepEventBus.getParallelEventBus().temporarilySuspendWebdriverCalls();
        }
        Object result = this.runIfNestedMethodsShouldBeRun(obj, method, args, zuperMethod);
        if (TestSession.isSessionStarted()) {
            ReenableWebdriverCallsEvent reenableWebdriverCallsEvent = new ReenableWebdriverCallsEvent();
            TestSession.addEvent(reenableWebdriverCallsEvent);
        } else {
            StepEventBus.getParallelEventBus().reenableWebdriverCalls();
        }
        return result;
    }

    private Object runIfNestedMethodsShouldBeRun(Object obj, Method method, Object[] args, Method zuperMethod) {
        Object result = null;
        try {
            if (this.shouldRunNestedMethodsIn(method)) {
                result = this.invokeMethod(obj, args, zuperMethod);
            }
        }
        catch (Throwable anyException) {
            LOGGER.trace("Ignoring exception thrown during a skipped test", anyException);
        }
        return result;
    }

    private boolean shouldRunNestedMethodsIn(Method method) {
        return !TestAnnotations.shouldSkipNested((Method)method) && !this.shouldSkipNestedIn(method.getDeclaringClass());
    }

    private boolean shouldSkipNestedIn(Class testStepClass) {
        return SkipNested.class.isAssignableFrom(testStepClass);
    }

    private Object appropriateReturnObject(Object returnedValue, Object obj, Method method) {
        if (returnedValue != null) {
            return returnedValue;
        }
        return this.appropriateReturnObject(obj, method);
    }

    private PrimitiveReturnType returnTypeOf(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == String.class) {
            return PrimitiveReturnType.STRING;
        }
        if (Long.class.isAssignableFrom(returnType) || returnType.getName().equals("long")) {
            return PrimitiveReturnType.LONG;
        }
        if (Integer.class.isAssignableFrom(returnType) || returnType.getName().equals("int")) {
            return PrimitiveReturnType.INTEGER;
        }
        if (Double.class.isAssignableFrom(returnType) || returnType.getName().equals("double")) {
            return PrimitiveReturnType.DOUBLE;
        }
        if (Float.class.isAssignableFrom(returnType) || returnType.getName().equals("float")) {
            return PrimitiveReturnType.FLOAT;
        }
        if (Boolean.class.isAssignableFrom(returnType) || returnType.getName().equals("boolean")) {
            return PrimitiveReturnType.BOOLEAN;
        }
        if (returnType.getName().equals("void")) {
            return PrimitiveReturnType.VOID;
        }
        return PrimitiveReturnType.UNSUPPORTED;
    }

    Object appropriateReturnObject(Object obj, Method method) {
        if (method.getReturnType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (this.returnTypeIsPrimativeFor(method)) {
            return this.primativeDefaultValueFor(method);
        }
        return this.mockedReturnObjectFor(method);
    }

    private Object mockedReturnObjectFor(Method method) {
        try {
            return Mockito.mock(method.getReturnType());
        }
        catch (RuntimeException tooHardToMockLetsJustCallItQuits) {
            return null;
        }
    }

    private boolean returnTypeIsPrimativeFor(Method method) {
        return this.returnTypeOf(method) != PrimitiveReturnType.UNSUPPORTED;
    }

    private Object primativeDefaultValueFor(Method method) {
        switch (this.returnTypeOf(method).ordinal()) {
            case 6: {
                return null;
            }
            case 0: {
                return "";
            }
            case 1: {
                return 0L;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return Float.valueOf(0.0f);
            }
            case 3: {
                return 0.0;
            }
            case 5: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private boolean shouldSkip(Method methodOrStep) {
        if (this.aPreviousStepHasFailed() && !this.isSoftAssert()) {
            return true;
        }
        return this.testIsPending() || this.isDryRun() || this.isPending(methodOrStep) || this.isIgnored(methodOrStep);
    }

    private boolean testIsPending() {
        return this.getStepEventBus().currentTestIsSuspended();
    }

    private boolean testAssumptionViolated() {
        return this.getStepEventBus().assumptionViolated();
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = this.getStepEventBus().aStepInTheCurrentTestHasFailed();
        return aPreviousStepHasFailed;
    }

    private boolean isDryRun() {
        return this.getStepEventBus().isDryRun();
    }

    private boolean isSoftAssert() {
        return this.getStepEventBus().softAssertsActive();
    }

    private Object runBaseObjectMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        return this.invokeMethod(obj, args, zuperMethod);
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        Object result = DefaultValue.defaultReturnValueFor(method, obj);
        return this.withNonStepMethodRunner(method, obj.getClass()).invokeMethodAndNotifyFailures(obj, method, args, zuperMethod, result);
    }

    private MethodRunner withNonStepMethodRunner(Method methodOrStep, Class callingClass) {
        return this.shouldRunInDryRunMode(methodOrStep, callingClass) ? new DryRunMethodRunner() : new NormalMethodRunner(this);
    }

    private boolean shouldRunInDryRunMode(Method methodOrStep, Class callingClass) {
        return !this.stepIsCalledFromCleanupMethod() && (this.aPreviousStepHasFailed() || this.testIsPending() || this.isDryRun());
    }

    @Override
    public void reportMethodError(Throwable generalException, Object obj, Method method, Object[] args) throws Throwable {
        this.error = SerenityManagedException.detachedCopyOf((Throwable)generalException);
        Throwable assertionError = ErrorConvertor.convertToAssertion(this.error);
        this.notifyStepStarted(obj, method, args);
        this.notifyOfStepFailure(obj, method, args, assertionError);
    }

    private boolean isAnnotatedWithAValidStepAnnotation(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!this.isAThucydidesStep(annotation) && !AnnotatedStepDescription.isACompatibleStep((Annotation)annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isAStepThatMayThrowAnException(Method method) {
        return expectedExceptionType.get() != null;
    }

    private boolean isAThucydidesStep(Annotation annotation) {
        return annotation instanceof Step || annotation instanceof StepGroup;
    }

    private boolean isATestStep(Method method) {
        return this.isAnnotatedWithAValidStepAnnotation(method) || ScreenplayInspector.isAScreenplayPerformAsMethod((Method)method);
    }

    private boolean isIgnored(Method method) {
        return TestAnnotations.isIgnored((Method)method);
    }

    private Object runTestStep(Object obj, Method method, Object[] args, Method zuperMethod) throws Throwable {
        String callingClass = this.testContext();
        LOGGER.debug("STARTING STEP: {} - {}", (Object)callingClass, (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        Object result = null;
        try {
            result = this.executeTestStepMethod(obj, method, args, zuperMethod, result);
            LOGGER.debug("STEP DONE: {}", (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()));
        }
        catch (AssertionError failedAssertion) {
            this.error = failedAssertion;
            this.logStepFailure(obj, method, args, (Throwable)((Object)failedAssertion));
            result = this.appropriateReturnObject(obj, method);
        }
        catch (Throwable testErrorException) {
            if (TestFramework.support().isAssumptionViolatedException(testErrorException)) {
                result = this.appropriateReturnObject(obj, method);
            }
            this.error = SerenityManagedException.detachedCopyOf((Throwable)testErrorException);
            this.logStepFailure(obj, method, args, ErrorConvertor.convertToAssertion(this.error));
            result = this.appropriateReturnObject(obj, method);
        }
        return result;
    }

    private void logStepFailure(Object object, Method method, Object[] args, Throwable assertionError) throws Throwable {
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            return;
        }
        this.notifyOfStepFailure(object, method, args, assertionError);
        LOGGER.debug("STEP FAILED: {} - {}", (Object)StepName.fromStepAnnotationIn(method).orElse(method.getName()), (Object)assertionError.getMessage());
    }

    private Object executeTestStepMethod(Object obj, Method method, Object[] args, Method zuperMethod, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, zuperMethod);
            this.notifyStepFinishedFor(method, args);
        }
        catch (PendingStepException pendingStep) {
            this.notifyStepPending(pendingStep.getMessage());
        }
        catch (IgnoredStepException ignoredStep) {
            this.notifyStepIgnored();
        }
        catch (Throwable throwable) {
            if (TestFramework.support().isAssumptionViolatedException(throwable)) {
                this.notifyAssumptionViolated(throwable.getMessage());
            }
            throw throwable;
        }
        Preconditions.checkArgument((boolean)true);
        return result;
    }

    private Object invokeMethod(Object obj, Object[] args, Method zuperMethod) throws Throwable {
        try {
            return zuperMethod.invoke(obj, args);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private boolean isPending(Method method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private void notifyStepFinishedFor(Method method, Object[] args) {
        if (TestSession.isSessionStarted()) {
            StepFinishedEvent stepFinishedEvent = new StepFinishedEvent();
            LOGGER.debug("SRP:Actor finished step in session " + String.valueOf(stepFinishedEvent) + " " + String.valueOf(Thread.currentThread()));
            TestSession.addEvent(stepFinishedEvent);
        } else {
            StepEventBus.getParallelEventBus().stepFinished();
        }
    }

    private void notifySkippedStepFinishedFor(Method method, Object[] args) {
        if (TestSession.isSessionStarted()) {
            StepIgnoredEvent stepIgnoredEvent = new StepIgnoredEvent();
            TestSession.addEvent(stepIgnoredEvent);
        } else {
            StepEventBus.getParallelEventBus().stepIgnored();
        }
    }

    private void notifyStepPending(String message) {
        if (TestSession.isSessionStarted()) {
            TestSession.addEvent(new StepPendingEvent(message));
        } else {
            StepEventBus.getParallelEventBus().stepPending(message);
        }
    }

    private void notifyAssumptionViolated(String message) {
        if (TestSession.isSessionStarted()) {
            TestSession.addEvent(new AssumptionViolatedEvent(message));
        } else {
            StepEventBus.getParallelEventBus().assumptionViolated(message);
        }
    }

    private void notifyStepIgnored() {
        if (TestSession.isSessionStarted()) {
            TestSession.addEvent(new StepIgnoredEvent());
        } else {
            StepEventBus.getParallelEventBus().stepIgnored();
        }
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return StepNamer.nameFor(method, args);
    }

    private void notifyStepSkippedFor(Method method, Object[] args) {
        if (TestSession.isSessionStarted()) {
            if (this.isPending(method)) {
                TestSession.addEvent(new StepPendingEvent());
            } else {
                TestSession.addEvent(new StepIgnoredEvent());
            }
        } else if (this.isPending(method)) {
            StepEventBus.getParallelEventBus().stepPending();
        } else {
            StepEventBus.getParallelEventBus().stepIgnored();
        }
    }

    private void notifyOfStepFailure(Object object, Method method, Object[] args, Throwable cause) throws Throwable {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, (String)this.getTestNameFrom(method, args), (Object[])args).withDisplayedFields(this.fieldValuesIn(object));
        StepFailure failure = new StepFailure(description, cause);
        if (TestSession.isSessionStarted()) {
            List<ScreenshotAndHtmlSource> screenshotList = TestSession.getTestSessionContext().getStepEventBus().takeScreenshots(TestResult.FAILURE);
            StepFailedEvent stepFailedEvent = new StepFailedEvent(failure, screenshotList);
            TestSession.addEvent(stepFailedEvent);
        } else {
            StepEventBus.getParallelEventBus().stepFailed(failure);
        }
        if (this.shouldThrowExceptionImmediately()) {
            this.finishAnyCucumberSteps();
            throw cause;
        }
    }

    private void finishAnyCucumberSteps() {
        if (TestSession.isSessionStarted()) {
            WrapupCurrentCucumberStepEvent wrapupCurrentCucumberStepEvent = new WrapupCurrentCucumberStepEvent();
            LOGGER.debug("SRP:Actor started event in session " + String.valueOf(wrapupCurrentCucumberStepEvent) + " " + String.valueOf(Thread.currentThread()));
            TestSession.addEvent(wrapupCurrentCucumberStepEvent);
        } else {
            StepEventBus.getParallelEventBus().wrapUpCurrentCucumberStep();
        }
    }

    private boolean shouldThrowExceptionImmediately() {
        return Serenity.shouldThrowErrorsImmediately();
    }

    private void notifyStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, (String)this.getTestNameFrom(method, args), (Object[])args).withDisplayedFields(this.fieldValuesIn(object));
        if (TestSession.isSessionStarted()) {
            StepStartedEvent stepStartedEvent = new StepStartedEvent(description);
            LOGGER.debug("SRP:Actor started step in session " + String.valueOf(stepStartedEvent) + " " + String.valueOf(Thread.currentThread()));
            TestSession.addEvent(stepStartedEvent);
        } else {
            StepEventBus.getParallelEventBus().stepStarted(description);
        }
    }

    private Map<String, Object> fieldValuesIn(Object object) {
        Map coreFieldValues = Fields.of((Object)object).asMap();
        if (object instanceof HasCustomFieldValues) {
            coreFieldValues.putAll(((HasCustomFieldValues)object).getCustomFieldValues());
        }
        return coreFieldValues;
    }

    private void notifySkippedStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, (String)this.getTestNameFrom(method, args), (Object[])args).withDisplayedFields(this.fieldValuesIn(object));
        this.getStepEventBus().skippedStepStarted(description);
    }

    String testContext() {
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace((StackTraceElement[])new RuntimeException().getStackTrace());
        StackTraceElement[] stackTrace = stackTraceSanitizer.getSanitizedStackTrace();
        return stackTrace.length > 0 ? this.getTestContextFrom(stackTraceSanitizer.getSanitizedStackTrace()[0]) : "";
    }

    private String getTestContextFrom(StackTraceElement stackTraceElement) {
        return this.shortenedClassName(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
    }

    private String shortenedClassName(String className) {
        String[] classNameElements = StringUtils.split((String)className, (String)".");
        return classNameElements[classNameElements.length - 1];
    }

    private StepEventBus getStepEventBus() {
        if (TestSession.isSessionStarted()) {
            return TestSession.getTestSessionContext().getStepEventBus();
        }
        return StepEventBus.getParallelEventBus();
    }

    static enum PrimitiveReturnType {
        STRING,
        LONG,
        INTEGER,
        DOUBLE,
        FLOAT,
        BOOLEAN,
        VOID,
        UNSUPPORTED;

    }
}

