/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.events;

import java.time.ZonedDateTime;
import net.thucydides.core.steps.events.StepEventBusEventBase;
import net.thucydides.core.steps.session.TestSession;

public class TestStartedEvent
extends StepEventBusEventBase {
    private String testName;
    private String id;
    private ZonedDateTime startTime;

    public TestStartedEvent(String testName) {
        this.testName = testName;
        this.startTime = ZonedDateTime.now();
        TestSession.getTestSessionContext().setCurrentTestName(testName);
    }

    public TestStartedEvent(String scenarioId, String testName, String id) {
        super(scenarioId);
        this.testName = testName;
        this.id = id;
        this.startTime = ZonedDateTime.now();
        TestSession.getTestSessionContext().setCurrentTestName(testName);
    }

    @Override
    public void play() {
        TestSession.getTestSessionContext().setCurrentTestName(this.testName);
        if (this.getScenarioId() != null) {
            this.getStepEventBus().testStarted(this.testName, this.id, this.startTime);
        } else {
            this.getStepEventBus().testStarted(this.testName);
        }
    }

    public String toString() {
        return "EventBusEvent TEST_STARTED_EVENT with name " + this.testName + " " + this.id;
    }
}

