/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import net.serenitybdd.annotations.TestAnnotations;
import net.serenitybdd.core.annotations.events.AfterExample;
import net.serenitybdd.core.annotations.events.AfterScenario;
import net.serenitybdd.core.annotations.events.BeforeExample;
import net.serenitybdd.core.annotations.events.BeforeScenario;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.lifecycle.LifecycleRegister;
import net.serenitybdd.core.photography.Darkroom;
import net.serenitybdd.core.photography.Photographer;
import net.serenitybdd.core.photography.SoundEngineer;
import net.serenitybdd.core.photography.WebDriverPhotoLens;
import net.serenitybdd.core.photography.bluring.AnnotatedBluring;
import net.serenitybdd.core.webdriver.OverrideDriverCapabilities;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.serenitybdd.core.webdriver.enhancers.AtTheEndOfAWebDriverTest;
import net.serenitybdd.model.PendingStepException;
import net.serenitybdd.model.exceptions.TheErrorType;
import net.serenitybdd.model.rest.RestQuery;
import net.serenitybdd.model.strings.Joiner;
import net.serenitybdd.model.time.SystemClock;
import net.thucydides.core.junit.SerenityJUnitTestCase;
import net.thucydides.core.model.screenshots.ScreenshotPermission;
import net.thucydides.core.steps.CurrentTestResult;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.SerenityWebdriverManager;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.Stories;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TakeScreenshots;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestStep;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.domain.failures.FailureAnalysis;
import net.thucydides.model.domain.stacktrace.FailureCause;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.screenshots.ScreenshotException;
import net.thucydides.model.steps.AnnotatedStepDescription;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;
import net.thucydides.model.steps.StepFailureException;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.steps.TestFailureCause;
import net.thucydides.model.util.ConfigCache;
import net.thucydides.model.webdriver.Configuration;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseStepListener
implements StepListener,
StepPublisher {
    private final List<TestOutcome> testOutcomes;
    private TestOutcome currentTestOutcome;
    private final Stack<TestStep> currentStepStack = new Stack();
    private final Stack<TestStep> currentGroupStack;
    private StepEventBus eventBus;
    private final SystemClock clock;
    private ScreenshotPermission screenshots;
    private Class<?> testSuite;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStepListener.class);
    private WebDriver driver;
    private final File outputDirectory;
    private final WebdriverProxyFactory proxyFactory;
    private Story testedStory;
    private Configuration configuration;
    private List<String> storywideIssues;
    private List<TestTag> storywideTags;
    private Darkroom darkroom;
    private Photographer photographer;
    private SoundEngineer soundEngineer;
    private final CloseBrowser closeBrowsers;
    private static final TestOutcome UNAVAILABLE_TEST_OUTCOME = new TestOutcome("Test outcome unavailable", null);
    private boolean suiteStarted = false;
    Stack<Method> currentStepMethodStack = new Stack();
    FailureAnalysis failureAnalysis = new FailureAnalysis();
    private int currentExample = 0;
    private int lastFailingExample = 0;

    public void setEventBus(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public StepEventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = StepEventBus.getParallelEventBus();
        }
        return this.eventBus;
    }

    private Darkroom getDarkroom() {
        if (this.darkroom == null) {
            this.darkroom = new Darkroom();
        }
        return this.darkroom;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Optional<TestStep> cloneCurrentStep() {
        return this.currentStepExists() ? Optional.of(this.getCurrentStep().clone()) : Optional.empty();
    }

    public Optional<TestResult> getAnnotatedResult() {
        return Optional.ofNullable(this.getCurrentTestOutcome().getAnnotatedResult());
    }

    public void setAllStepsTo(TestResult result) {
        this.getCurrentTestOutcome().setAnnotatedResult(result);
        this.getCurrentTestOutcome().setAllStepsTo(result);
    }

    public void overrideResultTo(TestResult result) {
        this.getCurrentTestOutcome().overrideResult(result);
    }

    public void recordManualTestResult(TestResult result, Optional<String> lastTestedVersion, Boolean isUpToDate, Optional<String> testEvidence) {
        this.getCurrentTestOutcome().overrideAnnotatedResult(result);
        lastTestedVersion.ifPresent(version -> {
            this.getCurrentTestOutcome().setLastTested(version);
            this.getCurrentTestOutcome().setManualTestingUpToDate(isUpToDate);
            testEvidence.ifPresent(evidence -> this.getCurrentTestOutcome().setManualTestEvidence(this.testEvidenceLinksFrom(testEvidence)));
        });
    }

    public void recordManualTestResult(TestResult result) {
        this.getCurrentTestOutcome().overrideAnnotatedResult(result);
    }

    private List<String> testEvidenceLinksFrom(Optional<String> testEvidence) {
        List<String> testEvidenceLinks = new ArrayList<String>();
        if (testEvidence.isPresent()) {
            testEvidenceLinks = Arrays.stream(testEvidence.get().split(",")).map(String::trim).collect(Collectors.toList());
        }
        return testEvidenceLinks;
    }

    public void exceptionExpected(Class<? extends Throwable> expected) {
        if (this.isNotAnException(expected.getName())) {
            return;
        }
        if (this.currentTestFailed() && TheErrorType.causedBy((String)this.getCurrentTestOutcome().getTestFailureErrorType()).isAKindOf(expected)) {
            this.getCurrentTestOutcome().resetFailingStepsCausedBy(expected);
            this.getCurrentTestOutcome().recordStep(TestStep.forStepCalled((String)("Expected exception thrown : " + expected.getName())).withResult(TestResult.SUCCESS));
        }
    }

    private boolean isNotAnException(String name) {
        return name.toLowerCase().endsWith("$none");
    }

    public boolean currentTestFailed() {
        return this.getCurrentTestOutcome().getTestFailureCause() != null;
    }

    public StepMerger mergeLast(int maxStepsToMerge) {
        return new StepMerger(maxStepsToMerge);
    }

    public int getStepCount() {
        return this.getCurrentTestOutcome().getStepCount();
    }

    public int getRunningStepCount() {
        return this.getCurrentTestOutcome().getRunningStepCount();
    }

    public void updateOverallResults() {
        this.getCurrentTestOutcome().updateOverallResults();
    }

    public Photographer getPhotographer() {
        if (this.photographer == null) {
            this.photographer = new Photographer(this.getDarkroom());
        }
        return this.photographer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPreviousTest() {
        List<TestOutcome> list = this.testOutcomes;
        synchronized (list) {
            if (!this.testOutcomes.isEmpty()) {
                this.testOutcomes.remove(this.testOutcomes.size() - 1);
            }
        }
    }

    public void lastTestPassedAfterRetries(int attemptNum, List<String> failureMessages, TestFailureCause testfailureCause) {
        if (this.latestTestOutcome().isPresent()) {
            this.latestTestOutcome().get().recordStep(TestStep.forStepCalled((String)("UNSTABLE TEST:\n" + this.failureHistoryFor(failureMessages))).withResult(TestResult.UNDEFINED));
            this.latestTestOutcome().get().addTag(TestTag.withName((String)("Retries: " + attemptNum)).andType("unstable test"));
            this.latestTestOutcome().get().setFlakyTestFailureCause(testfailureCause);
        }
    }

    private String failureHistoryFor(List<String> failureMessages) {
        List bulletPoints = failureMessages.stream().map(from -> "* " + from).collect(Collectors.toList());
        return Joiner.on((String)"\n").join(bulletPoints);
    }

    public void currentStepIsAPrecondition() {
        this.getCurrentStep().setPrecondition(true);
    }

    public void updateExampleLineNumber(int lineNumber) {
        this.currentStep().ifPresent(step -> step.setLineNumber(lineNumber));
    }

    public void addStepsFrom(List<TestStep> newSteps) {
        this.latestTestOutcome().ifPresent(outcome -> outcome.recordSteps(newSteps));
    }

    public void addChildStepsFrom(List<TestStep> newSteps) {
        this.latestTestOutcome().ifPresent(outcome -> outcome.recordChildSteps(newSteps));
    }

    public int currentStepDepth() {
        return this.currentStepStack.size();
    }

    public boolean previousScenarioWasASingleBrowserScenario() {
        if (this.getTestOutcomes().size() > 1) {
            TestOutcome previousOutcome = this.getTestOutcomes().get(this.getTestOutcomes().size() - 2);
            return previousOutcome.hasTag(TestTag.withValue((String)"singlebrowser"));
        }
        return false;
    }

    public boolean currentStoryHasTag(TestTag tag) {
        return this.storywideTags != null && this.storywideTags.contains(tag);
    }

    public BaseStepListener childListenerFor(StepEventBus eventBus) {
        BaseStepListener baseStepListener = new BaseStepListener(this.outputDirectory);
        baseStepListener.photographer = this.photographer;
        baseStepListener.screenshots = this.screenshots;
        baseStepListener.darkroom = this.darkroom;
        baseStepListener.eventBus = eventBus;
        baseStepListener.soundEngineer = this.soundEngineer;
        baseStepListener.storywideIssues = this.storywideIssues;
        baseStepListener.storywideTags = this.storywideTags;
        baseStepListener.suiteStarted = this.suiteStarted;
        baseStepListener.testedStory = this.testedStory;
        baseStepListener.testSuite = this.testSuite;
        return baseStepListener;
    }

    public BaseStepListener spawn(String outcomeName) {
        BaseStepListener baseStepListener = new BaseStepListener(this.outputDirectory);
        baseStepListener.photographer = this.photographer;
        baseStepListener.screenshots = this.screenshots;
        baseStepListener.darkroom = this.darkroom;
        baseStepListener.eventBus = this.eventBus;
        baseStepListener.soundEngineer = this.soundEngineer;
        baseStepListener.storywideIssues = this.storywideIssues;
        baseStepListener.storywideTags = this.storywideTags;
        baseStepListener.suiteStarted = this.suiteStarted;
        baseStepListener.testedStory = this.testedStory;
        baseStepListener.testSuite = this.testSuite;
        baseStepListener.testStarted(outcomeName);
        return baseStepListener;
    }

    public BaseStepListener(File outputDirectory) {
        this.proxyFactory = WebdriverProxyFactory.getFactory();
        this.testOutcomes = new ArrayList<TestOutcome>();
        this.currentGroupStack = new Stack();
        this.outputDirectory = outputDirectory;
        this.storywideIssues = new ArrayList<String>();
        this.storywideTags = new ArrayList<TestTag>();
        this.clock = SerenityInfrastructure.getClock();
        this.configuration = SerenityInfrastructure.getConfiguration();
        this.closeBrowsers = SerenityInfrastructure.getCloseBrowser();
        this.soundEngineer = new SoundEngineer(this.configuration.getEnvironmentVariables());
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory, Configuration configuration) {
        this(driverClass, outputDirectory);
        this.configuration = configuration;
    }

    protected ScreenshotPermission screenshots() {
        if (this.screenshots == null) {
            this.screenshots = new ScreenshotPermission(this.configuration);
        }
        return this.screenshots;
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public TestOutcome getCurrentTestOutcome() {
        return this.latestTestOutcome().orElse(UNAVAILABLE_TEST_OUTCOME);
    }

    private TestOutcome unavailableTestOutcome() {
        return UNAVAILABLE_TEST_OUTCOME;
    }

    public boolean isAvailable() {
        return true;
    }

    public Optional<TestOutcome> latestTestOutcome() {
        if (this.testOutcomes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.currentTestOutcome);
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    public void testSuiteStarted(Class<?> startedTestSuite) {
        this.testSuite = startedTestSuite;
        this.testedStory = Stories.findStoryFrom(startedTestSuite);
        this.suiteStarted = true;
        this.clearStorywideTagsAndIssues();
    }

    public void testSuiteStarted(Class<?> startedTestSuite, String testName) {
        this.testSuite = startedTestSuite;
        this.testedStory = Stories.findStoryFrom(startedTestSuite).withStoryName(testName).withDisplayName(testName);
        this.suiteStarted = true;
        this.clearStorywideTagsAndIssues();
    }

    private void clearStorywideTagsAndIssues() {
        this.storywideIssues.clear();
        this.storywideTags.clear();
    }

    public void testSuiteStarted(Story story) {
        this.testSuite = null;
        this.testedStory = story;
        this.suiteStarted = true;
        this.clearStorywideTagsAndIssues();
    }

    public boolean testSuiteRunning() {
        return this.suiteStarted;
    }

    public void addIssuesToCurrentStory(List<String> issues) {
        this.storywideIssues.addAll(issues);
    }

    public void addTagsToCurrentStory(List<TestTag> tags) {
        this.storywideTags.addAll(tags);
    }

    private void closeDarkroom() {
        if (this.darkroom != null) {
            this.darkroom.waitUntilClose();
        }
    }

    public void testSuiteFinished() {
        this.closeDarkroom();
        this.clearStorywideTagsAndIssues();
        ThucydidesWebDriverSupport.clearStepLibraries();
        ThucydidesWebDriverSupport.clearDefaultDriver();
        if (this.currentTestIsABrowserTest()) {
            this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.FEATURE);
        }
        this.suiteStarted = false;
    }

    public void testStarted(String testMethod) {
        this.testStarted(testMethod, ZonedDateTime.now());
    }

    public void testStarted(String testMethod, ZonedDateTime startTime) {
        String testMethodName = testMethod;
        String qualifier = "";
        if (testMethod.contains("%")) {
            String[] splittedTestMethod = testMethod.split("%");
            testMethodName = splittedTestMethod[0];
            qualifier = splittedTestMethod[1];
        }
        TestOutcome newTestOutcome = TestOutcome.forTestInStory((String)testMethodName, this.testSuite, (Story)this.testedStory);
        if (!qualifier.isEmpty()) {
            newTestOutcome = newTestOutcome.withQualifier(qualifier);
        }
        this.currentTestOutcome = newTestOutcome;
        this.recordNewTestOutcome(testMethod, this.currentTestOutcome);
        this.currentTestOutcome.setStartTime(startTime);
        LifecycleRegister.invokeMethodsAnnotatedBy(BeforeScenario.class, newTestOutcome);
    }

    public void testStarted(String testName, String id) {
        TestOutcome newTestOutcome;
        this.currentTestOutcome = newTestOutcome = TestOutcome.forTestInStory((String)testName, this.testSuite, (Story)this.testedStory).withId(id);
        this.recordNewTestOutcome(testName, this.currentTestOutcome);
        LifecycleRegister.invokeMethodsAnnotatedBy(BeforeScenario.class, newTestOutcome);
    }

    public void testStarted(String testName, String methodName, String id, String scenarioId) {
        TestOutcome newTestOutcome;
        this.currentTestOutcome = newTestOutcome = TestOutcome.forTestInStory((String)testName, this.testSuite, (Story)this.testedStory).withId(id).withScenarioId(scenarioId).withTestMethodName(methodName);
        this.recordNewTestOutcome(testName, this.currentTestOutcome);
        LifecycleRegister.invokeMethodsAnnotatedBy(BeforeScenario.class, newTestOutcome);
    }

    public void testStarted(String testMethod, String id, ZonedDateTime startTime) {
        TestOutcome newTestOutcome;
        this.currentTestOutcome = newTestOutcome = TestOutcome.forTestInStory((String)testMethod, this.testSuite, (Story)this.testedStory).withId(id).withStartTime(startTime);
        this.recordNewTestOutcome(testMethod, this.currentTestOutcome);
        LifecycleRegister.invokeMethodsAnnotatedBy(BeforeScenario.class, newTestOutcome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordNewTestOutcome(String testMethod, TestOutcome newTestOutcome) {
        newTestOutcome.setTestSource(this.getEventBus().getTestSource());
        List<TestOutcome> list = this.testOutcomes;
        synchronized (list) {
            this.testOutcomes.add(newTestOutcome);
        }
        this.setAnnotatedResult(testMethod);
    }

    private void updateSessionIdIfKnown() {
        this.updateSessionIdIfKnown(this.getCurrentTestOutcome());
    }

    private void updateSessionIdIfKnown(TestOutcome testOutcome) {
        SessionId sessionId = ThucydidesWebDriverSupport.getSessionId();
        if (sessionId != null) {
            this.getCurrentTestOutcome().setSessionId(sessionId.toString());
        }
    }

    public StepMutator updateCurrentStepTitle(String updatedStepTitle) {
        if (this.currentStepExists()) {
            this.getCurrentStep().setDescription(updatedStepTitle);
        } else {
            this.stepStarted(ExecutedStepDescription.withTitle((String)updatedStepTitle));
        }
        return new StepMutator(this);
    }

    public void updateCurrentStepFailureCause(Throwable failure) {
        this.currentTestOutcome.lastStepFailedWith(failure);
    }

    private void setAnnotatedResult(String testMethod) {
        if (TestAnnotations.forClass(this.testSuite).isIgnored(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
        }
        if (TestAnnotations.forClass(this.testSuite).isPending(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        }
    }

    public void testFinished(TestOutcome outcome) {
        this.testFinished(outcome, false);
    }

    public void testFinished(TestOutcome result, boolean isInDataDrivenTest) {
        this.testFinished(result, isInDataDrivenTest, ZonedDateTime.now());
    }

    public void testFinished(TestOutcome outcome, boolean isInDataDrivenTest, ZonedDateTime finishTime) {
        if (this.getTestOutcomes().isEmpty()) {
            return;
        }
        LifecycleRegister.invokeMethodsAnnotatedBy(AfterScenario.class, this.getCurrentTestOutcome());
        this.recordTestDuration(finishTime);
        this.getCurrentTestOutcome().addIssues(this.storywideIssues);
        this.getCurrentTestOutcome().addTags(this.storywideTags);
        if (StepEventBus.getParallelEventBus().isDryRun() || this.getCurrentTestOutcome().getResult() == TestResult.IGNORED) {
            this.testAndTopLevelStepsShouldBeIgnored();
        }
        OverrideDriverCapabilities.clear();
        if (TestSession.getTestSessionContext().getWebDriver() != null) {
            this.handlePostponedParallelExecution(outcome, isInDataDrivenTest);
        } else {
            this.cleanupWebdriverInstance(isInDataDrivenTest);
        }
        this.currentStepStack.clear();
        while (!this.currentGroupStack.isEmpty()) {
            this.finishGroup();
        }
        LifecycleRegister.clear();
    }

    public void cleanupWebdriverInstance(boolean isInDataDrivenTest, TestOutcome testOutcome) {
        if (this.currentTestIsABrowserTest()) {
            testOutcome.setDriver(this.getDriverUsedInThisTest());
            this.updateSessionIdIfKnown(testOutcome);
            AtTheEndOfAWebDriverTest.invokeCustomTeardownLogicWithDriver(this.getEventBus().getEnvironmentVariables(), testOutcome, SerenityWebdriverManager.inThisTestThread().getCurrentDriver());
            if (isInDataDrivenTest) {
                this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.EXAMPLE);
            } else {
                this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.SCENARIO);
                ThucydidesWebDriverSupport.clearDefaultDriver();
            }
        }
    }

    public void cleanupWebdriverInstance(boolean isInDataDrivenTest) {
        this.cleanupWebdriverInstance(isInDataDrivenTest, this.getCurrentTestOutcome());
    }

    private void handlePostponedParallelExecution(TestOutcome outcome, boolean isInDataDrivenTest) {
        this.getCurrentTestOutcome().setDriver(TestSession.getTestSessionContext().getDriverUsedInThisTest());
        this.updateSessionIdIfKnown();
        AtTheEndOfAWebDriverTest.invokeCustomTeardownLogicWithDriver(this.getEventBus().getEnvironmentVariables(), outcome, TestSession.getTestSessionContext().getWebDriver());
        if (isInDataDrivenTest) {
            this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.EXAMPLE);
        } else {
            this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.SCENARIO);
            ThucydidesWebDriverSupport.clearDefaultDriver();
        }
    }

    private void testAndTopLevelStepsShouldBeIgnored() {
        this.getCurrentTestOutcome().setResult(TestResult.IGNORED);
        if (this.getCurrentTestOutcome().isDataDriven()) {
            this.getCurrentTestOutcome().updateTopLevelStepResultsTo(TestResult.IGNORED);
        }
    }

    private String getDriverUsedInThisTest() {
        return ThucydidesWebDriverSupport.getDriversUsed();
    }

    private boolean currentTestIsABrowserTest() {
        return SerenityJUnitTestCase.inClass(this.testSuite).isAWebTest() || this.testSuite == null && ThucydidesWebDriverSupport.isDriverInstantiated();
    }

    public void testRetried() {
        this.currentStepStack.clear();
        this.testOutcomes.remove(this.getCurrentTestOutcome());
    }

    private void recordTestDuration(ZonedDateTime finishTime) {
        if (!this.testOutcomes.isEmpty()) {
            this.getCurrentTestOutcome().recordDuration(finishTime);
        }
    }

    private void recordTestDuration() {
        this.recordTestDuration(ZonedDateTime.now());
    }

    public void stepStarted(ExecutedStepDescription description) {
        this.pushStepMethodIn(description);
        this.recordStep(description);
        if (this.currentTestIsABrowserTest() && this.browserIsOpen()) {
            this.takeInitialScreenshot();
        }
    }

    public void stepStarted(ExecutedStepDescription description, ZonedDateTime startTime) {
        this.pushStepMethodIn(description);
        TestStep newStep = this.recordStep(description);
        if (newStep != null) {
            newStep.setStartTime(startTime);
        }
        if (this.currentTestIsABrowserTest() && this.browserIsOpen()) {
            this.takeInitialScreenshot();
        }
    }

    private void pushStepMethodIn(ExecutedStepDescription description) {
        if (description.isAQuestion()) {
            this.currentStepMethodStack.push(this.tokenQuestionMethod());
        } else {
            this.currentStepMethodStack.push(description.getStepMethod());
        }
    }

    private Method tokenQuestionMethod() {
        try {
            return Question.class.getMethod("ask", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
        this.recordStep(description);
    }

    public Optional<Method> getCurrentStepMethod() {
        return this.currentStepMethodStack.empty() ? Optional.empty() : Optional.ofNullable(this.currentStepMethodStack.peek());
    }

    private TestStep recordStep(ExecutedStepDescription description) {
        if (!this.latestTestOutcome().isPresent()) {
            return null;
        }
        TestStep step = new TestStep(AnnotatedStepDescription.from((ExecutedStepDescription)description).getName());
        this.startNewGroupIfNested();
        this.setDefaultResultFromAnnotations(step, description);
        this.currentStepStack.push(step);
        this.recordStepToCurrentTestOutcome(step);
        return step;
    }

    private void recordStepToCurrentTestOutcome(TestStep step) {
        this.getCurrentTestOutcome().recordStep(step);
    }

    private void setDefaultResultFromAnnotations(TestStep step, ExecutedStepDescription description) {
        if (TestAnnotations.isPending((Method)description.getStepMethod())) {
            step.setResult(TestResult.PENDING);
        }
        if (TestAnnotations.isIgnored((Method)description.getStepMethod())) {
            step.setResult(TestResult.IGNORED);
        }
    }

    private void startNewGroupIfNested() {
        if (this.thereAreUnfinishedSteps() && this.getCurrentStep() != this.getCurrentGroup()) {
            this.startNewGroup();
        }
    }

    private void startNewGroup() {
        this.getCurrentTestOutcome().startGroup();
        this.currentGroupStack.push(this.getCurrentStep());
    }

    private Optional<TestStep> currentStep() {
        if (this.currentStepStack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.currentStepStack.peek());
    }

    private TestStep getCurrentStep() {
        return this.currentStepStack.peek();
    }

    private Optional<TestStep> getPreviousStep() {
        if (this.getCurrentTestOutcome().getTestStepCount() > 1) {
            List currentTestSteps = this.getCurrentTestOutcome().getTestSteps();
            return Optional.of((TestStep)currentTestSteps.get(currentTestSteps.size() - 2));
        }
        return Optional.empty();
    }

    private TestStep getCurrentGroup() {
        return this.currentGroupStack.isEmpty() ? null : this.currentGroupStack.peek();
    }

    private boolean thereAreUnfinishedSteps() {
        return !this.currentStepStack.isEmpty();
    }

    public void stepFinished() {
        this.recordTestDuration();
        this.takeEndOfStepScreenshotFor(TestResult.SUCCESS);
        this.currentStepDone(TestResult.SUCCESS);
        this.pauseIfRequired();
    }

    public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList) {
        this.stepFinished(screenshotList, ZonedDateTime.now());
    }

    public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList, ZonedDateTime timestamp) {
        this.takeEndOfStepScreenshotForPlayback(TestResult.SUCCESS, screenshotList);
        this.currentStepDone(TestResult.SUCCESS, timestamp);
        this.pauseIfRequired();
    }

    private void updateExampleTableIfNecessary(TestResult result) {
        if (this.getCurrentTestOutcome().isDataDriven()) {
            this.getCurrentTestOutcome().updateCurrentRowResult(result);
        }
    }

    public void finishGroup() {
        if (!this.currentGroupStack.isEmpty()) {
            this.currentGroupStack.pop();
            this.getCurrentTestOutcome().endGroup();
        }
    }

    private void pauseIfRequired() {
        int delay = this.configuration.getStepDelay();
        if (delay > 0) {
            this.getClock().pauseFor((long)delay);
        }
    }

    private void markCurrentStepAs(TestResult result) {
        this.getCurrentTestOutcome().currentStep().ifPresent(step -> {
            step.setResult(result);
            this.updateExampleTableIfNecessary(result);
        });
    }

    public void stepFailed(StepFailure failure) {
        if (!this.aStepHasFailed()) {
            this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
            TestFailureCause failureCause = TestFailureCause.from((Throwable)failure.getException());
            this.getCurrentTestOutcome().appendTestFailure(failureCause);
            this.recordFailureDetails(failure);
        }
        this.currentStepDone(this.failureAnalysis.resultFor(failure));
    }

    public void stepFailed(StepFailure failure, List<ScreenshotAndHtmlSource> screenshotList, boolean isInDataDrivenTest) {
        if (!this.aStepHasFailed()) {
            this.takeEndOfStepScreenshotForPlayback(TestResult.FAILURE, screenshotList);
            TestFailureCause failureCause = TestFailureCause.from((Throwable)failure.getException());
            this.getCurrentTestOutcome().appendTestFailure(failureCause);
            this.recordFailureDetails(failure);
        }
        this.currentStepDone(this.failureAnalysis.resultFor(failure));
    }

    public void stepFailedWithException(Throwable failure) {
        if (!this.aStepHasFailed()) {
            this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
            TestFailureCause failureCause = TestFailureCause.from((Throwable)failure);
            this.getCurrentTestOutcome().appendTestFailure(failureCause);
            this.recordFailureDetails(failure);
        }
        this.currentStepDone(this.failureAnalysis.resultFor(failure));
    }

    public void lastStepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().lastStepFailedWith(failure);
        this.lastFailingExample = this.currentExample;
    }

    private void recordFailureDetails(StepFailure failure) {
        if (this.currentStepExists()) {
            this.getCurrentStep().failedWith((Throwable)new StepFailureException(failure.getMessage(), failure.getException()));
        }
        if (this.shouldTagErrors()) {
            this.addTagFor(this.getCurrentTestOutcome());
        }
        this.lastFailingExample = this.currentExample;
    }

    private void recordFailureDetails(Throwable failure) {
        if (this.currentStepExists()) {
            this.getCurrentStep().failedWith((Throwable)new StepFailureException(failure.getMessage(), failure));
        }
        if (this.shouldTagErrors()) {
            this.addTagFor(this.getCurrentTestOutcome());
        }
        this.lastFailingExample = this.currentExample;
    }

    private void addTagFor(TestOutcome testOutcome) {
        testOutcome.addTag(TestTag.withName((String)testOutcome.getTestFailureCause().getSimpleErrorType()).andType("error"));
    }

    private boolean shouldTagErrors() {
        return ThucydidesSystemProperty.SERENITY_TAG_FAILURES.booleanFrom(this.configuration.getEnvironmentVariables());
    }

    public void stepIgnored() {
        if (this.aStepHasFailed()) {
            this.markCurrentStepAs(TestResult.SKIPPED);
            this.currentStepDone(TestResult.SKIPPED);
        } else {
            this.currentStepDone(TestResult.IGNORED);
        }
    }

    public void stepPending() {
        this.currentStepDone(TestResult.PENDING);
    }

    public void stepPending(String message) {
        this.getCurrentStep().testAborted((Throwable)new PendingStepException(message));
        this.stepPending();
    }

    public void assumptionViolated(String message) {
        if (this.thereAreUnfinishedSteps()) {
            this.getCurrentStep().testAborted((Throwable)new PendingStepException(message));
            this.stepIgnored();
        }
        this.testIgnored();
    }

    public void testRunFinished() {
        this.closeDarkroom();
        ConfigCache.instance().clear();
    }

    public void takeScreenshots(List<ScreenshotAndHtmlSource> screenshots) {
        this.takeEndOfStepScreenshotForRecording(TestResult.SUCCESS, screenshots);
    }

    public void takeScreenshots(TestResult result, List<ScreenshotAndHtmlSource> screenshots) {
        this.takeEndOfStepScreenshotForRecording(result, screenshots);
    }

    public void currentStepDone(TestResult result, ZonedDateTime time) {
        if (!this.currentStepMethodStack.isEmpty()) {
            this.currentStepMethodStack.pop();
        }
        if (this.currentStepExists()) {
            TestStep finishedStep = this.currentStepStack.pop();
            finishedStep.recordDuration(time);
            if (result != null && result.isAtLeast(finishedStep.getResult())) {
                finishedStep.setResult(result);
            }
            if (finishedStep == this.getCurrentGroup()) {
                this.finishGroup();
            }
        }
        this.updateExampleTableIfNecessary(result);
    }

    public void currentStepDone(TestResult result) {
        this.currentStepDone(result, ZonedDateTime.now());
    }

    private boolean currentStepExists() {
        return !this.currentStepStack.isEmpty();
    }

    public int getCurrentLevel() {
        return this.currentStepStack.size();
    }

    private void takeEndOfStepScreenshotFor(TestResult result) {
        if (this.currentTestIsABrowserTest() && this.shouldTakeEndOfStepScreenshotFor(result)) {
            this.take(ScreenshotType.MANDATORY_SCREENSHOT, result);
        }
    }

    private void takeEndOfStepScreenshotForRecording(TestResult result, List<ScreenshotAndHtmlSource> screenshots) {
        if (this.currentTestIsABrowserTest() && this.shouldTakeEndOfStepScreenshotFor(result)) {
            this.takeRecord(ScreenshotType.MANDATORY_SCREENSHOT, result, screenshots);
        }
    }

    private void takeEndOfStepScreenshotForPlayback(TestResult result, List<ScreenshotAndHtmlSource> screenshots) {
        if (screenshots != null && screenshots.size() > 0) {
            this.takePlayback(ScreenshotType.MANDATORY_SCREENSHOT, result, screenshots);
        }
    }

    public Optional<TestResult> getForcedResult() {
        return Optional.ofNullable(this.getCurrentTestOutcome().getAnnotatedResult());
    }

    public void clearForcedResult() {
        this.getCurrentTestOutcome().clearForcedResult();
    }

    private void take(ScreenshotType screenshotType) {
        this.take(screenshotType, TestResult.UNDEFINED);
    }

    private void take(ScreenshotType screenshotType, TestResult result) {
        if (this.shouldTakeScreenshots(result)) {
            try {
                this.grabScreenshots(result).forEach(screenshot -> this.recordScreenshotIfRequired(screenshotType, (ScreenshotAndHtmlSource)screenshot));
                this.removeDuplicatedInitialScreenshotsIfPresent();
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private void takeRecord(ScreenshotType screenshotType, TestResult result, List<ScreenshotAndHtmlSource> screenshots) {
        if (this.shouldTakeScreenshotsWithoutCurrentStep(result)) {
            try {
                this.grabScreenshots(result).forEach(screenshot -> {
                    boolean screenshotExisting = screenshots.stream().map(screens -> screens.getScreenshot().getName()).collect(Collectors.toList()).contains(screenshot.getScreenshot().getName());
                    if (!screenshotExisting) {
                        screenshots.add((ScreenshotAndHtmlSource)screenshot);
                    } else {
                        LOGGER.warn("SRP:Found duplicate snapshot " + screenshot.getScreenshot().getName());
                    }
                });
                if (this.currentStep().isPresent()) {
                    this.removeDuplicatedInitialScreenshotsIfPresent();
                }
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private void takePlayback(ScreenshotType screenshotType, TestResult result, List<ScreenshotAndHtmlSource> screenshots) {
        if (screenshots != null && screenshots.size() > 0) {
            screenshots.forEach(screenshot -> this.currentStep().ifPresent(step -> step.addScreenshot(screenshot)));
            if (this.currentStep().isPresent()) {
                this.removeDuplicatedInitialScreenshotsIfPresent();
            }
        }
    }

    private boolean shouldTakeScreenshots(TestResult result) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended() && !StepEventBus.getParallelEventBus().softAssertsActive()) {
            return false;
        }
        if (this.screenshots().areDisabledForThisAction(result)) {
            return false;
        }
        return this.currentStepExists() && this.browserIsOpen() && !StepEventBus.getParallelEventBus().isDryRun() && !StepEventBus.getParallelEventBus().currentTestIsSuspended();
    }

    private boolean shouldTakeScreenshotsWithoutCurrentStep(TestResult result) {
        if (StepEventBus.getParallelEventBus().webdriverCallsAreSuspended() && !StepEventBus.getParallelEventBus().softAssertsActive()) {
            return false;
        }
        if (this.screenshots().areDisabledForThisAction(result)) {
            return false;
        }
        return this.browserIsOpen() && !StepEventBus.getParallelEventBus().isDryRun() && !StepEventBus.getParallelEventBus().currentTestIsSuspended();
    }

    private void removeDuplicatedInitialScreenshotsIfPresent() {
        if (this.currentStepHasMoreThanOneScreenshot() && this.getPreviousStep().isPresent() && this.getPreviousStep().get().hasScreenshots()) {
            ScreenshotAndHtmlSource lastScreenshotOfPreviousStep = this.lastScreenshotOf(this.getPreviousStep().get());
            ScreenshotAndHtmlSource firstScreenshotOfThisStep = this.getCurrentStep().getFirstScreenshot();
            if (firstScreenshotOfThisStep.hasIdenticalScreenshotsAs(lastScreenshotOfPreviousStep)) {
                this.removeFirstScreenshotOfCurrentStep();
            }
        }
    }

    private void removeFirstScreenshotOfCurrentStep() {
        this.getCurrentStep().removeScreenshot(0);
    }

    private boolean currentStepHasMoreThanOneScreenshot() {
        return this.currentStepExists() && this.getCurrentStep().getScreenshotCount() > 1;
    }

    private ScreenshotAndHtmlSource lastScreenshotOf(TestStep testStep) {
        return (ScreenshotAndHtmlSource)testStep.getScreenshots().get(testStep.getScreenshots().size() - 1);
    }

    private void recordScreenshotIfRequired(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.shouldTakeScreenshot(screenshotType, screenshotAndHtmlSource) && this.screenshotWasTaken(screenshotAndHtmlSource)) {
            this.currentStep().ifPresent(step -> step.addScreenshot(screenshotAndHtmlSource));
        }
    }

    private boolean screenshotWasTaken(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.getScreenshot() != null;
    }

    private boolean shouldTakeScreenshot(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.screenshots().areDisabled()) {
            return false;
        }
        return screenshotType == ScreenshotType.MANDATORY_SCREENSHOT || !this.currentStep().isPresent() || this.getCurrentStep().getScreenshots().isEmpty() || this.shouldTakeOptionalScreenshot(screenshotAndHtmlSource);
    }

    private boolean shouldTakeOptionalScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.wasTaken() && this.previousScreenshot().isPresent() && !screenshotAndHtmlSource.hasIdenticalScreenshotsAs(this.previousScreenshot().get());
    }

    private Optional<ScreenshotAndHtmlSource> previousScreenshot() {
        List screenshotsToDate = this.getCurrentTestOutcome().getScreenshotAndHtmlSources();
        if (screenshotsToDate.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ScreenshotAndHtmlSource)screenshotsToDate.get(screenshotsToDate.size() - 1));
    }

    private boolean browserIsOpen() {
        return ThucydidesWebDriverSupport.isDriverInstantiated();
    }

    private void takeInitialScreenshot() {
        if (this.currentStepExists() && this.screenshots().areAllowed(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    public Map<String, WebDriver> getActiveDrivers() {
        return SerenityWebdriverManager.inThisTestThread().getActiveDriverMap();
    }

    private List<ScreenshotAndHtmlSource> grabScreenshots(TestResult result) {
        if (this.pathOf(this.outputDirectory) == null) {
            return new ArrayList<ScreenshotAndHtmlSource>();
        }
        return SerenityWebdriverManager.inThisTestThread().getCurrentDrivers().stream().map(driver -> new ScreenshotAndHtmlSource(this.screenshotFrom((WebDriver)driver), this.sourceFrom(result, (WebDriver)driver))).filter(ScreenshotAndHtmlSource::wasTaken).collect(Collectors.toList());
    }

    private File screenshotFrom(WebDriver driver) {
        Path screenshotPath = this.getPhotographer().takesAScreenshot().with(new WebDriverPhotoLens(driver)).andWithBlurring(AnnotatedBluring.blurLevel()).toDirectory(this.pathOf(this.outputDirectory)).takeScreenshot().getPathToScreenshot();
        return screenshotPath == null ? null : screenshotPath.toFile();
    }

    private File sourceFrom(TestResult result, WebDriver driver) {
        return this.soundEngineer.ifRequiredForResult(result).recordPageSourceUsing(driver).intoDirectory(this.pathOf(this.outputDirectory)).orElse(null);
    }

    private Path pathOf(File directory) {
        return directory == null ? null : directory.toPath();
    }

    private boolean shouldTakeEndOfStepScreenshotFor(TestResult result) {
        if (result.isAtLeast(TestResult.FAILURE)) {
            return this.screenshots().areAllowed(TakeScreenshots.FOR_FAILURES, result);
        }
        return this.screenshots().areAllowed(TakeScreenshots.AFTER_EACH_STEP, result);
    }

    @Override
    public List<TestOutcome> getTestOutcomes() {
        return this.testOutcomes.stream().sorted((o1, o2) -> {
            String creationTimeAndName1 = String.valueOf(o1.getStartTime()) + "_" + o1.getName();
            String creationTimeAndName2 = String.valueOf(o1.getStartTime()) + "_" + o1.getName();
            return creationTimeAndName1.compareTo(creationTimeAndName2);
        }).collect(Collectors.toList());
    }

    @Override
    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public WebDriver getDriver() {
        return ThucydidesWebDriverSupport.getDriver();
    }

    @Override
    public boolean aStepHasFailed() {
        TestResult currentResult = CurrentTestResult.forTestOutcome(this.getCurrentTestOutcome(), this.currentExample);
        return !this.getTestOutcomes().isEmpty() && currentResult.isUnsuccessful();
    }

    @Override
    public Optional<TestStep> firstFailingStep() {
        return this.latestTestOutcome().flatMap(outcome -> outcome.getFlattenedTestSteps().stream().filter(step -> step.getException() != null).findFirst());
    }

    public boolean aStepHasFailedInTheCurrentExample() {
        if (this.currentExample == 0) {
            return this.aStepHasFailed();
        }
        return this.aStepHasFailed() && this.currentExample == this.lastFailingExample;
    }

    @Override
    public FailureCause getTestFailureCause() {
        return this.getCurrentTestOutcome().getTestFailureCause();
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().determineTestFailureCause(cause);
    }

    public void testIgnored() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
    }

    public void testSkipped() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.SKIPPED);
    }

    public void testAborted() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.ABORTED);
    }

    public void testPending() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        this.updateExampleTableIfNecessary(TestResult.PENDING);
    }

    private boolean testOutcomeRecorded() {
        return !this.testOutcomes.isEmpty();
    }

    public void testIsManual() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(this.defaulManualTestReportResult());
        this.getCurrentTestOutcome().setToManual();
    }

    private TestResult defaulManualTestReportResult() {
        String manualTestResultValue = ThucydidesSystemProperty.MANUAL_TEST_REPORT_RESULT.from(this.configuration.getEnvironmentVariables(), TestResult.PENDING.toString());
        TestResult manualTestResult = TestResult.PENDING;
        try {
            manualTestResult = TestResult.valueOf((String)manualTestResultValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Badly configured value for manual.test.report.result: should be one of " + Arrays.toString(TestResult.values()));
        }
        return manualTestResult;
    }

    public void notifyScreenChange() {
        if (this.currentTestIsABrowserTest() && this.screenshots().areAllowed(TakeScreenshots.FOR_EACH_ACTION)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    public void notifyUIError() {
        if (this.currentTestIsABrowserTest() && this.screenshots().areAllowed(TakeScreenshots.FOR_FAILURES)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT, TestResult.FAILURE);
        }
    }

    public void takeScreenshot() {
        this.take(ScreenshotType.MANDATORY_SCREENSHOT);
    }

    public void useExamplesFrom(DataTable table) {
        this.getCurrentTestOutcome().useExamplesFrom(table);
        this.currentExample = 0;
        this.lastFailingExample = 0;
    }

    public void addNewExamplesFrom(DataTable table) {
        this.getCurrentTestOutcome().addNewExamplesFrom(table);
    }

    public void exampleStarted(Map<String, String> data) {
        this.exampleStarted(data, "");
    }

    public void exampleStarted(Map<String, String> data, ZonedDateTime startTime) {
        this.exampleStarted(data, "", startTime);
    }

    public void exampleStarted(Map<String, String> data, String exampleName) {
        this.exampleStarted(data, exampleName, ZonedDateTime.now());
    }

    public void exampleStarted(Map<String, String> data, String exampleName, ZonedDateTime startTime) {
        this.clearForcedResult();
        if (this.getCurrentTestOutcome().isDataDriven() && !this.getCurrentTestOutcome().dataIsPredefined()) {
            this.getCurrentTestOutcome().addRow(data);
        }
        ++this.currentExample;
        if (this.newStepForEachExample()) {
            String exampleTitle = exampleName.isEmpty() ? this.exampleTitle(this.currentExample, data) : this.exampleTitle(this.currentExample, exampleName, data);
            this.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)exampleTitle), startTime);
        }
        LifecycleRegister.invokeMethodsAnnotatedBy(BeforeExample.class, this.getCurrentTestOutcome());
    }

    private String exampleTitle(int exampleNumber, Map<String, String> data) {
        return String.format("Example %d: %s", exampleNumber, data);
    }

    private String exampleTitle(int exampleNumber, String exampleName, Map<String, String> data) {
        return String.format("%d: %s (%s)", exampleNumber, exampleName, data);
    }

    public void exampleFinished() {
        LifecycleRegister.invokeMethodsAnnotatedBy(AfterExample.class, this.getCurrentTestOutcome());
        if (this.newStepForEachExample()) {
            this.currentStepDone(null);
        }
        if (this.latestTestOutcome().isPresent()) {
            this.latestTestOutcome().get().moveToNextRow();
        }
        OverrideDriverCapabilities.clear();
        if (TestSession.getTestSessionContext().getWebDriver() != null) {
            this.getCurrentTestOutcome().setDriver(TestSession.getTestSessionContext().getDriverUsedInThisTest());
            AtTheEndOfAWebDriverTest.invokeCustomTeardownLogicWithDriver(this.getEventBus().getEnvironmentVariables(), this.getCurrentTestOutcome(), TestSession.getTestSessionContext().getWebDriver());
        } else if (this.currentTestIsABrowserTest()) {
            this.getCurrentTestOutcome().setDriver(this.getDriverUsedInThisTest());
            AtTheEndOfAWebDriverTest.invokeCustomTeardownLogicWithDriver(this.getEventBus().getEnvironmentVariables(), this.getCurrentTestOutcome(), SerenityWebdriverManager.inThisTestThread().getCurrentDriver());
        }
        this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.EXAMPLE);
    }

    private boolean newStepForEachExample() {
        if (this.latestTestOutcome().isEmpty()) {
            return false;
        }
        return this.getCurrentTestOutcome().getTestSource() != null && !this.getCurrentTestOutcome().getTestSource().equalsIgnoreCase("junit");
    }

    public void recordRestQuery(RestQuery restQuery) {
        this.stepStarted(ExecutedStepDescription.withTitle((String)restQuery.toString()));
        this.addRestQuery(restQuery);
        this.stepFinished();
    }

    private void addRestQuery(RestQuery restQuery) {
        this.currentStep().ifPresent(step -> step.recordRestQuery(restQuery));
    }

    public void clearTestOutcomes() {
        this.testOutcomes.clear();
    }

    public class StepMerger {
        final int maxStepsToMerge;

        public StepMerger(int maxStepsToMerge) {
            this.maxStepsToMerge = maxStepsToMerge;
        }

        public void steps() {
            BaseStepListener.this.getCurrentTestOutcome().mergeMostRecentSteps(this.maxStepsToMerge);
        }
    }

    public class StepMutator {
        private final BaseStepListener baseStepListener;

        public StepMutator(BaseStepListener baseStepListener) {
            this.baseStepListener = baseStepListener;
        }

        public void asAPrecondition() {
            this.baseStepListener.getCurrentStep().setPrecondition(true);
        }
    }

    static class Question {
        Question() {
        }

        public void ask() {
        }
    }

    protected static enum ScreenshotType {
        OPTIONAL_SCREENSHOT,
        MANDATORY_SCREENSHOT;

    }
}

