/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.io.IOException;
import net.serenitybdd.core.photography.PhotoLens;
import net.serenitybdd.core.photography.ScreenShooter;
import net.serenitybdd.core.photography.WebDriverPhotoLens;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverScreenShooter
implements ScreenShooter {
    private final WebDriver driver;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverScreenShooter.class);

    public WebDriverScreenShooter(PhotoLens lens) {
        this.driver = ((WebDriverPhotoLens)lens).getDriver();
    }

    @Override
    public byte[] takeScreenshot() throws IOException {
        try {
            return this.driver instanceof TakesScreenshot ? (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES) : new byte[]{};
        }
        catch (Exception failedToTakeScreenshot) {
            LOGGER.warn("Failed to take screenshot - Selenium reported the following error", (Throwable)failedToTakeScreenshot);
            return new byte[0];
        }
    }
}

