/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.webdriver.capabilities.ListOfValues;
import net.thucydides.core.webdriver.capabilities.NestedMap;
import net.thucydides.core.webdriver.capabilities.SetBrowserVersionAndPlatform;
import net.thucydides.core.webdriver.capabilities.SetCommonBrowserOptions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxOptionsBuilder {
    public static FirefoxOptions fromDesiredCapabilities(DesiredCapabilities capabilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions((Capabilities)capabilities);
        SetBrowserVersionAndPlatform.from(capabilities).in((AbstractDriverOptions)firefoxOptions);
        SetCommonBrowserOptions.from(capabilities.asMap()).in((AbstractDriverOptions)firefoxOptions);
        if (capabilities.getCapability("moz:firefoxOptions") != null) {
            Map<String, Object> options = NestedMap.called("moz:firefoxOptions").from(capabilities.asMap());
            List firefoxSpecificOptions = options.keySet().stream().filter(field -> !SetCommonBrowserOptions.propertyNames().contains(field)).collect(Collectors.toList());
            Iterator iterator = firefoxSpecificOptions.iterator();
            block18: while (iterator.hasNext()) {
                String optionName;
                switch (optionName = (String)iterator.next()) {
                    case "binary": {
                        FirefoxBinary binary = new FirefoxBinary(new File(options.get("binary").toString()));
                        firefoxOptions.setBinary(binary);
                        break;
                    }
                    case "args": {
                        if (!(options.get("args") instanceof List)) break;
                        List<String> args = ListOfValues.from(options).forProperty("args");
                        firefoxOptions.getBinary().addCommandLineOptions(args.toArray(new String[0]));
                        if (!args.contains("headless") && !args.contains("-headless")) continue block18;
                        firefoxOptions.setHeadless(true);
                        break;
                    }
                    case "log": {
                        Map<String, Object> logLevels = NestedMap.called("log").from(options);
                        if (logLevels == null || !logLevels.containsKey("level")) break;
                        firefoxOptions.setLogLevel(FirefoxDriverLogLevel.fromString((String)logLevels.get("level").toString()));
                        break;
                    }
                    case "androidPackage": {
                        firefoxOptions.setAndroidPackage(options.get("androidPackage").toString());
                        break;
                    }
                    case "androidActivity": {
                        firefoxOptions.setAndroidActivity(options.get("androidActivity").toString());
                        break;
                    }
                    case "androidDeviceSerial": {
                        firefoxOptions.setAndroidDeviceSerialNumber(options.get("androidDeviceSerial").toString());
                        break;
                    }
                    case "androidIntentArguments": {
                        firefoxOptions.setAndroidIntentArguments(ListOfValues.from(options).forProperty("androidIntentArguments"));
                    }
                }
            }
        }
        return firefoxOptions;
    }
}

