/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.webdriver.driverproviders.EnvironmentSwitches;
import net.serenitybdd.core.webdriver.driverproviders.InsecureCertConfig;
import net.serenitybdd.core.webdriver.enhancers.CustomChromiumOptions;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.reflection.ClassFinder;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.chromium.ChromiumOptions;

public class ConfigureChromiumOptions {
    private final EnvironmentVariables environmentVariables;

    private ConfigureChromiumOptions(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static ConfigureChromiumOptions from(EnvironmentVariables environmentVariables) {
        return new ConfigureChromiumOptions(environmentVariables);
    }

    public <T extends ChromiumOptions<?>> T into(ChromiumOptions<?> chromeOptions) {
        this.applyCustomChromeOptionsTo(chromeOptions);
        return (T)chromeOptions;
    }

    private void applyCustomChromeOptionsTo(ChromiumOptions<?> chromeOptions) {
        List customChromeOptions = ClassFinder.loadClasses().thatImplement(CustomChromiumOptions.class).fromPackage("net.serenitybdd.plugins");
        String extensionPackageList = ThucydidesSystemProperty.SERENITY_EXTENSION_PACKAGES.from(this.environmentVariables);
        if (extensionPackageList != null) {
            List<String> extensionPackages = Arrays.asList(extensionPackageList.split(","));
            extensionPackages.forEach(extensionPackage -> customChromeOptions.addAll(ClassFinder.loadClasses().thatImplement(CustomChromiumOptions.class).fromPackage(extensionPackage)));
        }
        customChromeOptions.forEach(enhancerType -> {
            try {
                ((CustomChromiumOptions)enhancerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).apply(this.environmentVariables, chromeOptions);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        if (ThucydidesSystemProperty.HEADLESS_MODE.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            chromeOptions.addArguments(new String[]{"--headless=chrome"});
        }
        chromeOptions.setAcceptInsecureCerts(InsecureCertConfig.acceptInsecureCertsDefinedIn(this.environmentVariables).orElse(false).booleanValue());
        EnvironmentSwitches.from(this.environmentVariables).addEnvironmentSwitchesTo(chromeOptions);
    }
}

