/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import java.util.Optional;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;

public class GeckoDriverServiceExecutable {
    private final EnvironmentVariables environmentVariables;

    public GeckoDriverServiceExecutable(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static Optional<File> inEnvironment(EnvironmentVariables environmentVariables) {
        return new GeckoDriverServiceExecutable(environmentVariables).executablePath();
    }

    private Optional<File> executablePath() {
        File geckoBinary = this.geckoBinaryCalled("geckodriver");
        if (geckoBinary == null || !geckoBinary.exists()) {
            geckoBinary = this.geckoBinaryCalled("wires");
        }
        return Optional.ofNullable(geckoBinary);
    }

    private File geckoBinaryCalled(String driverName) {
        return DriverServiceExecutable.called(driverName).withSystemProperty(ThucydidesSystemProperty.WEBDRIVER_GECKO_DRIVER.getPropertyName()).usingEnvironmentVariables(this.environmentVariables).downloadableFrom("https://github.com/mozilla/geckodriver/releases").asAFile();
    }
}

