/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import net.serenitybdd.model.CurrentOS;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.os.ExecutableFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverServiceExecutable {
    private final String exeName;
    private final String exeProperty;
    private final String documentationUrl;
    private final String downloadUrl;
    private final EnvironmentVariables environmentVariables;
    private final boolean reportMissingBinary;
    private static final String ANSI_RED = "\u001b[91m";
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String DRIVER_ISSUE_BANNER = "  ___      _                ___           __ _                    _   _            ___                \n |   \\ _ _(_)_ _____ _ _   / __|___ _ _  / _(_)__ _ _  _ _ _ __ _| |_(_)___ _ _   |_ _|_______  _ ___ \n | |) | '_| \\ V / -_) '_| | (__/ _ \\ ' \\|  _| / _` | || | '_/ _` |  _| / _ \\ ' \\   | |(_-<_-< || / -_)\n |___/|_| |_|\\_/\\___|_|    \\___\\___/_||_|_| |_\\__, |\\_,_|_| \\__,_|\\__|_\\___/_||_| |___/__/__/\\_,_\\___|\n  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ |___/__ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ \n |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|\n                                                                                                      \n                                                                                                      ";
    private static final String MISSING_BINARY = "The path to the %s driver executable must be set by the %s system property, or be available on the system path; for more information, see %s. The latest version can be downloaded from %s";
    private static final String NON_EXECUTABLE_BINARY = "The specified driver value of '%s' appears to be incorrect. Make sure it is the correct WebDriver driver for this operating system.";
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverServiceExecutable.class);

    public DriverServiceExecutable(String exeName, String exeProperty, String documentationUrl, String downloadUrl, EnvironmentVariables environmentVariables, boolean checkExecutable) {
        this.exeName = exeName;
        this.exeProperty = exeProperty;
        this.documentationUrl = documentationUrl;
        this.downloadUrl = downloadUrl;
        this.environmentVariables = environmentVariables;
        this.reportMissingBinary = checkExecutable;
    }

    public static DriverServiceExecutableBuilder called(String exeName) {
        return new DriverServiceExecutableBuilder(exeName);
    }

    public File asAFile() {
        Path binaryPath = this.asAPath();
        if (this.reportMissingBinary) {
            this.checkForMissingBinaries(binaryPath);
        }
        return binaryPath != null ? binaryPath.toFile() : null;
    }

    public Path asAPath() {
        String pathOnFilesystem = new ExecutableFinder().find(this.exeName);
        Optional<String> defaultPath = Optional.ofNullable(pathOnFilesystem);
        Optional<String> osSpecificPath = Optional.ofNullable(this.nullIfEmpty(this.configuredPath(this.osSpecific(this.exeProperty))));
        Optional<String> configuredBinaryPath = Optional.ofNullable(this.nullIfEmpty(this.configuredPath(this.exeProperty)));
        String exePath = configuredBinaryPath.orElse(osSpecificPath.orElse(defaultPath.orElse(null)));
        return exePath == null ? null : Paths.get(exePath, new String[0]);
    }

    private String configuredPath(String propertyName) {
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{propertyName}).orElse(System.getProperty(propertyName));
    }

    private String nullIfEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value) ? null : value;
    }

    private String osSpecific(String exeProperty) {
        return "drivers." + String.valueOf(CurrentOS.getType()) + "." + exeProperty;
    }

    private void checkForMissingBinaries(Path binaryPath) {
        String documentationSource = Optional.ofNullable(this.documentationUrl).orElse(this.downloadUrl);
        if (binaryPath == null) {
            DriverServiceExecutable.logErrorBanner(System.lineSeparator() + DRIVER_ISSUE_BANNER + System.lineSeparator() + String.format(MISSING_BINARY, this.exeName, this.exeProperty, documentationSource, this.downloadUrl));
        } else if (!DriverServiceExecutable.isExecutable(binaryPath.toFile())) {
            DriverServiceExecutable.logErrorBanner(System.lineSeparator() + DRIVER_ISSUE_BANNER + System.lineSeparator() + String.format(NON_EXECUTABLE_BINARY, binaryPath.toFile()));
        }
        Preconditions.checkState((binaryPath != null ? 1 : 0) != 0, (Object)"Path to the driver file was not defined");
        DriverServiceExecutable.checkExecutable(binaryPath.toFile());
    }

    protected static boolean isExecutable(File exe) {
        return exe.exists() && !exe.isDirectory() && exe.canExecute();
    }

    protected static void checkExecutable(File exe) {
        Preconditions.checkState((boolean)exe.exists(), (String)"The driver executable does not exist: %s", (Object)exe.getAbsolutePath());
        Preconditions.checkState((!exe.isDirectory() ? 1 : 0) != 0, (String)"The driver executable is a directory: %s", (Object)exe.getAbsolutePath());
        Preconditions.checkState((boolean)exe.canExecute(), (String)"The driver is not executable: %s", (Object)exe.getAbsolutePath());
    }

    private static void logErrorBanner(String text) {
        LOGGER.error(ANSI_RED + text + ANSI_RESET);
    }

    public static class DriverServiceExecutableBuilder {
        private final String exeName;
        private String exeProperty;
        private String documentationUrl;
        private Optional<EnvironmentVariables> environmentVariables = Optional.empty();
        private final boolean reportMissingBinary = false;

        public DriverServiceExecutableBuilder(String exeName) {
            this.exeName = exeName;
        }

        public DriverServiceExecutableBuilder withSystemProperty(String environmentProperty) {
            this.exeProperty = environmentProperty;
            return this;
        }

        public DriverServiceExecutableBuilder documentedAt(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public DriverServiceExecutableBuilder reportMissingBinary() {
            return this;
        }

        public DriverServiceExecutable downloadableFrom(String downloadUrl) {
            return new DriverServiceExecutable(this.exeName, this.exeProperty, this.documentationUrl, downloadUrl, this.environmentVariables.orElse(ConfiguredEnvironment.getEnvironmentVariables()), false);
        }

        public DriverServiceExecutableBuilder usingEnvironmentVariables(EnvironmentVariables environmentVariables) {
            this.environmentVariables = Optional.of(environmentVariables);
            return this;
        }
    }
}

