/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core;

import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.Reportable;
import net.serenitybdd.core.SessionMap;
import net.serenitybdd.core.configurers.WebDriverConfigurer;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.core.lifecycle.LifecycleRegister;
import net.serenitybdd.core.reports.ReportDataSaver;
import net.serenitybdd.core.reports.WithTitle;
import net.serenitybdd.core.sessions.TestSessionVariables;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.serenitybdd.model.IgnoredStepException;
import net.serenitybdd.model.PendingStepException;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.di.DependencyInjector;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.steps.di.DependencyInjectorService;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.webdriver.Configuration;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class Serenity {
    private static final ThreadLocal<StepListener> stepListenerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<TestSessionVariables> testSessionThreadLocal = ThreadLocal.withInitial(TestSessionVariables::new);
    private static final ThreadLocal<FirefoxProfile> firefoxProfileThreadLocal = new ThreadLocal();
    private static ThreadLocal<Boolean> throwExceptionsImmediately = ThreadLocal.withInitial(() -> false);
    private static final LocalDateTime TEST_SUITE_START_TIME = LocalDateTime.now();

    public static void initialize(Object testCase) {
        ThucydidesWebDriverSupport.initialize();
        Serenity.setupWebdriverManager();
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Serenity.initStepListener();
        Serenity.injectDriverInto(testCase);
        Serenity.injectAnnotatedPagesObjectInto(testCase);
        Serenity.injectScenarioStepsInto(testCase);
        Serenity.injectDependenciesInto(testCase);
    }

    public static void injectDependenciesInto(Object testCase) {
        for (DependencyInjector dependencyInjector : Serenity.getDependencyInjectors()) {
            dependencyInjector.injectDependenciesInto(testCase);
        }
    }

    private static void resetDependencyInjectors() {
        for (DependencyInjector dependencyInjector : Serenity.getDependencyInjectors()) {
            dependencyInjector.reset();
        }
    }

    private static List<DependencyInjector> getDependencyInjectors() {
        List dependencyInjectors = Serenity.getDependencyInjectorService().findDependencyInjectors();
        dependencyInjectors.addAll(Serenity.getDefaultDependencyInjectors());
        return dependencyInjectors;
    }

    private static DependencyInjectorService getDependencyInjectorService() {
        return SerenityInfrastructure.getDependencyInjectorService();
    }

    private static List<DependencyInjector> getDefaultDependencyInjectors() {
        return Arrays.asList(new PageObjectDependencyInjector(), new EnvironmentDependencyInjector());
    }

    public static void initializeWithNoStepListener(Object testCase) {
        Serenity.setupWebdriverManager();
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Serenity.injectDriverInto(testCase);
        Serenity.injectAnnotatedPagesObjectInto(testCase);
        Serenity.injectScenarioStepsInto(testCase);
        Serenity.injectDependenciesInto(testCase);
    }

    public static void initStepListener() {
        Configuration configuration = ConfiguredEnvironment.getConfiguration();
        File outputDirectory = configuration.getOutputDirectory();
        BaseStepListener listener = new BaseStepListener(outputDirectory);
        stepListenerThreadLocal.set(listener);
        Serenity.getStepEventBus().registerListener(Serenity.getStepListener());
    }

    public static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDrivers(ThucydidesWebDriverSupport.getDriver(), ThucydidesWebDriverSupport.getWebdriverManager());
    }

    public static void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injector().injectScenarioStepsInto(testCase, Serenity.getStepFactory());
    }

    public static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injector().injectOptionalAnnotatedPagesObjectInto(testCase, Serenity.getPages());
    }

    public static void done() {
        boolean restartBrowserIfNecessary = !RestartBrowserForEach.configuredIn(Serenity.environmentVariables()).restartBrowserForANew(RestartBrowserForEach.NEVER);
        Serenity.done(restartBrowserIfNecessary);
    }

    public static EnvironmentVariables environmentVariables() {
        return SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public static boolean currentDriverIsDisabled() {
        WebDriver currentDriver = Serenity.getWebdriverManager().getCurrentDriver();
        return currentDriver instanceof WebDriverFacade && ((WebDriverFacade)currentDriver).isDisabled();
    }

    public static void done(boolean closeAllDrivers) {
        if (closeAllDrivers && Serenity.getWebdriverManager() != null) {
            Serenity.getWebdriverManager().closeAllDrivers();
        }
        Serenity.notifyTestFinished();
        Serenity.resetDependencyInjectors();
        LifecycleRegister.clear();
    }

    private static void notifyTestFinished() {
        for (StepListener listener : Serenity.stepListeners()) {
            listener.testRunFinished();
        }
    }

    public static String getCurrentSessionID() {
        if (Serenity.getWebdriverManager() != null && Serenity.getWebdriverManager().getSessionId() != null) {
            return Serenity.getWebdriverManager().getSessionId().toString();
        }
        return null;
    }

    public static WebDriver getDriver() {
        return Serenity.getWebdriverManager().getWebdriver();
    }

    public static WebDriver getProxiedDriver() {
        return ((WebDriverFacade)Serenity.getWebdriverManager().getWebdriver()).getProxiedDriver();
    }

    public static WebDriver useDriver(WebDriver driver) {
        WebDriverFacade driverFacade = new WebDriverFacade(driver, SerenityInfrastructure.getWebDriverFactory());
        Serenity.getWebdriverManager().setCurrentDriver(driverFacade);
        return Serenity.getWebdriverManager().getWebdriver();
    }

    protected static Pages getPages() {
        return ThucydidesWebDriverSupport.getPages();
    }

    protected static void stopUsingMockDriver() {
        Serenity.setupWebdriverManager();
    }

    public static WebdriverManager getWebdriverManager() {
        return ThucydidesWebDriverSupport.getWebdriverManager();
    }

    public static StepFactory getStepFactory() {
        return ThucydidesWebDriverSupport.getStepFactory();
    }

    private static void setupWebdriverManager() {
        Serenity.setupWebdriverManager(ThucydidesWebDriverSupport.getWebdriverManager());
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager) {
        ThucydidesWebDriverSupport.initialize(webdriverManager, "");
    }

    private static List<StepListener> stepListeners() {
        if (Serenity.getStepListener() == null) {
            return new ArrayList<StepListener>();
        }
        return NewList.of((Object[])new StepListener[]{Serenity.getStepListener()});
    }

    public static StepListener getStepListener() {
        return stepListenerThreadLocal.get();
    }

    public static void initializeTestSession() {
        Serenity.getCurrentSession().clear();
    }

    public static SessionMap<Object, Object> getCurrentSession() {
        return testSessionThreadLocal.get();
    }

    public static void pendingStep(String reason) {
        throw new PendingStepException(reason);
    }

    public static void ignoredStep(String reason) {
        throw new IgnoredStepException(reason);
    }

    public static void takeScreenshot() {
        Serenity.getStepEventBus().takeScreenshot();
    }

    public static List<ScreenshotAndHtmlSource> takeScreenshots() {
        return Serenity.getStepEventBus().takeScreenshots();
    }

    public static WithTitle recordReportData() {
        return new ReportDataSaver(Serenity.getStepEventBus());
    }

    public static String getDefaultProjectKey() {
        String workingDirPath = System.getProperty("user.dir");
        return new File(workingDirPath).getName();
    }

    public static void useFirefoxProfile(FirefoxProfile profile) {
        firefoxProfileThreadLocal.set(profile);
    }

    public static FirefoxProfile getFirefoxProfile() {
        return firefoxProfileThreadLocal.get();
    }

    public static boolean hasASessionVariableCalled(Object key) {
        return Serenity.getCurrentSession().containsKey(key);
    }

    public static <T> T sessionVariableCalled(Object key) {
        return (T)Serenity.getCurrentSession().get(key);
    }

    public static SessionVariableSetter setSessionVariable(Object key) {
        return new SessionVariableSetter(key);
    }

    public static void clearSessionVariable(String key) {
        Serenity.getCurrentSession().remove(key);
    }

    public static void clearCurrentSession() {
        Serenity.getCurrentSession().clear();
    }

    public static Pages getPagesFactory() {
        return null;
    }

    public static void throwExceptionsImmediately() {
        throwExceptionsImmediately.set(true);
    }

    public static boolean shouldThrowErrorsImmediately() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTrace).anyMatch(element -> element.getClassName().contains("io.cucumber.core"));
    }

    public static WebDriverConfigurer webdriver() {
        return new WebDriverConfigurer();
    }

    public static void reportThat(String message, Reportable reportableAction) {
        Serenity.getStepEventBus().stepStarted(ExecutedStepDescription.withTitle((String)message));
        try {
            reportableAction.perform();
            Serenity.getStepEventBus().stepFinished();
        }
        catch (Throwable assertionFailed) {
            Serenity.getStepEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)message), assertionFailed));
            throw assertionFailed;
        }
    }

    private static StepEventBus getStepEventBus() {
        if (TestSession.isSessionStarted()) {
            return TestSession.getTestSessionContext().getStepEventBus();
        }
        return StepEventBus.getParallelEventBus();
    }

    public static LocalDateTime getTestSuiteStartTime() {
        return TEST_SUITE_START_TIME;
    }

    public static class SessionVariableSetter {
        final Object key;

        public SessionVariableSetter(Object key) {
            this.key = key;
        }

        public <T> void to(T value) {
            if (value != null) {
                Serenity.getCurrentSession().put(this.key, value);
            } else {
                Serenity.getCurrentSession().remove(this.key);
            }
        }
    }
}

