/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.webdriver.CapabilityValue;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;

public class DriverArgs {
    private final String property;

    public DriverArgs(String property) {
        this.property = property;
    }

    public static DriverArgs fromProperty(ThucydidesSystemProperty property) {
        return new DriverArgs(property.getPropertyName());
    }

    public static DriverArgs fromProperty(String property) {
        return new DriverArgs(property);
    }

    public List<String> configuredIn(EnvironmentVariables environmentVariables) {
        Optional args = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{this.property});
        if (args.isPresent()) {
            return DriverArgs.fromValue((String)args.get());
        }
        return new ArrayList<String>();
    }

    public static List<String> fromValue(String value) {
        if (value.isEmpty()) {
            return new ArrayList<String>();
        }
        Object argsValue = CapabilityValue.asObject(value);
        if (argsValue instanceof List) {
            return ((List)argsValue).stream().map(Object::toString).collect(Collectors.toList());
        }
        if (argsValue instanceof String) {
            return Arrays.stream(((String)argsValue).split(";")).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

