/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.webdriver.CapabilityValue;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

class CapabilitySet {
    private final EnvironmentVariables environmentVariables;
    private static final CharMatcher CAPABILITY_SEPARATOR = CharMatcher.anyOf((CharSequence)";");

    CapabilitySet(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables.copy();
    }

    public Map<String, Object> getCapabilities() {
        Map<String, Object> capabilitiesMap = new HashMap<String, Object>();
        String specifiedCapabilities = ThucydidesSystemProperty.SERENITY_DRIVER_CAPABILITIES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)specifiedCapabilities)) {
            Iterable capabilityValues = Splitter.on((CharMatcher)CAPABILITY_SEPARATOR).trimResults().split((CharSequence)specifiedCapabilities);
            capabilitiesMap = this.addCapabilityMapValues(capabilityValues);
        }
        return capabilitiesMap;
    }

    private Map<String, Object> addCapabilityMapValues(Iterable<String> capabilityValues) {
        HashMap<String, Object> capabilitiesMap = new HashMap<String, Object>();
        for (String capability : capabilityValues) {
            CapabilityToken token = new CapabilityToken(capability);
            if (!token.isDefined()) continue;
            capabilitiesMap.put(token.getName(), CapabilityValue.asObject(token.getValue()));
        }
        return capabilitiesMap;
    }

    private static class CapabilityToken {
        private final String name;
        private final String value;

        private CapabilityToken(String capability) {
            int colonIndex = capability.lastIndexOf(":");
            if (colonIndex >= 0) {
                boolean colonIndexFound = false;
                int lastIndex = capability.length();
                while (!colonIndexFound) {
                    int lastColonIndex = capability.lastIndexOf(":", lastIndex);
                    if (lastColonIndex > 0) {
                        colonIndex = lastColonIndex;
                        if (capability.length() >= colonIndex + 1 && (this.isFollowedByPathSeparator(capability, colonIndex) || this.isWithinJsonObject(capability, colonIndex))) {
                            if (lastIndex == colonIndex - 1) {
                                colonIndexFound = true;
                                break;
                            }
                            lastIndex = colonIndex - 1;
                            continue;
                        }
                        colonIndexFound = true;
                        continue;
                    }
                    colonIndexFound = true;
                }
                this.name = capability.substring(0, colonIndex);
                this.value = capability.substring(colonIndex + 1);
            } else {
                this.name = capability;
                this.value = null;
            }
        }

        private boolean isFollowedByPathSeparator(String capability, int colonIndex) {
            return capability.charAt(colonIndex + 1) == '\\' || capability.charAt(colonIndex + 1) == '/';
        }

        private boolean isWithinJsonObject(String capability, int colonIndex) {
            int openingBracketIndex = capability.indexOf(123);
            int closingBracketIndex = capability.indexOf(125);
            return openingBracketIndex > 0 && openingBracketIndex < colonIndex && colonIndex < closingBracketIndex;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isDefined() {
            return StringUtils.isNotEmpty((CharSequence)this.name) && StringUtils.isNotEmpty((CharSequence)this.value);
        }
    }
}

