/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.reports;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.serenitybdd.core.reports.AddReportContentEvent;
import net.serenitybdd.core.reports.AndContent;
import net.serenitybdd.core.reports.FromFile;
import net.serenitybdd.core.reports.WithTitle;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.session.PlaybackSession;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.ReportData;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDataSaver
implements WithTitle,
AndContent,
FromFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportDataSaver.class);
    private StepEventBus eventBus;
    private String title;
    private boolean fileIsDownloadable = false;
    private boolean isEvidence = false;

    public ReportDataSaver(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public AndContent withTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public void andContents(String contents) {
        ReportData reportData = ReportData.withTitle((String)this.title).andContents(contents).asEvidence(Boolean.valueOf(this.isEvidence));
        this.addReportContent(reportData);
    }

    private void addReportContent(ReportData reportData) {
        if (!TestSession.isSessionStarted()) {
            this.doAddContents(reportData);
        } else {
            TestSession.addEvent(new AddReportContentEvent(this, reportData));
        }
    }

    public void doAddContents(ReportData reportData) {
        if (PlaybackSession.isSessionStarted()) {
            StepEventBus playBackStepEventBus = PlaybackSession.getTestSessionContext().getStepEventBus();
            LOGGER.debug("SRP:replace event bus {} with playback event bus {}", (Object)this.eventBus, (Object)playBackStepEventBus);
            this.eventBus = playBackStepEventBus;
        }
        this.eventBus.getBaseStepListener().latestTestOutcome().ifPresent(outcome -> this.currentStepOrBackgroundIn((TestOutcome)outcome).withReportData(reportData));
    }

    private TestStep currentStepOrBackgroundIn(TestOutcome outcome) {
        if (outcome.currentStep().isPresent()) {
            return (TestStep)outcome.currentStep().get();
        }
        return (TestStep)outcome.recordStep(TestStep.forStepCalled((String)"Background").withResult(TestResult.SUCCESS)).currentStep().get();
    }

    @Override
    public void fromFile(Path source) throws IOException {
        Charset encoding = Charset.forName(ThucydidesSystemProperty.SERENITY_REPORT_ENCODING.from(this.eventBus.getEnvironmentVariables(), StandardCharsets.UTF_8.name()));
        this.fromFile(source, encoding);
    }

    @Override
    public void fromFile(Path source, Charset encoding) throws IOException {
        ReportData reportData = this.fileIsDownloadable ? ReportData.withTitle((String)this.title).fromPath(source).asEvidence(Boolean.valueOf(this.isEvidence)) : ReportData.withTitle((String)this.title).fromFile(source, encoding).asEvidence(Boolean.valueOf(this.isEvidence));
        this.addReportContent(reportData);
    }

    @Override
    public FromFile downloadable() {
        this.fileIsDownloadable = true;
        return this;
    }

    @Override
    public WithTitle asEvidence() {
        this.isEvidence = true;
        return this;
    }
}

