/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.appium;

import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.flags.GeneralServerFlag;
import io.appium.java_client.service.local.flags.ServerArgument;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.webdriver.appium.AppiumDevicePool;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppiumServerPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppiumServerPool.class);
    private static AppiumServerPool pool;
    private final Map<String, DriverService> appiumServers = Collections.synchronizedMap(new HashMap());
    private final Map<Thread, Set<DriverService>> serversByThread = Collections.synchronizedMap(new HashMap());
    private Optional<String> defaultHubUrl = Optional.empty();

    protected AppiumServerPool(EnvironmentVariables environmentVariables) {
        Optional configuredAppiumHub = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"appium.hub"});
        if (configuredAppiumHub.isPresent() && AppiumDevicePool.instance(environmentVariables).hasOnlyOneDevice()) {
            LOGGER.info("Using configured default hub url " + (String)configuredAppiumHub.get());
            this.defaultHubUrl = Optional.of((String)configuredAppiumHub.get());
        } else if (AppiumDevicePool.instance(environmentVariables).hasOnlyOneDevice()) {
            String defaultUrl = this.startDefaultAppiumServer().toString();
            LOGGER.info("Using default hub url " + defaultUrl);
            this.defaultHubUrl = Optional.of(defaultUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatus() {
        Map<String, DriverService> map = this.appiumServers;
        synchronized (map) {
            this.appiumServers.values().forEach(server -> LOGGER.info("Server status for " + String.valueOf(server.getUrl()) + " : is running = " + server.isRunning()));
        }
    }

    public static synchronized AppiumServerPool instance(EnvironmentVariables environmentVariables) {
        if (pool == null) {
            pool = new AppiumServerPool(environmentVariables);
        }
        return pool;
    }

    public static synchronized AppiumServerPool instance() {
        return AppiumServerPool.instance(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public URL urlFor(String deviceName) {
        this.logStatus();
        LOGGER.info("Finding URL for device " + deviceName);
        if (this.defaultHubUrl.isPresent()) {
            LOGGER.info("  -> Using default URL " + this.defaultHubUrl.get());
            return this.configuredAppiumUrl(this.defaultHubUrl.get());
        }
        URL localServerUrl = this.localServerUrlFor(deviceName);
        LOGGER.info("  -> Using local server URL " + String.valueOf(localServerUrl));
        return localServerUrl;
    }

    private URL localServerUrlFor(String deviceName) {
        LOGGER.info("Finding local appium server for " + deviceName);
        DriverService appiumDriverService = null;
        try {
            if (this.appiumServers.get(deviceName) != null) {
                appiumDriverService = this.appiumServers.get(deviceName);
                if (!appiumDriverService.isRunning()) {
                    LOGGER.info("  -> Restarting local appium server " + String.valueOf(appiumDriverService.getUrl()));
                    appiumDriverService.start();
                }
                return appiumDriverService.getUrl();
            }
            LOGGER.info("No local appium server found for " + deviceName + " - starting a new one");
            appiumDriverService = AppiumDriverLocalService.buildService((AppiumServiceBuilder)new AppiumServiceBuilder().withIPAddress("127.0.0.1").withArgument((ServerArgument)GeneralServerFlag.SESSION_OVERRIDE).usingAnyFreePort());
            LOGGER.info("Starting service...");
            appiumDriverService.start();
            LOGGER.info("Service started: " + String.valueOf(appiumDriverService.getUrl()));
            this.appiumServers.put(deviceName, appiumDriverService);
            this.index(appiumDriverService);
            LOGGER.info("Local appium server for " + deviceName + " started on " + String.valueOf(appiumDriverService.getUrl()));
            this.logStatus();
            return appiumDriverService.getUrl();
        }
        catch (Throwable e) {
            LOGGER.info("Failed to start appium service on " + String.valueOf(appiumDriverService.getUrl()));
            e.printStackTrace();
            LOGGER.error("Failed to start appium service on " + String.valueOf(appiumDriverService.getUrl()));
            throw new WebDriverException("Failed to start appium service on " + String.valueOf(appiumDriverService.getUrl()), e);
        }
    }

    private URL startDefaultAppiumServer() {
        LOGGER.info("Starting the default appium server");
        AppiumDriverLocalService appiumDriverService = AppiumDriverLocalService.buildDefaultService();
        this.index((DriverService)appiumDriverService);
        return appiumDriverService.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(DriverService appiumDriverService) {
        Map<Thread, Set<DriverService>> map = this.serversByThread;
        synchronized (map) {
            if (this.serversByThread.get(Thread.currentThread()) == null) {
                this.serversByThread.put(Thread.currentThread(), new HashSet());
            }
            this.serversByThread.get(Thread.currentThread()).add(appiumDriverService);
        }
    }

    private URL configuredAppiumUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid appium hub: " + url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAllServersRunningOnThread(Thread thread) {
        Map<Thread, Set<DriverService>> map = this.serversByThread;
        synchronized (map) {
            ((Set)this.serversByThread.getOrDefault(thread, new HashSet())).forEach(service -> {
                LOGGER.info("Shutting down Appium server on " + String.valueOf(service.getUrl()));
                if (service.isRunning()) {
                    service.stop();
                    LOGGER.info("Service stopped");
                } else {
                    LOGGER.info("Service was already stopped");
                }
            });
            this.serversByThread.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<URL> getActiveServersInCurrentThread() {
        Map<Thread, Set<DriverService>> map = this.serversByThread;
        synchronized (map) {
            return ((Set)this.serversByThread.getOrDefault(Thread.currentThread(), new HashSet())).stream().map(DriverService::getUrl).collect(Collectors.toSet());
        }
    }
}

