/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.csv.converters;

import java.util.Arrays;
import java.util.List;
import net.thucydides.core.csv.converters.BigDecimalTypeConverter;
import net.thucydides.core.csv.converters.BooleanTypeConverter;
import net.thucydides.core.csv.converters.IntegerTypeConverter;
import net.thucydides.core.csv.converters.StringTypeConverter;
import net.thucydides.core.csv.converters.TypeConverter;

public class TypeConverters {
    private static final List<TypeConverter> DEFAULT_TYPE_CONVERTERS = Arrays.asList(new StringTypeConverter(), new IntegerTypeConverter(), new BigDecimalTypeConverter(), new BooleanTypeConverter());

    public static List<TypeConverter> getDefaultTypeConverters() {
        return DEFAULT_TYPE_CONVERTERS;
    }

    public static TypeConverter getTypeConverterFor(Class<?> type) {
        for (TypeConverter typeConverter : DEFAULT_TYPE_CONVERTERS) {
            if (!typeConverter.appliesTo(type)) continue;
            return typeConverter;
        }
        throw new IllegalArgumentException("No applicable type converter found for " + String.valueOf(type));
    }
}

