/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.events;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.steps.events.ExampleFinishedEvent;
import net.thucydides.core.steps.events.ExampleStartedEvent;
import net.thucydides.core.steps.events.StepEventBusEvent;
import net.thucydides.core.steps.events.StepFailedEvent;
import net.thucydides.core.steps.events.StepFinishedEvent;
import net.thucydides.core.steps.events.StepIgnoredEvent;
import net.thucydides.core.steps.events.StepPendingEvent;
import net.thucydides.core.steps.events.StepStartedEvent;
import net.thucydides.core.steps.events.TestFailedEvent;
import net.thucydides.core.steps.events.TestFinishedEvent;
import net.thucydides.core.steps.events.TestStartedEvent;

public class EventTreeFormatter {
    private static final Map<Class<?>, Set<Class<?>>> SYMMETRIC_EVENTS = Map.of(ExampleStartedEvent.class, Set.of(ExampleFinishedEvent.class), TestStartedEvent.class, Set.of(TestFinishedEvent.class, TestFailedEvent.class), StepStartedEvent.class, Set.of(StepFinishedEvent.class, StepFailedEvent.class, StepIgnoredEvent.class, StepPendingEvent.class));
    private static final Set<Class<?>> STEP_COMPLETION_EVENTS = Set.of(StepFinishedEvent.class, StepFailedEvent.class, StepIgnoredEvent.class, StepPendingEvent.class);
    private static final String VERTICAL_LINE = "\u2502   ";
    private static final String BRANCH_LINE = "\u251c\u2500\u2500 ";
    private static final String LAST_BRANCH_LINE = "\u2514\u2500\u2500 ";

    public static String formatEventTree(List<StepEventBusEvent> events) {
        StringBuilder builder = new StringBuilder();
        int depth = 0;
        for (int i = 0; i < events.size(); ++i) {
            boolean isLast;
            StepEventBusEvent event = events.get(i);
            boolean bl = isLast = i == events.size() - 1;
            if (EventTreeFormatter.isStartEvent(event)) {
                EventTreeFormatter.appendEventLine(builder, event, depth, false);
                ++depth;
                continue;
            }
            if (EventTreeFormatter.isFinishEvent(event)) {
                EventTreeFormatter.appendEventLine(builder, event, --depth, isLast);
                continue;
            }
            EventTreeFormatter.appendEventLine(builder, event, depth, false);
        }
        return builder.toString();
    }

    private static boolean isStartEvent(StepEventBusEvent event) {
        return SYMMETRIC_EVENTS.containsKey(event.getClass());
    }

    private static boolean isFinishEvent(StepEventBusEvent event) {
        if (event.getClass().getSimpleName().equals("StepFinishedWithResultEvent")) {
            return true;
        }
        return SYMMETRIC_EVENTS.values().stream().anyMatch(completionEvents -> completionEvents.contains(event.getClass())) || STEP_COMPLETION_EVENTS.contains(event.getClass());
    }

    private static void appendEventLine(StringBuilder builder, StepEventBusEvent event, int depth, boolean isLast) {
        for (int i = 0; i < depth; ++i) {
            builder.append(VERTICAL_LINE);
        }
        builder.append(isLast ? LAST_BRANCH_LINE : BRANCH_LINE);
        String eventName = event.getClass().getSimpleName();
        if (eventName.endsWith("Event")) {
            eventName = eventName.substring(0, eventName.length() - 5);
        }
        builder.append(eventName);
        if (event instanceof StepStartedEvent) {
            StepStartedEvent stepEvent = (StepStartedEvent)event;
            builder.append(": ").append(stepEvent.stepDescription.getTitle());
        } else if (event instanceof TestStartedEvent) {
            TestStartedEvent testEvent = (TestStartedEvent)event;
            builder.append(": ").append(testEvent.getTestName());
        }
        builder.append("\n");
    }
}

