/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import io.appium.java_client.android.AndroidDriver;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.serenitybdd.core.SystemTimeouts;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.DevToolsNotSupportedException;
import net.thucydides.core.webdriver.DriverConfigurationError;
import net.thucydides.core.webdriver.HasAuthenticationNotSupportedException;
import net.thucydides.core.webdriver.OptionsFacade;
import net.thucydides.core.webdriver.ProvidedDriver;
import net.thucydides.core.webdriver.ProvidedDriverConfiguration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebDriverInstanceEvents;
import net.thucydides.core.webdriver.WebDriverLifecycleEvent;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.core.webdriver.stubs.CapabilitiesStub;
import net.thucydides.core.webdriver.stubs.NavigationStub;
import net.thucydides.core.webdriver.stubs.OptionsStub;
import net.thucydides.core.webdriver.stubs.TargetLocatorStub;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import net.thucydides.core.webdriver.stubs.WebElementFacadeStub;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.HasDownloads;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.PrintsPage;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.federatedcredentialmanagement.FederatedCredentialManagementDialog;
import org.openqa.selenium.federatedcredentialmanagement.HasFederatedCredentialManagement;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.virtualauthenticator.HasVirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticatorOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFacade
implements WebDriver,
JavascriptExecutor,
HasCapabilities,
HasDownloads,
HasFederatedCredentialManagement,
HasVirtualAuthenticator,
Interactive,
PrintsPage,
TakesScreenshot,
ConfigurableTimeouts,
HasAuthentication {
    private final Class<? extends WebDriver> driverClass;
    private final WebDriverFactory webDriverFactory;
    protected WebDriver proxiedWebDriver;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);
    private EnvironmentVariables environmentVariables;
    private String options = "";
    Duration implicitTimeout;

    private EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables != null) {
            return this.environmentVariables;
        }
        return SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory) {
        this.driverClass = driverClass;
        this.webDriverFactory = webDriverFactory;
        this.environmentVariables = SerenityInfrastructure.getEnvironmentVariables();
        this.implicitTimeout = this.defaultImplicitWait();
    }

    public WebDriverFacade(WebDriver driver, WebDriverFactory webDriverFactory) {
        this.driverClass = driver.getClass();
        this.proxiedWebDriver = driver;
        this.webDriverFactory = webDriverFactory;
        this.environmentVariables = SerenityInfrastructure.getEnvironmentVariables();
        this.implicitTimeout = this.defaultImplicitWait();
    }

    public WebDriverFacade(WebDriver driver, WebDriverFactory webDriverFactory, EnvironmentVariables environmentVariables) {
        this.driverClass = driver.getClass();
        this.proxiedWebDriver = driver;
        this.webDriverFactory = webDriverFactory;
        this.environmentVariables = environmentVariables;
        this.implicitTimeout = this.defaultImplicitWait();
    }

    private Duration defaultImplicitWait() {
        long configuredWaitForTimeoutInMilliseconds = new SystemTimeouts(this.environmentVariables).getImplicitTimeout();
        return Duration.ofMillis(configuredWaitForTimeoutInMilliseconds);
    }

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory, WebDriver proxiedWebDriver, Duration implicitTimeout) {
        this.driverClass = driverClass;
        this.webDriverFactory = webDriverFactory;
        this.proxiedWebDriver = proxiedWebDriver;
        this.implicitTimeout = implicitTimeout;
    }

    public WebDriverFacade withTimeoutOf(Duration implicitTimeout) {
        return new WebDriverFacade(this.driverClass, this.webDriverFactory, this.proxiedWebDriver, implicitTimeout);
    }

    public Class<? extends WebDriver> getDriverClass() {
        if (this.proxiedWebDriver != null) {
            return this.getProxiedDriver().getClass();
        }
        if (this.driverClass.isAssignableFrom(SupportedWebDriver.PROVIDED.getWebdriverClass())) {
            return new ProvidedDriverConfiguration(this.getEnvironmentVariables()).getDriverSource().driverType();
        }
        return this.driverClass;
    }

    public WebDriver getProxiedDriver() {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return new WebDriverStub();
        }
        if (this.proxiedWebDriver == null) {
            this.proxiedWebDriver = this.newProxyDriver();
            WebdriverProxyFactory.getFactory().notifyListenersOfWebdriverCreationIn(this);
        }
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.getWebdriverManager().setCurrentDriver(this);
        return this.proxiedWebDriver;
    }

    public boolean isEnabled() {
        return !StepEventBus.getParallelEventBus().webdriverCallsAreSuspended();
    }

    public void reset() {
        if (this.proxiedWebDriver != null) {
            this.forcedQuit();
        }
        this.proxiedWebDriver = null;
    }

    public void reinitializeRemoteWebDriver() {
        if (this.proxiedWebDriver != null && this.proxiedWebDriver instanceof RemoteWebDriver) {
            this.forcedQuit();
            this.proxiedWebDriver = null;
            this.initializeProxiedDriver();
        }
    }

    private void initializeProxiedDriver() {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            this.proxiedWebDriver = new WebDriverStub();
        }
        if (this.proxiedWebDriver == null) {
            this.proxiedWebDriver = this.newProxyDriver();
            WebdriverProxyFactory.getFactory().notifyListenersOfWebdriverCreationIn(this);
        }
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.getWebdriverManager().setCurrentDriver(this);
    }

    private void forcedQuit() {
        try {
            this.getDriverInstance().quit();
            this.proxiedWebDriver = null;
        }
        catch (WebDriverException e) {
            LOGGER.warn("Closing a driver that was already closed: " + e.getMessage());
        }
    }

    private WebDriver newProxyDriver() {
        return this.newDriverInstance();
    }

    private WebDriver newDriverInstance() {
        try {
            if (StepEventBus.getParallelEventBus().isDryRun()) {
                return new WebDriverStub();
            }
            this.webDriverFactory.setupFixtureServices();
            return this.webDriverFactory.newWebdriverInstance(this.driverClass, this.options, this.getEnvironmentVariables());
        }
        catch (DriverConfigurationError e) {
            throw new DriverConfigurationError("Could not instantiate " + String.valueOf(this.driverClass), e);
        }
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        if (this.proxyInstanciated() && this.driverCanTakeScreenshots()) {
            try {
                return (X)((TakesScreenshot)this.getProxiedDriver()).getScreenshotAs(target);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LOGGER.error("Failed to take screenshot - out of memory", (Throwable)outOfMemoryError);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to take screenshot (" + e.getMessage() + ")");
            }
        }
        return null;
    }

    private boolean driverCanTakeScreenshots() {
        return TakesScreenshot.class.isAssignableFrom(this.getDriverClass());
    }

    public void get(String url) {
        if (!this.isEnabled()) {
            return;
        }
        this.getProxiedDriver().get(url);
        this.setTimeouts();
    }

    private void setTimeouts() {
        this.webDriverFactory.setTimeouts(this.getProxiedDriver(), this.implicitTimeout);
    }

    public String getCurrentUrl() {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return "";
        }
        return this.getProxiedDriver().getCurrentUrl();
    }

    public String getTitle() {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return "";
        }
        return this.getProxiedDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        List elements;
        if (!this.isEnabled() || !this.isInstantiated()) {
            return Collections.emptyList();
        }
        try {
            this.webDriverFactory.setTimeouts(this.getProxiedDriver(), this.getCurrentImplicitTimeout());
            elements = this.getProxiedDriver().findElements(by);
        }
        finally {
            this.webDriverFactory.resetTimeouts(this.getProxiedDriver());
        }
        return elements;
    }

    public WebElement findElement(By by) {
        WebElement element;
        if (!this.isEnabled() || !this.isInstantiated()) {
            return new WebElementFacadeStub();
        }
        try {
            this.webDriverFactory.setTimeouts(this.getProxiedDriver(), this.getCurrentImplicitTimeout());
            element = this.getProxiedDriver().findElement(by);
        }
        finally {
            this.webDriverFactory.resetTimeouts(this.getProxiedDriver());
        }
        return element;
    }

    public String getPageSource() {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return "";
        }
        try {
            return this.getProxiedDriver().getPageSource();
        }
        catch (WebDriverException pageSourceNotSupported) {
            return "";
        }
        catch (RuntimeException pageSourceFailedForSomeReason) {
            LOGGER.warn("Failed to get the page source code (" + pageSourceFailedForSomeReason.getMessage() + ")");
            return "";
        }
    }

    @Override
    public void setImplicitTimeout(Duration implicitTimeout) {
        this.webDriverFactory.setTimeouts(this.getProxiedDriver(), implicitTimeout);
    }

    @Override
    public Duration getCurrentImplicitTimeout() {
        return this.webDriverFactory.currentTimeoutFor(this.getProxiedDriver());
    }

    @Override
    public Duration resetTimeouts() {
        return this.webDriverFactory.resetTimeouts(this.getProxiedDriver());
    }

    protected WebDriver getDriverInstance() {
        return this.proxiedWebDriver;
    }

    public void close() {
        if (this.proxyInstanciated()) {
            if (this.areWindowHandlesAllowed(this.getDriverInstance()) && this.getDriverInstance().getWindowHandles() != null && this.getDriverInstance().getWindowHandles().size() == 1) {
                this.quit();
            } else {
                WebDriverInstanceEvents.bus().notifyOf(WebDriverLifecycleEvent.CLOSE).forDriver(this.getDriverInstance());
                this.getDriverInstance().close();
            }
        }
    }

    private boolean areWindowHandlesAllowed(WebDriver driver) {
        return !(driver instanceof AndroidDriver);
    }

    public void quit() {
        if (this.proxyInstanciated()) {
            try {
                this.getDriverInstance().quit();
                this.webDriverFactory.shutdownFixtureServices();
                this.webDriverFactory.releaseTimoutFor(this.getDriverInstance());
            }
            catch (WebDriverException e) {
                LOGGER.warn("Error while quitting the driver (" + e.getMessage() + ")");
                LOGGER.debug("Caused by:" + e.getMessage(), (Throwable)e);
            }
            this.proxiedWebDriver = null;
        }
    }

    protected boolean proxyInstanciated() {
        return this.getDriverInstance() != null;
    }

    public Set<String> getWindowHandles() {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return new HashSet<String>();
        }
        return this.getProxiedDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return "";
        }
        return this.getProxiedDriver().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return new TargetLocatorStub(this);
        }
        return this.getProxiedDriver().switchTo();
    }

    public WebDriver.Navigation navigate() {
        if (!this.isEnabled()) {
            return new NavigationStub();
        }
        return this.getProxiedDriver().navigate();
    }

    public WebDriver.Options manage() {
        if (!this.isEnabled()) {
            return new OptionsStub();
        }
        return new OptionsFacade(this.getProxiedDriver().manage(), this);
    }

    public boolean canTakeScreenshots() {
        if (this.driverClass != null) {
            if (this.driverClass == ProvidedDriver.class) {
                return TakesScreenshot.class.isAssignableFrom(this.getDriverClass()) || this.getDriverClass() == RemoteWebDriver.class;
            }
            return TakesScreenshot.class.isAssignableFrom(this.driverClass) || this.driverClass == RemoteWebDriver.class;
        }
        return false;
    }

    public boolean isInstantiated() {
        return this.driverClass != null && this.proxiedWebDriver != null;
    }

    public Object executeScript(String script, Object ... parameters) {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return null;
        }
        return ((JavascriptExecutor)this.getProxiedDriver()).executeScript(script, parameters);
    }

    public Object executeAsyncScript(String script, Object ... parameters) {
        if (!this.isEnabled() || !this.isInstantiated()) {
            return null;
        }
        return ((JavascriptExecutor)this.getProxiedDriver()).executeAsyncScript(script, parameters);
    }

    public Capabilities getCapabilities() {
        if (!this.isEnabled()) {
            return new CapabilitiesStub();
        }
        return ((HasCapabilities)this.getProxiedDriver()).getCapabilities();
    }

    public String getDriverName() {
        return SupportedWebDriver.forClass(this.driverClass).name().toLowerCase();
    }

    public String toString() {
        return this.proxiedWebDriver == null ? "Uninitialised WebDriverFacade" : this.proxiedWebDriver.toString();
    }

    public WebDriverFacade withOptions(String options) {
        this.options = options;
        return this;
    }

    public boolean isAProxyFor(Class<? extends WebDriver> somedriverClass) {
        return somedriverClass.isAssignableFrom(this.getDriverClass());
    }

    public boolean isDisabled() {
        return this.proxyInstanciated() && this.proxiedWebDriver.getClass().getName().endsWith("Stub");
    }

    public void perform(Collection<Sequence> actions) {
        if (this.proxiedWebDriver instanceof Interactive) {
            ((Interactive)this.proxiedWebDriver).perform(actions);
            return;
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    public void resetInputState() {
        if (this.proxiedWebDriver instanceof Interactive) {
            ((Interactive)this.proxiedWebDriver).resetInputState();
            return;
        }
        throw new UnsupportedOperationException("Underlying driver does not implement advanced user interactions yet.");
    }

    public boolean hasDevTools() {
        return this.getProxiedDriver() instanceof HasDevTools;
    }

    public DevTools getDevTools() {
        if (this.hasDevTools()) {
            return ((HasDevTools)this.getProxiedDriver()).getDevTools();
        }
        throw new DevToolsNotSupportedException("DevTools not supported for driver " + String.valueOf(this.getProxiedDriver()));
    }

    public void register(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        this.ensureDriverSupportsTheHasAuthenticationInterface();
        ((HasAuthentication)this.getProxiedDriver()).register(whenThisMatches, useTheseCredentials);
    }

    public void register(Supplier<Credentials> alwaysUseTheseCredentials) {
        this.ensureDriverSupportsTheHasAuthenticationInterface();
        ((HasAuthentication)this.getProxiedDriver()).register(alwaysUseTheseCredentials);
    }

    private void ensureDriverSupportsTheHasAuthenticationInterface() {
        if (!(this.getProxiedDriver() instanceof HasAuthentication)) {
            throw new HasAuthenticationNotSupportedException("HasAuthentication not supported for driver " + String.valueOf(this.getProxiedDriver()));
        }
    }

    public List<String> getDownloadableFiles() {
        if (this.getProxiedDriver() instanceof HasDownloads) {
            return ((HasDownloads)this.getProxiedDriver()).getDownloadableFiles();
        }
        throw new IllegalStateException("Webdriver class " + String.valueOf(this.getProxiedDriver().getClass()) + " does not implement HasDownloads");
    }

    public void downloadFile(String fileName, Path targetLocation) throws IOException {
        if (this.getProxiedDriver() instanceof HasDownloads) {
            ((HasDownloads)this.getProxiedDriver()).downloadFile(fileName, targetLocation);
        }
    }

    public void deleteDownloadableFiles() {
        if (this.getProxiedDriver() instanceof HasDownloads) {
            ((HasDownloads)this.getProxiedDriver()).deleteDownloadableFiles();
        }
    }

    public Pdf print(PrintOptions printOptions) throws WebDriverException {
        if (this.getProxiedDriver() instanceof PrintsPage) {
            return ((PrintsPage)this.getProxiedDriver()).print(printOptions);
        }
        throw new IllegalStateException("Webdriver class " + String.valueOf(this.getProxiedDriver().getClass()) + " does not implement PrintsPage");
    }

    public void setDelayEnabled(boolean enabled) {
        if (this.getProxiedDriver() instanceof HasFederatedCredentialManagement) {
            ((HasFederatedCredentialManagement)this.getProxiedDriver()).setDelayEnabled(enabled);
        }
    }

    public void resetCooldown() {
        if (this.getProxiedDriver() instanceof HasFederatedCredentialManagement) {
            ((HasFederatedCredentialManagement)this.getProxiedDriver()).resetCooldown();
        }
    }

    public FederatedCredentialManagementDialog getFederatedCredentialManagementDialog() {
        if (this.getProxiedDriver() instanceof HasFederatedCredentialManagement) {
            return ((HasFederatedCredentialManagement)this.getProxiedDriver()).getFederatedCredentialManagementDialog();
        }
        throw new IllegalStateException("Webdriver class " + String.valueOf(this.getProxiedDriver().getClass()) + " does not implement FederatedCredentialManagementDialog");
    }

    public VirtualAuthenticator addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        if (this.getProxiedDriver() instanceof HasVirtualAuthenticator) {
            return ((HasVirtualAuthenticator)this.getProxiedDriver()).addVirtualAuthenticator(options);
        }
        throw new IllegalStateException("Webdriver class " + String.valueOf(this.getProxiedDriver().getClass()) + " does not implement VirtualAuthenticator");
    }

    public void removeVirtualAuthenticator(VirtualAuthenticator authenticator) {
        if (this.getProxiedDriver() instanceof HasVirtualAuthenticator) {
            ((HasVirtualAuthenticator)this.getProxiedDriver()).removeVirtualAuthenticator(authenticator);
        }
    }

    public void requireDownloadsEnabled(Capabilities capabilities) {
        if (this.getProxiedDriver() instanceof HasDownloads) {
            ((HasDownloads)this.getProxiedDriver()).requireDownloadsEnabled(capabilities);
        }
    }

    public boolean isDownloadsEnabled() {
        if (this.getProxiedDriver() instanceof HasDownloads) {
            return ((HasDownloads)this.getProxiedDriver()).isDownloadsEnabled();
        }
        return false;
    }

    public ScriptKey pin(String script) {
        if (this.getProxiedDriver() instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.getProxiedDriver()).pin(script);
        }
        return null;
    }

    public void unpin(ScriptKey key) {
        if (this.getProxiedDriver() instanceof JavascriptExecutor) {
            ((JavascriptExecutor)this.getProxiedDriver()).unpin(key);
        }
    }

    public Set<ScriptKey> getPinnedScripts() {
        if (this.getProxiedDriver() instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.getProxiedDriver()).getPinnedScripts();
        }
        return Collections.emptySet();
    }

    public Object executeScript(ScriptKey key, Object ... args) {
        if (this.getProxiedDriver() instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.getProxiedDriver()).executeScript(key, args);
        }
        return null;
    }
}

