/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.crossbrowsertesting;

import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;

public class CrossBrowserTestingTestSession {
    private final String user;
    private final String key;
    private final String sessionId;
    public final String API = "https://crossbrowsertesting.com/api/v3/selenium/";

    public CrossBrowserTestingTestSession(String user, String key, String sessionId) {
        this.user = user;
        this.key = key;
        this.sessionId = sessionId;
    }

    public void updateTestResultsFor(TestOutcome testOutcome) {
        String score = this.cbtCompatibleResultOf(testOutcome);
        ((HttpRequestWithBody)Unirest.put((String)("https://crossbrowsertesting.com/api/v3/selenium/" + this.sessionId)).basicAuth(this.user, this.key)).field("action", (Object)"set_score").field("score", score).asJson();
    }

    public String takeSnapshot() throws UnirestException {
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)("https://crossbrowsertesting.com/api/v3/selenium/" + this.sessionId + "/snapshots")).basicAuth(this.user, this.key)).asJson();
        return (String)((JsonNode)response.getBody()).getObject().get("hash");
    }

    public void takeSnapshot(String description) throws UnirestException {
        String hash = this.takeSnapshot();
        ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.put((String)"https://crossbrowsertesting.com/api/v3/selenium/{seleniumTestId}/snapshots/{snapshotHash}").basicAuth(this.user, this.key)).routeParam("seleniumTestId", this.sessionId)).routeParam("snapshotHash", hash)).field("description", (Object)description).asJson();
    }

    public String getPublicUrl() {
        HttpResponse response = ((GetRequest)Unirest.get((String)("https://crossbrowsertesting.com/api/v3/selenium/" + this.sessionId)).basicAuth(this.user, this.key)).asJson();
        return (String)((JsonNode)response.getBody()).getObject().get("show_result_public_url");
    }

    private String cbtCompatibleResultOf(TestOutcome outcome) {
        switch (this.latestResultOf(outcome)) {
            case SUCCESS: {
                return "pass";
            }
            case FAILURE: 
            case ERROR: 
            case COMPROMISED: {
                return "fail";
            }
        }
        return "unset";
    }

    private TestResult latestResultOf(TestOutcome outcome) {
        if (outcome.isDataDriven()) {
            return ((TestStep)outcome.getLatestTopLevelTestStep().get()).getResult();
        }
        return outcome.getResult();
    }
}

