/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.model;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.cucumber.model.StoredFeatureFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFileContents {
    private final List<String> lines;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFileContents.class);

    public FeatureFileContents(String featureFilePath) {
        this.lines = this.readFeatureFileFrom(featureFilePath);
    }

    private List<String> readFeatureFileFrom(String featureFileName) {
        try {
            File featureFile = this.featureFileWithName(featureFileName);
            return FileUtils.readLines((File)featureFile, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            LOGGER.warn("Could not find feature file " + featureFileName, (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public RowSelector betweenLine(int startRow) {
        return new RowSelector(startRow, false);
    }

    public RowSelectorBuilder trimmedContent() {
        return new RowSelectorBuilder(true);
    }

    private File featureFileWithName(String featureFileName) throws IOException {
        StoredFeatureFile theStoredFeatureFile = StoredFeatureFile.withName(featureFileName);
        if (theStoredFeatureFile.existsOnTheClasspath()) {
            return StoredFeatureFile.withName(featureFileName).onTheClasspath();
        }
        if (theStoredFeatureFile.existsOnTheFileSystem()) {
            return theStoredFeatureFile.onTheFileSystem();
        }
        return theStoredFeatureFile.fromTheConfiguredPaths();
    }

    public class RowSelectorBuilder {
        private final boolean trim;

        public RowSelectorBuilder(boolean trim) {
            this.trim = trim;
        }

        public RowSelector betweenLine(int startRow) {
            return new RowSelector(startRow, this.trim);
        }
    }

    public class RowSelector {
        private final int startRow;
        private final boolean trim;

        public RowSelector(int startRow, boolean trim) {
            this.trim = trim;
            this.startRow = startRow;
        }

        public String and(Integer endRow) {
            if (endRow >= FeatureFileContents.this.lines.size()) {
                return "";
            }
            List rows = Lists.newArrayList();
            for (int row = this.startRow; row < endRow; ++row) {
                String line = this.trim ? ((String)FeatureFileContents.this.lines.get(row)).trim() : (String)FeatureFileContents.this.lines.get(row);
                rows.add(line);
            }
            return Joiner.on((String)System.lineSeparator()).join((Iterable)rows);
        }
    }
}

